/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.item.ItemStack;

public class HudComponentHeldItemCount
extends HudComponentMovable {
    private static final ItemStack PREVIEW_ITEM = new ItemStack(Blocks.COBBLE_BASALT, 53);

    public HudComponentHeldItemCount(String key, Layout layout) {
        super(key, 53, 22, layout);
    }

    @Override
    public boolean isVisible() {
        return GameSettings.IMMERSIVE_MODE.drawOverlays() && (Boolean)GameSettings.HELD_ITEM_COUNT_OVERLAY.value != false;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)GameSettings.HELD_ITEM_COUNT_OVERLAY.value;
    }

    @Override
    public void render(HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        int xx = x + 3;
        int yy = y + 3;
        ItemStack heldItemStack = HudComponentHeldItemCount.mc.thePlayer.inventory.getCurrentItem();
        if (heldItemStack != null) {
            boolean renderItem;
            if (heldItemStack.isItemStackDamageable()) {
                renderItem = true;
                float durability = (float)(heldItemStack.getMaxDamage() - heldItemStack.getMetadata()) / (float)heldItemStack.getMaxDamage();
                int color = -16777216 + Color.HSBtoRGB(durability / 3.0f, 1.0f, 1.0f);
                int remainingDurability = heldItemStack.getMaxDamage() - heldItemStack.getMetadata() + 1;
                HudComponentHeldItemCount.mc.font.render(remainingDurability, xx + 18, yy + 4).setShadow().setColor(color).call();
            } else {
                int itemCount = 0;
                int stackCount = 0;
                for (int i = 0; i < HudComponentHeldItemCount.mc.thePlayer.inventory.getContainerSize(); ++i) {
                    ItemStack itemStack = HudComponentHeldItemCount.mc.thePlayer.inventory.getItem(i);
                    if (itemStack == null || itemStack.itemID != heldItemStack.itemID || itemStack.getMetadata() != heldItemStack.getMetadata()) continue;
                    itemCount += itemStack.stackSize;
                    ++stackCount;
                }
                boolean bl = renderItem = stackCount >= 1;
                if (renderItem) {
                    HudComponentHeldItemCount.mc.font.render(itemCount, xx + 18, yy + 4).setShadow().setColor(-1).call();
                }
            }
            if (renderItem) {
                GLRenderer.enableState(State.DEPTH_TEST);
                GLRenderer.disableState(State.BLEND);
                Lighting.enableInventoryLight();
                ItemModelDispatcher.getInstance().getDispatch(heldItemStack).renderGui(GLRenderer.getTessellator(), null, heldItemStack, xx, yy, LightmapHelper.getLightmapCoord(15, 15), partialTick);
                Lighting.disable();
            }
        }
    }

    @Override
    public void renderPreview(Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = this.getLayout().getComponentX(this, xSizeScreen);
        int y = this.getLayout().getComponentY(this, ySizeScreen);
        int xx = x + 3;
        int yy = y + 3;
        ItemStack heldItemStack = PREVIEW_ITEM;
        int itemCount = heldItemStack.stackSize;
        HudComponentHeldItemCount.mc.font.render(itemCount, xx + 18, yy + 4).setShadow().setColor(-1).call();
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.disableState(State.BLEND);
        Lighting.enableInventoryLight();
        ItemModelDispatcher.getInstance().getDispatch(heldItemStack).renderGui(GLRenderer.getTessellator(), null, heldItemStack, xx, yy, LightmapHelper.getLightmapCoord(15, 15), 0.0f);
        Lighting.disable();
    }
}

