/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;

public class PlayerInput {
    public final Minecraft mc;
    private boolean isAutoWalkOn = false;
    private boolean pressedForward;
    private boolean pressedBackward;
    private boolean pressedLeft;
    private boolean pressedRight;
    private boolean pressedJump;
    public boolean pressedLookUp;
    public boolean pressedLookDown;
    public boolean pressedLookLeft;
    public boolean pressedLookRight;
    public float moveStrafe;
    public float moveForward;
    public boolean jump;
    public boolean sneak;

    public PlayerInput(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void keyEvent(int keyCode, int mouseCode, boolean pressed) {
        if (this.mc.currentScreen != null) {
            return;
        }
        if (GameSettings.KEY_SNEAK.isKeyOrMouse(keyCode, mouseCode)) {
            if (((Boolean)GameSettings.SNEAK_TOGGLE.value).booleanValue() && !this.mc.thePlayer.noPhysics) {
                if (pressed) {
                    this.sneak = !this.sneak;
                }
            } else {
                this.sneak = pressed;
            }
        }
        if (GameSettings.KEY_FORWARD.isKeyOrMouse(keyCode, mouseCode)) {
            this.pressedForward = pressed;
            this.isAutoWalkOn = false;
        }
        if (GameSettings.KEY_BACK.isKeyOrMouse(keyCode, mouseCode)) {
            this.pressedBackward = pressed;
            this.isAutoWalkOn = false;
        }
        if (GameSettings.KEY_LEFT.isKeyOrMouse(keyCode, mouseCode)) {
            this.pressedLeft = pressed;
        }
        if (GameSettings.KEY_RIGHT.isKeyOrMouse(keyCode, mouseCode)) {
            this.pressedRight = pressed;
        }
        if (GameSettings.KEY_JUMP.isKeyOrMouse(keyCode, mouseCode)) {
            this.pressedJump = pressed;
        }
        if (GameSettings.KEY_AUTO_WALK.isKeyOrMouse(keyCode, mouseCode) && pressed) {
            this.isAutoWalkOn = true;
        }
        if (GameSettings.KEY_EASY_BRIDGE.isKeyOrMouse(keyCode, mouseCode) && pressed) {
            GameSettings.EASY_BRIDGE.toggle();
            this.mc.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.EASY_BRIDGE);
        }
    }

    public void onGameUnfocused() {
        this.pressedBackward = false;
        this.pressedForward = false;
        this.pressedLeft = false;
        this.pressedRight = false;
        this.pressedJump = false;
    }

    public void onGameFocused() {
        if (!((Boolean)GameSettings.SNEAK_TOGGLE.value).booleanValue()) {
            this.sneak = GameSettings.KEY_SNEAK.isPressed();
        }
    }

    public void tick(Player entityplayer) {
        this.moveStrafe = 0.0f;
        this.moveForward = 0.0f;
        this.jump = false;
        if (this.mc.currentScreen == null && this.mc.controllerInput != null) {
            this.moveForward = -this.mc.controllerInput.joyLeft.getY();
            this.moveStrafe = -this.mc.controllerInput.joyLeft.getX();
            this.jump = this.mc.controllerInput.buttonA.isPressed();
            if (this.mc.thePlayer.noPhysics) {
                this.sneak = this.mc.controllerInput.joyRight.getButton().isPressed();
            } else if (this.mc.controllerInput.joyRight.getButton().pressedThisFrame()) {
                boolean bl = this.sneak = !this.sneak;
            }
        }
        if (this.pressedForward || this.isAutoWalkOn) {
            this.moveForward += 1.0f;
        }
        if (this.pressedBackward) {
            this.moveForward -= 1.0f;
        }
        if (this.pressedLeft) {
            this.moveStrafe += 1.0f;
        }
        if (this.pressedRight) {
            this.moveStrafe -= 1.0f;
        }
        this.jump |= this.pressedJump;
        this.moveForward = MathHelper.clamp(this.moveForward, -1.0f, 1.0f);
        this.moveStrafe = MathHelper.clamp(this.moveStrafe, -1.0f, 1.0f);
        if (entityplayer.isSneaking() && !entityplayer.noPhysics) {
            this.moveStrafe *= 0.3f;
            this.moveForward *= 0.3f;
        }
    }
}

