/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericLamp<T extends BlockLogic>
extends BlockModelGeneric<T> {
    @NotNull
    public final @NotNull StaticBlockModel @NotNull [] models = new StaticBlockModel[16];
    @NotNull
    public final @NotNull StaticBlockModel @NotNull [] activeModels = new StaticBlockModel[16];

    public BlockModelGenericLamp(@NotNull Block<T> block, @NotNull String baseKey, @NotNull String activeKey) {
        super(block, BlockModelDispatcher.loadDataModel(String.format(baseKey, DyeColor.WHITE.colorID)));
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.models[c.blockMeta] = BlockModelDispatcher.loadDataModel(String.format(baseKey, c.colorID)).asModel();
            this.activeModels[c.blockMeta] = BlockModelDispatcher.loadDataModel(String.format(activeKey, c.colorID)).asModel();
        }
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        this.activeModels[metadata & 0xF].renderStandalone(this, tessellator, 0.0, 0.0, 0.0, metadata, lightmapCoord, (BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block));
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.models[data & 0xF];
    }
}

