/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.font.Alignment;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.client.render.tessellator.TessellatorColor;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL41;

public class FontRendererDefault
extends FontRenderer {
    @NotNull
    public final Font fallbackFont;
    @Nullable
    public final Font font;
    protected final long @NotNull [] configStack = new long[32];
    protected byte stackIndex = 0;
    protected long currentConfig = 0L;
    protected int currentTex = -1;
    protected final Random random;
    protected final List<@NotNull String> localStringList = new ArrayList<String>();
    protected final double[] localXPosBuffer = new double[1];
    protected final double[] localYPosBuffer = new double[1];
    protected final long[] localConfigBuffer = new long[1];
    protected TessellatorFont baseStringTess;
    protected TessellatorDecorations backgroundStringTess;
    private static final StringBuilder renderStringInternal_colorValue = new StringBuilder();
    private static final StringBuilder splitLineIntoConstrainedLine_lineBuilder = new StringBuilder();
    private static final StringBuilder splitLineIntoConstrainedLine_wordBuilder = new StringBuilder();

    public FontRendererDefault() {
        this(null);
    }

    public FontRendererDefault(@Nullable Font font) {
        this.fallbackFont = Fonts.UNICODE;
        this.font = font;
        this.random = new Random();
    }

    @Override
    public void init() {
        this.baseStringTess = new TessellatorFont("FontRenderDefault Base Tessellator", 262144);
        this.backgroundStringTess = new TessellatorDecorations("FontRenderDefault Deco Tessellator", 32768);
    }

    protected void renderStringInternal(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        double currX = x;
        this.random.setSeed(System.currentTimeMillis() / 50L);
        for (int i = 0; i < chars.length(); ++i) {
            Font charFont;
            int tex;
            char c = chars.charAt(i);
            if (c == '\u00a7' && i + 1 < chars.length()) {
                char cNext = chars.charAt(i + 1);
                if (cNext == '<') {
                    int offAmount = 1;
                    renderStringInternal_colorValue.setLength(0);
                    boolean ended = false;
                    for (int j = 0; j < 8; ++j) {
                        ++offAmount;
                        char pChar = chars.charAt(i + 2 + j);
                        if (pChar == '>') {
                            ended = true;
                            break;
                        }
                        renderStringInternal_colorValue.append(pChar);
                    }
                    if (ended) {
                        long colorInt = 0xFFFFFFL;
                        try {
                            colorInt = FontRendererDefault.decodeHexToLong(renderStringInternal_colorValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        this.currentConfig = SF.setColor(this.currentConfig, (colorInt & 0xFF000000L) == 0L ? (int)(colorInt & 0xFFFFFFL) | SF.getColor(baseConfig) & 0xFF000000 : (int)colorInt);
                        i += offAmount;
                        continue;
                    }
                } else {
                    int formatCode = "0123456789abcdefklmnor+-".indexOf(cNext);
                    if (formatCode != -1) {
                        switch (cNext) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                this.currentConfig = SF.setColor(this.currentConfig, Colors.allChatColors[MathHelper.clamp((int)formatCode, (int)0, (int)15)].value);
                                break;
                            }
                            case 'k': {
                                this.currentConfig = SF.setObfuscated(this.currentConfig);
                                break;
                            }
                            case 'l': {
                                this.currentConfig = SF.setBold(this.currentConfig);
                                break;
                            }
                            case 'm': {
                                this.currentConfig = SF.setStrikethrough(this.currentConfig);
                                break;
                            }
                            case 'n': {
                                this.currentConfig = SF.setUnderline(this.currentConfig);
                                break;
                            }
                            case 'o': {
                                this.currentConfig = SF.setItalic(this.currentConfig);
                                break;
                            }
                            case 'r': {
                                this.currentConfig = Integer.toUnsignedLong(SF.getColor(baseConfig)) | baseConfig & 0x2000000000L;
                                break;
                            }
                            case '+': {
                                if (this.stackIndex == this.configStack.length - 1) break;
                                this.configStack[this.stackIndex] = this.currentConfig;
                                this.stackIndex = (byte)(this.stackIndex + 1);
                                break;
                            }
                            case '-': {
                                if (this.stackIndex == 0) break;
                                this.stackIndex = (byte)(this.stackIndex - 1);
                                this.currentConfig = this.configStack[this.stackIndex];
                            }
                        }
                        ++i;
                        continue;
                    }
                }
            }
            if (this.currentTex != (tex = (charFont = font.canRenderChar(c) ? font : this.fallbackFont).textureForChar(c))) {
                this.currentTex = tex;
                Shaders.FONT.bind();
                this.baseStringTess.draw();
                GL41.glBindTexture(3553, tex);
                this.baseStringTess.startDrawing();
            }
            double off = this.renderCharInternal(charFont, this.baseStringTess, c, currX, y, z, SF.getColor(this.currentConfig), shadow);
            this.renderCharInternalDecorations(charFont, this.backgroundStringTess, c, currX, y, z, SF.getColor(this.currentConfig), shadow);
            currX += off;
        }
        if (xPosBuffer != null) {
            xPosBuffer[0] = currX;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = y + (double)font.fontHeight() + 1.0;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.currentConfig;
        }
    }

    protected double renderCharInternal(@NotNull Font font, @NotNull TessellatorFont tessellator, char c, double x, double y, double z, int color, boolean shadow) {
        double shift;
        int rgb = color & 0xFFFFFF;
        int shadowRGB = (color & 0xFCFCFC) >> 2;
        int a = (color & 0xFF000000) != 0 ? color >> 24 & 0xFF : 255;
        shadow &= !SF.isOutlined(this.currentConfig);
        double px = 1.0;
        double px2 = 2.0;
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (SF.isObfuscated(this.currentConfig) && c != ' ' && fontIndex > 0) {
            shift = font.charWidth(c);
            char randomChar = font.getObfuscatedChar(c, this.random);
            if (shadow) {
                tessellator.setColor2i(shadowRGB, a);
                font.renderChar(tessellator, randomChar, x + 1.0, y + 1.0, z, SF.isItalic(this.currentConfig));
                if (SF.isBold(this.currentConfig)) {
                    font.renderChar(tessellator, randomChar, x + 2.0, y + 1.0, z, SF.isItalic(this.currentConfig));
                }
            }
            if (SF.isOutlined(this.currentConfig)) {
                tessellator.setColor2i((rgb & 0xFCFCFC) >> 2, a);
                double width = SF.isBold(this.currentConfig) ? 2.05 : 1.05;
                for (double _x = -1.0; _x <= width; _x += 0.3333333333333333) {
                    for (double _y = -1.0; _y <= 1.05; _y += 0.3333333333333333) {
                        font.renderChar(tessellator, randomChar, x + _x, y + _y, z, SF.isItalic(this.currentConfig));
                    }
                }
            }
            tessellator.setColor2i(rgb, a);
            font.renderChar(tessellator, randomChar, x, y, z, SF.isItalic(this.currentConfig));
            if (SF.isBold(this.currentConfig)) {
                font.renderChar(tessellator, randomChar, x + 1.0, y, z, SF.isItalic(this.currentConfig));
                shift += 1.0;
            }
        } else {
            if (shadow) {
                tessellator.setColor2i(shadowRGB, a);
                font.renderChar(tessellator, c, x + 1.0, y + 1.0, z, SF.isItalic(this.currentConfig));
                if (SF.isBold(this.currentConfig)) {
                    font.renderChar(tessellator, c, x + 2.0, y + 1.0, z, SF.isItalic(this.currentConfig));
                }
            }
            if (SF.isOutlined(this.currentConfig)) {
                tessellator.setColor2i((rgb & 0xFCFCFC) >> 2, a);
                double width = SF.isBold(this.currentConfig) ? 2.05 : 1.05;
                for (double _x = -1.0; _x <= width; _x += 0.3333333333333333) {
                    for (double _y = -1.0; _y <= 1.05; _y += 0.3333333333333333) {
                        font.renderChar(tessellator, c, x + _x, y + _y, z, SF.isItalic(this.currentConfig));
                    }
                }
            }
            tessellator.setColor2i(rgb, a);
            shift = font.renderChar(tessellator, c, x, y, z, SF.isItalic(this.currentConfig));
            if (SF.isBold(this.currentConfig)) {
                font.renderChar(tessellator, c, x + 1.0, y, z, SF.isItalic(this.currentConfig));
                shift += 1.0;
            }
        }
        return shift;
    }

    protected void renderCharInternalDecorations(@NotNull Font font, @NotNull TessellatorDecorations tessellator, char c, double x, double y, double z, int color, boolean shadow) {
        double shift;
        int rgb = color & 0xFFFFFF;
        int shadowRGB = (color & 0xFCFCFC) >> 2;
        int a = (color & 0xFF000000) != 0 ? color >> 24 & 0xFF : 255;
        boolean strikethrough = SF.isStrikethrough(this.currentConfig);
        boolean underline = SF.isUnderline(this.currentConfig);
        if (!strikethrough && !underline) {
            return;
        }
        shadow &= !SF.isOutlined(this.currentConfig);
        double px = 1.0;
        double px2 = 2.0;
        int fontHeight = font.fontHeight();
        double d = shift = SF.isBold(this.currentConfig) ? (double)font.charWidth(c) + 1.0 : (double)font.charWidth(c);
        if (strikethrough) {
            if (shadow) {
                tessellator.setColor2i(shadowRGB, a);
                tessellator.addVertex(x + 1.0, y + 1.0 + (double)fontHeight / 2.0, 0.0);
                tessellator.addVertex(x + 1.0 + shift, y + 1.0 + (double)fontHeight / 2.0, 0.0);
                tessellator.addVertex(x + 1.0 + shift, y + 1.0 + (double)fontHeight / 2.0 - 1.0, 0.0);
                tessellator.addVertex(x + 1.0, y + 1.0 + (double)fontHeight / 2.0 - 1.0, 0.0);
            }
            tessellator.setColor2i(rgb, a);
            tessellator.addVertex(x, y + (double)fontHeight / 2.0, 0.0);
            tessellator.addVertex(x + shift, y + (double)fontHeight / 2.0, 0.0);
            tessellator.addVertex(x + shift, y + (double)fontHeight / 2.0 - 1.0, 0.0);
            tessellator.addVertex(x, y + (double)fontHeight / 2.0 - 1.0, 0.0);
        }
        if (underline) {
            if (shadow) {
                tessellator.setColor2i(shadowRGB, a);
                tessellator.addVertex(x, y + 2.0 + (double)fontHeight, 0.0);
                tessellator.addVertex(x + 1.0 + shift, y + 2.0 + (double)fontHeight, 0.0);
                tessellator.addVertex(x + 1.0 + shift, y + 2.0 + (double)fontHeight - 1.0, 0.0);
                tessellator.addVertex(x, y + 2.0 + (double)fontHeight - 1.0, 0.0);
            }
            tessellator.setColor2i(rgb, a);
            tessellator.addVertex(x - 1.0, y + 1.0 + (double)fontHeight, 0.0);
            tessellator.addVertex(x + shift, y + 1.0 + (double)fontHeight, 0.0);
            tessellator.addVertex(x + shift, y + 1.0 + (double)fontHeight - 1.0, 0.0);
            tessellator.addVertex(x - 1.0, y + 1.0 + (double)fontHeight - 1.0, 0.0);
        }
    }

    @Override
    public void renderDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        GLRenderer.globalSetUniforms(Shaders.COLOR);
        this.baseStringTess.startDrawing();
        this.backgroundStringTess.startDrawingQuads();
        this.renderStringInternal(font, chars, x, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
        Shaders.FONT.bind();
        this.baseStringTess.draw();
        Shaders.COLOR.bind();
        this.backgroundStringTess.draw();
        GLRenderer.popFrame();
    }

    @Override
    public void renderImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderDoubleImpl(font, chars, x, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderCenteredDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderDoubleImpl(font, chars, x - this.stringWidthDouble(chars) / 2.0, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderCenteredImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderImpl(font, chars, x - this.stringWidth(chars) / 2, y, z, shadow, baseConfig, xPosBuffer, yPosBuffer, configBuffer);
    }

    @Override
    public void renderWidthConstrainedDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double maxWidth, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        GLRenderer.globalSetUniforms(Shaders.COLOR);
        this.baseStringTess.startDrawing();
        this.backgroundStringTess.startDrawingQuads();
        double currY = y;
        switch (alignment) {
            case LEFT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
            case RIGHT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)), currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)) / 2.0, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += (double)(font.fontHeight() + 1);
                }
                break;
            }
        }
        Shaders.FONT.bind();
        this.baseStringTess.draw();
        Shaders.COLOR.bind();
        this.backgroundStringTess.draw();
        GLRenderer.popFrame();
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderWidthConstrainedImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, int maxWidth, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.globalSetUniforms(Shaders.FONT);
        Shaders.FONT.bind();
        GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
        GLRenderer.globalSetUniforms(Shaders.COLOR);
        this.baseStringTess.startDrawing();
        this.backgroundStringTess.startDrawingQuads();
        int currY = y;
        switch (alignment) {
            case LEFT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
            case RIGHT: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidth(line)), currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidth(line)) / 2, currY, z, shadow, baseConfig, this.localXPosBuffer, this.localYPosBuffer, this.localConfigBuffer);
                    currY += font.fontHeight() + 1;
                }
                break;
            }
        }
        Shaders.FONT.bind();
        this.baseStringTess.draw();
        Shaders.COLOR.bind();
        this.backgroundStringTess.draw();
        GLRenderer.popFrame();
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderConstrainedDoubleImpl(@NotNull Font font, @NotNull CharSequence chars, double x, double y, double z, boolean shadow, long baseConfig, double maxWidth, double maxHeight, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.currentTex = -1;
        this.currentConfig = baseConfig;
        this.stackIndex = 0;
        List<String> lines = this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        double currY = y;
        this.localConfigBuffer[0] = baseConfig;
        block0 : switch (alignment) {
            case LEFT: {
                GLRenderer.pushFrame();
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                GLRenderer.globalSetUniforms(Shaders.FONT);
                Shaders.FONT.bind();
                GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
                GLRenderer.globalSetUniforms(Shaders.COLOR);
                this.baseStringTess.startDrawing();
                this.backgroundStringTess.startDrawingQuads();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x, currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break;
                }
                Shaders.FONT.bind();
                this.baseStringTess.draw();
                Shaders.COLOR.bind();
                this.backgroundStringTess.draw();
                GLRenderer.popFrame();
                break;
            }
            case RIGHT: {
                GLRenderer.pushFrame();
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                GLRenderer.globalSetUniforms(Shaders.FONT);
                Shaders.FONT.bind();
                GL41.glUniform1f(Shaders.FONT.getUniform("uZ"), (float)z);
                GLRenderer.globalSetUniforms(Shaders.COLOR);
                this.baseStringTess.startDrawing();
                this.backgroundStringTess.startDrawingQuads();
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderStringInternal(font, line, x + (maxWidth - this.stringWidthDouble(line)), currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break;
                }
                Shaders.FONT.bind();
                this.baseStringTess.draw();
                Shaders.COLOR.bind();
                this.backgroundStringTess.draw();
                GLRenderer.popFrame();
                break;
            }
            case CENTERED: {
                for (int i = 0; i < lines.size(); ++i) {
                    String line = lines.get(i);
                    this.renderCenteredDoubleImpl(font, line, x + maxWidth / 2.0, currY, z, shadow, baseConfig, null, null, this.localConfigBuffer);
                    if ((currY += (double)(font.fontHeight() + 1)) - y > maxHeight) break block0;
                }
                break;
            }
        }
        if (xPosBuffer != null) {
            xPosBuffer[0] = x + maxWidth;
        }
        if (yPosBuffer != null) {
            yPosBuffer[0] = currY;
        }
        if (configBuffer != null) {
            configBuffer[0] = this.localConfigBuffer[0];
        }
    }

    @Override
    public void renderConstrainedImpl(@NotNull Font font, @NotNull CharSequence chars, int x, int y, double z, boolean shadow, long baseConfig, int maxWidth, int maxHeight, @NotNull Alignment alignment, double @Nullable [] xPosBuffer, double @Nullable [] yPosBuffer, long @Nullable [] configBuffer) {
        this.renderConstrainedDoubleImpl(font, chars, x, y, z, shadow, baseConfig, maxWidth, maxHeight, alignment, xPosBuffer, yPosBuffer, configBuffer);
    }

    protected void splitLineIntoConstrainedLine(@NotNull Font font, @NotNull CharSequence line, double maxWidth, @NotNull List<String> output) {
        double dashWidth = font.charWidthDouble('-');
        double spaceWidth = font.charWidthDouble(' ');
        double currLineWidth = 0.0;
        double currWordWidth = 0.0;
        splitLineIntoConstrainedLine_lineBuilder.setLength(0);
        splitLineIntoConstrainedLine_wordBuilder.setLength(0);
        int length = line.length();
        for (int i = 0; i < length; ++i) {
            double charWidth;
            char c = line.charAt(i);
            if (c == '\n') {
                splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)splitLineIntoConstrainedLine_wordBuilder);
                splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                currWordWidth = 0.0;
                output.add(splitLineIntoConstrainedLine_lineBuilder.toString());
                splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (c == '\t') {
                splitLineIntoConstrainedLine_wordBuilder.append("   ");
                currWordWidth += spaceWidth * 3.0;
                continue;
            }
            if (c == '\u00a7' && i + 1 < length) {
                char cN = line.charAt(i + 1);
                if (cN == '<') {
                    int offAmount = 1;
                    boolean ended = false;
                    for (int j = 0; j < 8; ++j) {
                        ++offAmount;
                        if (line.charAt(j + i + 2) != '>') continue;
                        ended = true;
                        break;
                    }
                    if (ended) {
                        splitLineIntoConstrainedLine_wordBuilder.append(line, i, i + offAmount + 1);
                        i += offAmount;
                        continue;
                    }
                } else if ("0123456789abcdefklmnor+-".indexOf(cN) != -1) {
                    splitLineIntoConstrainedLine_wordBuilder.append(line, i, i + 2);
                    ++i;
                    continue;
                }
            }
            double d = charWidth = font.canRenderChar(c) ? font.charWidthDouble(c) : this.fallbackFont.charWidthDouble(c);
            if (currWordWidth + charWidth + dashWidth > maxWidth) {
                splitLineIntoConstrainedLine_wordBuilder.append('-');
                splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)splitLineIntoConstrainedLine_wordBuilder);
                splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                splitLineIntoConstrainedLine_wordBuilder.append(c);
                currWordWidth = charWidth;
                output.add(splitLineIntoConstrainedLine_lineBuilder.toString().trim());
                splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (currLineWidth + currWordWidth + charWidth > maxWidth) {
                splitLineIntoConstrainedLine_wordBuilder.append(c);
                currWordWidth += charWidth;
                output.add(splitLineIntoConstrainedLine_lineBuilder.toString().trim());
                splitLineIntoConstrainedLine_lineBuilder.setLength(0);
                currLineWidth = 0.0;
                continue;
            }
            if (c == ' ') {
                splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)splitLineIntoConstrainedLine_wordBuilder).append(' ');
                currLineWidth += currWordWidth + spaceWidth;
                splitLineIntoConstrainedLine_wordBuilder.setLength(0);
                currWordWidth = 0.0;
                continue;
            }
            splitLineIntoConstrainedLine_wordBuilder.append(c);
            currWordWidth += charWidth;
        }
        splitLineIntoConstrainedLine_lineBuilder.append((CharSequence)splitLineIntoConstrainedLine_wordBuilder);
        String remainder = splitLineIntoConstrainedLine_lineBuilder.toString().trim();
        if (!remainder.isEmpty()) {
            output.add(remainder);
        }
    }

    @Override
    @NotNull
    public List<String> splitCharsIntoLines(@NotNull Font font, @NotNull CharSequence chars, double maxWidth, @Nullable List<String> output) {
        @NotNull ArrayList<String> o = output == null ? new ArrayList<String>() : output;
        o.clear();
        this.splitLineIntoConstrainedLine(font, chars, maxWidth, o);
        return o;
    }

    @Override
    @NotNull
    public List<String> splitLinesIntoConstrainedLines(@NotNull Font font, @NotNull List<String> lines, double maxWidth, @Nullable List<String> output) {
        @NotNull ArrayList<String> o = output == null ? new ArrayList<String>() : output;
        o.clear();
        for (int i = 0; i < lines.size(); ++i) {
            this.splitLineIntoConstrainedLine(font, lines.get(i), maxWidth, o);
        }
        return o;
    }

    @Override
    public double heightOfConstrainedChars(@NotNull Font font, @NotNull CharSequence chars, double maxWidth) {
        this.splitCharsIntoLines(chars, maxWidth, this.localStringList);
        return this.localStringList.size() * (font.fontHeight() + 1);
    }

    @Override
    public double heightOfLines(@NotNull Font font, @NotNull @NotNull List<@NotNull String> lines, double maxWidth) {
        this.splitLinesIntoConstrainedLines(lines, maxWidth, this.localStringList);
        return this.localStringList.size() * (font.fontHeight() + 1);
    }

    @Override
    public double stringWidthDouble(@NotNull Font font, @NotNull CharSequence chars) {
        double width = 0.0;
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            if (c == '\u00a7' && i + 1 < length) {
                char cN = chars.charAt(i + 1);
                if (cN == '<') {
                    int offAmount = 1;
                    boolean ended = false;
                    for (int j = i + 2; j < length; ++j) {
                        ++offAmount;
                        if (chars.charAt(j) != '>') continue;
                        ended = true;
                        break;
                    }
                    if (ended) {
                        i += offAmount;
                        continue;
                    }
                } else if ("0123456789abcdefklmnor+-".indexOf(cN) != -1) {
                    ++i;
                    continue;
                }
            }
            width += font.canRenderChar(c) ? font.charWidthDouble(c) : this.fallbackFont.charWidthDouble(c);
        }
        return width;
    }

    @Override
    @NotNull
    public Font getFont() {
        return this.font == null ? (Font)GameSettings.FONT.value : this.font;
    }

    public static int decodeHexToInt(@NotNull CharSequence hexSequence) throws NumberFormatException {
        int value = 0;
        int length = hexSequence.length();
        block18: for (int i = 0; i < length; ++i) {
            char c = hexSequence.charAt(length - i - 1);
            switch (c) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    value |= 1 << 4 * i;
                    continue block18;
                }
                case '2': {
                    value |= 2 << 4 * i;
                    continue block18;
                }
                case '3': {
                    value |= 3 << 4 * i;
                    continue block18;
                }
                case '4': {
                    value |= 4 << 4 * i;
                    continue block18;
                }
                case '5': {
                    value |= 5 << 4 * i;
                    continue block18;
                }
                case '6': {
                    value |= 6 << 4 * i;
                    continue block18;
                }
                case '7': {
                    value |= 7 << 4 * i;
                    continue block18;
                }
                case '8': {
                    value |= 8 << 4 * i;
                    continue block18;
                }
                case '9': {
                    value |= 9 << 4 * i;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    value |= 10 << 4 * i;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    value |= 11 << 4 * i;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    value |= 12 << 4 * i;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    value |= 13 << 4 * i;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    value |= 14 << 4 * i;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    value |= 15 << 4 * i;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("Illegal non hex char '" + c + "'");
                }
            }
        }
        return value;
    }

    public static long decodeHexToLong(@NotNull CharSequence hexSequence) throws NumberFormatException {
        long value = 0L;
        int length = hexSequence.length();
        block18: for (int i = 0; i < length; ++i) {
            char c = hexSequence.charAt(length - i - 1);
            switch (c) {
                case '0': {
                    continue block18;
                }
                case '1': {
                    value |= 1L << 4 * i;
                    continue block18;
                }
                case '2': {
                    value |= 2L << 4 * i;
                    continue block18;
                }
                case '3': {
                    value |= 3L << 4 * i;
                    continue block18;
                }
                case '4': {
                    value |= 4L << 4 * i;
                    continue block18;
                }
                case '5': {
                    value |= 5L << 4 * i;
                    continue block18;
                }
                case '6': {
                    value |= 6L << 4 * i;
                    continue block18;
                }
                case '7': {
                    value |= 7L << 4 * i;
                    continue block18;
                }
                case '8': {
                    value |= 8L << 4 * i;
                    continue block18;
                }
                case '9': {
                    value |= 9L << 4 * i;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    value |= 10L << 4 * i;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    value |= 11L << 4 * i;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    value |= 12L << 4 * i;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    value |= 13L << 4 * i;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    value |= 14L << 4 * i;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    value |= 15L << 4 * i;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("Illegal non hex char '" + c + "'");
                }
            }
        }
        return value;
    }

    protected static class TessellatorDecorations
    extends TessellatorBase
    implements TessellatorColor {
        private static final int VERT_SIZE = 16;
        private boolean lockColor = false;
        private int color;
        private final int vao = GL41.glGenVertexArrays();
        private final int vbo = GL41.glGenBuffers();
        private int quadVertCount = 0;

        public TessellatorDecorations(@NotNull String name, int initialCapacity) {
            super(name, initialCapacity);
            GL41.glBindVertexArray(this.vao);
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glVertexAttribPointer(0, 3, 5126, false, 16, 0L);
            GL41.glVertexAttribPointer(1, 4, 5121, true, 16, 12L);
            GL41.glVertexAttrib2f(2, 0.0f, 0.0f);
            GL41.glVertexAttrib2f(3, 0.96875f, 0.96875f);
            GL41.glVertexAttrib3f(4, 0.0f, -1.0f, 0.0f);
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glBindVertexArray(0);
        }

        @Override
        public void startDrawing(@NotNull DrawMode drawMode) {
            super.startDrawing(drawMode);
            this.lockColor = false;
            this.quadVertCount = 0;
            if (drawMode == DrawMode.QUADS) {
                this.drawMode = DrawMode.TRIANGLES;
            }
            this.setColor1i(-1);
        }

        @Override
        public void addVertex(double x, double y, double z) {
            this.checkIsDrawing();
            this.checkCanFit(64);
            this.data.putFloat((float)(this.offsetX + x));
            this.data.putFloat((float)(this.offsetY + y));
            this.data.putFloat((float)(this.offsetZ + z));
            this.data.putInt(this.color);
            ++this.vertexCount;
            if (this.quadVertCount % 4 == 2) {
                this.checkCanFit(128);
                this.data.put(this.data.position(), this.data, this.data.position() - 48, 16);
                this.data.put(this.data.position() + 16, this.data, this.data.position() - 16, 16);
                this.data.position(this.data.position() + 32);
                this.vertexCount += 2;
            }
            ++this.quadVertCount;
        }

        @Override
        public void draw() {
            if (!this.drawing) {
                throw new IllegalStateException(this.name + " already drawing!");
            }
            this.drawing = false;
            if (this.vertexCount == 0) {
                return;
            }
            GL41.glBindVertexArray(this.vao);
            GL41.glVertexAttrib2f(3, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glBufferData(34962, this.data.flip(), 35040);
            GL41.glDrawArrays(this.drawMode.cap, 0, this.vertexCount);
            GL41.glBindVertexArray(0);
        }

        @Override
        @NotNull
        public RenderBuffer record(int vao, int vbo) {
            if (!this.drawing) {
                throw new IllegalStateException(this.name + " already drawing!");
            }
            this.drawing = false;
            GL41.glBindVertexArray(this.vao);
            GL41.glVertexAttrib2f(3, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glBufferData(34962, this.data.flip(), 35044);
            GL41.glDrawArrays(this.drawMode.cap, 0, this.vertexCount);
            GL41.glBindVertexArray(0);
            return new RenderBuffer(vao, vbo, 0, this.vertexCount, this.drawMode);
        }

        @Override
        public void setColor1i(int argb) {
            this.checkIsDrawing();
            if (this.lockColor) {
                return;
            }
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            this.color = a << 24 | b << 16 | g << 8 | r;
        }

        @Override
        public void lockColor() {
            this.checkIsDrawing();
            this.lockColor = true;
        }
    }
}

