/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.CloudQuality;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.render.FrameBuffer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.shader.ShaderHelper;
import net.minecraft.client.render.shader.ShaderProvider;
import net.minecraft.client.render.shader.ShaderProviderExternal;
import net.minecraft.client.render.shader.ShaderProviderInternal;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.block.material.Materials;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class ShadersRenderer
implements Renderer {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Minecraft mc;
    protected final FrameBuffer worldFramebuffer = new FrameBuffer();
    protected final Texture worldFramebufferColor = new Texture();
    protected final Texture worldFramebufferDepth = new Texture();
    protected int worldRenderBufferObject = 0;
    protected final FrameBuffer gameFramebuffer = new FrameBuffer();
    protected final Texture gameFramebufferColor = new Texture();
    protected int gameRenderBufferObject = 0;
    protected final Shader postShader = new Shader();
    protected final Shader finalShader = new Shader();
    protected ShaderProvider internal = new ShaderProviderInternal("/shaders/");
    public int fbWidth;
    public int fbHeight;
    public int renderWidth;
    public int renderHeight;

    public ShadersRenderer(Minecraft minecraft) {
        this.mc = minecraft;
    }

    @Override
    public void beginRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre begin render game");
        this.setupFramebuffer();
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            GL41.glBindFramebuffer(36160, 0);
        }
        GL41.glUseProgram(0);
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        OpenGLHelper.checkError("begin render game");
    }

    @Override
    public void endRenderGame(float partialTicks) {
        OpenGLHelper.checkError("pre end render game");
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        GL41.glBindFramebuffer(36160, 0);
        if (this.finalShader.isEnabled()) {
            this.finalShader.bind();
            GL41.glActiveTexture(33984);
            this.gameFramebufferColor.bind();
            this.finalShader.uniformInt("colortex0", 0);
            ShaderHelper.setUniforms(this.mc, this.finalShader, partialTicks);
            ShaderHelper.drawFullscreenRect();
            GL41.glUseProgram(0);
        }
        OpenGLHelper.checkError("end render game");
    }

    @Override
    public void beginRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre begin render world");
        this.setupFramebuffer();
        this.worldFramebuffer.bind();
        GL41.glViewport(0, 0, this.renderWidth, this.renderHeight);
        GL41.glUseProgram(0);
        OpenGLHelper.checkError("begin render world");
    }

    @Override
    public void endRenderWorld(float partialTicks) {
        OpenGLHelper.checkError("pre end render world");
        if (this.finalShader.isEnabled()) {
            this.gameFramebuffer.bind();
        } else {
            GL41.glBindFramebuffer(36160, 0);
        }
        if (this.postShader.isEnabled()) {
            this.postShader.bind();
            GL41.glActiveTexture(33984);
            this.worldFramebufferColor.bind();
            this.postShader.uniformInt("colortex0", 0);
            GL41.glActiveTexture(33985);
            this.worldFramebufferDepth.bind();
            this.postShader.uniformInt("depthtex0", 1);
            GL41.glActiveTexture(33984);
            this.mc.ppm.enabled = true;
            ShaderHelper.setUniforms(this.mc, this.postShader, partialTicks);
            this.mc.ppm.enabled = false;
        } else {
            GL41.glUseProgram(0);
            this.worldFramebufferColor.bind();
        }
        GL41.glViewport(0, 0, this.fbWidth, this.fbHeight);
        ShaderHelper.drawFullscreenRect();
        LightmapHelper.instance.enableLightmapRendering();
        GL41.glUseProgram(0);
        OpenGLHelper.checkError("end render world");
    }

    @Override
    public void beginRenderClouds(float partialTicks) {
        if (((Boolean)GameSettings.CLOUDS.value).booleanValue() && GameSettings.CLOUD_QUALITY.value == CloudQuality.FANCY && Shaders.CLOUDS.isEnabled()) {
            OpenGLHelper.checkError("pre setup clouds");
            Shaders.CLOUDS.bind();
            int isEyeInLiquid = CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.LAVA, partialTicks) ? 2 : (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.currentWorld, Materials.WATER, partialTicks) ? 1 : 0);
            GL41.glUniform1i(Shaders.CLOUDS.getUniform("isEyeInLiquid"), isEyeInLiquid);
            GL41.glUseProgram(0);
            OpenGLHelper.checkError("setup clouds");
        }
    }

    @Override
    public void endRenderClouds(float partialTicks) {
    }

    @Override
    public void beginRenderParticles(float partialTick) {
    }

    @Override
    public void endRenderParticles(float partialTicks) {
    }

    public void setupFramebuffer() {
        double renderScale = (float)((RenderScale)((Object)GameSettings.RENDER_SCALE.value)).scale;
        int scaledWidth = (int)(renderScale * (double)this.mc.gameWindow.getWidthPixels());
        int scaledHeight = (int)(renderScale * (double)this.mc.gameWindow.getHeightPixels());
        if (this.fbWidth != this.mc.gameWindow.getWidthPixels() || this.fbHeight != this.mc.gameWindow.getHeightPixels() || this.renderWidth != scaledWidth || this.renderHeight != scaledHeight || !this.gameFramebuffer.isGenerated() || !this.worldFramebuffer.isGenerated()) {
            this.worldFramebuffer.generate();
            this.worldFramebufferColor.generate();
            this.worldFramebufferDepth.generate();
            this.worldRenderBufferObject = GL41.glGenRenderbuffers();
            this.gameFramebuffer.generate();
            this.gameFramebufferColor.generate();
            this.gameRenderBufferObject = GL41.glGenRenderbuffers();
            this.fbWidth = this.mc.gameWindow.getWidthPixels();
            this.fbHeight = this.mc.gameWindow.getHeightPixels();
            this.renderWidth = scaledWidth;
            this.renderHeight = scaledHeight;
            boolean filtering = ((RenderScale)((Object)GameSettings.RENDER_SCALE.value)).useLinearFiltering;
            int filterMode = filtering ? 9729 : 9728;
            LOGGER.info("Display: {} x {}, Render: {} x {}", this.fbWidth, this.fbHeight, this.renderWidth, this.renderHeight);
            this.worldFramebuffer.bind();
            this.worldFramebufferColor.bind();
            GL41.glTexImage2D(3553, 0, 6408, this.renderWidth, this.renderHeight, 0, 6408, 5121, 0L);
            GL41.glTexParameteri(3553, 10241, filterMode);
            GL41.glTexParameteri(3553, 10240, filterMode);
            GL41.glTexParameteri(3553, 10242, 33071);
            GL41.glTexParameteri(3553, 10243, 33071);
            GL41.glFramebufferTexture2D(36160, 36064, 3553, this.worldFramebufferColor.id(), 0);
            this.worldFramebufferDepth.bind();
            GL41.glTexImage2D(3553, 0, 6402, this.renderWidth, this.renderHeight, 0, 6402, 5126, 0L);
            GL41.glTexParameteri(3553, 10241, filterMode);
            GL41.glTexParameteri(3553, 10240, filterMode);
            GL41.glTexParameteri(3553, 10242, 33071);
            GL41.glTexParameteri(3553, 10243, 33071);
            GL41.glFramebufferTexture2D(36160, 36096, 3553, this.worldFramebufferDepth.id(), 0);
            this.gameFramebuffer.bind();
            this.gameFramebufferColor.bind();
            GL41.glTexImage2D(3553, 0, 6408, this.fbWidth, this.fbHeight, 0, 6408, 5121, 0L);
            GL41.glTexParameteri(3553, 10241, filterMode);
            GL41.glTexParameteri(3553, 10240, filterMode);
            GL41.glTexParameteri(3553, 10242, 33071);
            GL41.glTexParameteri(3553, 10243, 33071);
            GL41.glFramebufferTexture2D(36160, 36064, 3553, this.gameFramebufferColor.id(), 0);
            GL41.glBindRenderbuffer(36161, this.gameRenderBufferObject);
            GL41.glRenderbufferStorage(36161, 35056, this.fbWidth, this.fbHeight);
            GL41.glFramebufferRenderbuffer(36160, 33306, 36161, this.gameRenderBufferObject);
            GL41.glBindFramebuffer(36160, 0);
        }
    }

    @Override
    public void reload() {
        LOGGER.info("Reloading Shaders...");
        GL41.glUseProgram(0);
        GL41.glBindFramebuffer(36160, 0);
        OpenGLHelper.checkError("pre shader reload");
        this.postShader.delete();
        this.finalShader.delete();
        ShaderProvider shaderProvider = this.getShader();
        if (shaderProvider != null) {
            this.finalShader.compile(shaderProvider, "post/base");
            this.postShader.compile(shaderProvider, "post/post");
        }
        OpenGLHelper.checkError("shader reload");
    }

    @Override
    public void delete() {
        this.gameFramebuffer.delete();
        GL41.glDeleteRenderbuffers(this.gameRenderBufferObject);
        this.gameFramebufferColor.delete();
        this.worldFramebuffer.delete();
        GL41.glDeleteRenderbuffers(this.worldRenderBufferObject);
        this.worldFramebufferColor.delete();
        this.worldFramebufferDepth.delete();
    }

    @Override
    public void create() {
    }

    public ShaderProvider getShader() {
        String override = (String)GameSettings.SHADER_OVERRIDE.value;
        if (!override.isEmpty()) {
            return new ShaderProviderExternal(new File(override));
        }
        return this.internal;
    }

    public Texture getWorldFramebufferColor() {
        return this.worldFramebufferColor;
    }

    @Override
    public int getRenderWidth() {
        return this.renderWidth;
    }

    @Override
    public int getRenderHeight() {
        return this.renderHeight;
    }
}

