/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.overworld;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.overworld.ChunkGeneratorOverworld;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import org.jetbrains.annotations.NotNull;

public class WorldTypeOverworld
extends WorldType {
    public WorldTypeOverworld(WorldType.Properties properties) {
        super(properties);
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(75000L);
    }

    @NotNull
    public static WorldType.Properties defaultProperties(@NotNull String translationKey) {
        return WorldType.Properties.of(translationKey).brightnessRamp(WorldTypeOverworld.createLightRamp()).seasonConfig(SeasonConfig.builder().withSeasonInCycle(Seasons.OVERWORLD_SPRING, 14).withSeasonInCycle(Seasons.OVERWORLD_SUMMER, 14).withSeasonInCycle(Seasons.OVERWORLD_FALL, 14).withSeasonInCycle(Seasons.OVERWORLD_WINTER, 14).build()).oceanBlock(Blocks.FLUID_WATER_STILL).fillerBlock(Blocks.STONE).allowRespawn();
    }

    public static float[] createLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderOverworld(world.getRandomSeed(), this);
    }

    @Override
    @NotNull
    public @NotNull Biome @NotNull [] allBiomes() {
        return BiomeProviderOverworld.allBiomes();
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorOverworld(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return world.getBlockId(x, y, z) == Blocks.SAND.id();
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return this.getTimeOfDay(world, tick, partialTick);
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        float f1 = this.getCelestialAngle(world, tick, partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float weatherOffset = 0.0f;
        Weather currentWeather = world.getCurrentWeather();
        if (currentWeather != null) {
            weatherOffset = (float)currentWeather.getLightLevelSubtracted() * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower();
        }
        return (int)(f2 * (11.0f - weatherOffset) + weatherOffset);
    }
}

