/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Global;
import net.minecraft.core.enums.EnumOS;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GLCapabilities;
import org.slf4j.Logger;

public class OpenGLHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> errors = new HashSet<String>();
    public static int[] versionPairs = new int[]{4, 6, 4, 3, 4, 1};
    public static boolean contextCreated = false;
    public static boolean gl46 = false;
    public static boolean gl43 = false;
    @NotNull
    public static String version = "Unknown";
    @NotNull
    public static String vendor = "Unknown";
    @NotNull
    public static String renderer = "Unknown";

    public static void testCapabilities(@NotNull GLCapabilities capabilities) {
        contextCreated = true;
        LOGGER.info("");
        LOGGER.info("=== GPU VENDOR INFO ===");
        LOGGER.info("OpenGL {}.{}", (Object)GL41.glGetInteger(33307), (Object)GL41.glGetInteger(33308));
        version = Objects.requireNonNullElse(GL41.glGetString(7938), "Query Failure");
        vendor = Objects.requireNonNullElse(GL41.glGetString(7936), "Query Failure");
        renderer = Objects.requireNonNullElse(GL41.glGetString(7937), "Query Failure");
        LOGGER.info(version);
        LOGGER.info(vendor);
        LOGGER.info(renderer);
        LOGGER.info("");
        LOGGER.info("GL_ARB_framebuffer_object: {}", (Object)capabilities.GL_ARB_framebuffer_object);
        LOGGER.info("GL_ARB_occlusion_query: {}", (Object)capabilities.GL_ARB_occlusion_query);
        LOGGER.info("GL_NV_fog_distance: {}", (Object)capabilities.GL_NV_fog_distance);
        gl43 = capabilities.OpenGL43;
        gl46 = capabilities.OpenGL46;
        if (!capabilities.OpenGL41) {
            if (Minecraft.getOs() == EnumOS.macos) {
                LOGGER.warn("BTA Requires OpenGL4.1 but only {} was found! If you're on MacOS this is probably just Apple misreporting the GLVersion number and not actually due to a lack of support.", (Object)GL41.glGetString(7938));
            } else {
                LOGGER.error("BTA Requires OpenGL4.1 but only {} was found!", (Object)GL41.glGetString(7938));
            }
        }
    }

    public static void checkError(String info) {
        int errorCode;
        if (Global.DEBUG_MODE && (errorCode = GL41.glGetError()) != 0) {
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                throw new RuntimeException("OpenGL Error " + error);
            }
            if (!errors.contains(info)) {
                errors.add(info);
                String error = errorCode + " (" + OpenGLHelper.getErrorDescription(errorCode) + "): " + info;
                LOGGER.error("########## GL ERROR ##########");
                LOGGER.error("OpenGL Error {}", (Object)error);
            }
        }
    }

    public static String getErrorDescription(int error) {
        if (error == 1280) {
            return "Invalid Enum";
        }
        if (error == 1281) {
            return "Invalid Value";
        }
        if (error == 1282) {
            return "Invalid Operation";
        }
        if (error == 1286) {
            return "Invalid Framebuffer Operation";
        }
        if (error == 1285) {
            return "Out of Memory";
        }
        if (error == 1284) {
            return "Stack Underflow";
        }
        if (error == 1283) {
            return "Stack Overflow";
        }
        return "Unknown Error";
    }
}

