/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.particle.ParticleBlockBreaking;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorParticleShader;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public final class ParticleEngine {
    public static final int WORLD_TEXTURE = 0;
    public static final int ENTITY_PARTICLE_TEXTURE = 1;
    public static final int TEXTURE_COUNT = 2;
    @NotNull
    private final TessellatorParticleShader shaderParticleTessellator = new TessellatorParticleShader(160000);
    private World world;
    private final List<Particle>[] particles = new ObjectArrayList[2];
    private final Random rand = new Random();

    public ParticleEngine(World world) {
        if (world != null) {
            this.world = world;
        }
        for (int i = 0; i < this.particles.length; ++i) {
            this.particles[i] = new ObjectArrayList<Particle>();
        }
    }

    public void add(Particle p) {
        int t = p.getParticleTexture();
        if (this.particles[t].size() >= (Integer)GameSettings.PARTICLES_CAP.value) {
            this.particles[t].remove(0);
        }
        this.particles[t].add(p);
        p.init();
    }

    public void tick() {
        for (int tt = 0; tt < this.particles.length; ++tt) {
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.tick();
                if (!p.removed) continue;
                this.particles[tt].remove(i--);
            }
        }
    }

    public void renderParticles(@NotNull ICamera camera, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.PARTICLE);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setDepthFunc(CompareFunc.LESS);
        TessellatorParticleShader tessellator = this.shaderParticleTessellator;
        tessellator.setupParticleValues(camera, partialTick);
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        for (int tt = 0; tt <= 0; ++tt) {
            if (this.particles[tt].isEmpty()) continue;
            TextureRegistry.worldAtlas.bind();
            tessellator.setTranslation(-xOff, -yOff, -zOff);
            tessellator.startDrawingParticles();
            for (int i = 0; i < this.particles[tt].size(); ++i) {
                Particle p = this.particles[tt].get(i);
                p.render(tessellator, partialTick);
            }
            tessellator.drawParticles();
        }
        tessellator.setTranslation(0.0, 0.0, 0.0);
        GLRenderer.popFrame();
    }

    public void renderLitParticles(ICamera camera, float partialTick) {
        int tt = 1;
        if (this.particles[tt].isEmpty()) {
            return;
        }
        double xOff = camera.getX(partialTick);
        double yOff = camera.getY(partialTick);
        double zOff = camera.getZ(partialTick);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        for (int i = 0; i < this.particles[tt].size(); ++i) {
            Particle p = this.particles[tt].get(i);
            p.renderLit(tessellator, partialTick, xOff, yOff, zOff);
        }
    }

    public void setWorld(World world) {
        this.world = world;
        for (int i = 0; i < 2; ++i) {
            this.particles[i].clear();
        }
    }

    public void destroy(@NotNull TilePosc blockPos, int id, int data) {
        int amount;
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.NONE) {
            return;
        }
        Block<?> block = Blocks.blocksList[id];
        if (block == null) {
            return;
        }
        int n = amount = GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.REDUCED ? 2 : 4;
        if (block == Blocks.FIRE) {
            return;
        }
        for (int xx = 0; xx < amount; ++xx) {
            for (int yy = 0; yy < amount; ++yy) {
                for (int zz = 0; zz < amount; ++zz) {
                    double xp = (double)blockPos.x() + ((double)xx + 0.5) / (double)amount;
                    double yp = (double)blockPos.y() + ((double)yy + 0.5) / (double)amount;
                    double zp = (double)blockPos.z() + ((double)zz + 0.5) / (double)amount;
                    Side side = Side.getSideById(this.rand.nextInt(6));
                    this.add(new ParticleBlockBreaking(this.world, xp, yp, zp, xp - (double)blockPos.x() - 0.5, yp - (double)blockPos.y() - 0.5, zp - (double)blockPos.z() - 0.5, block, side, data).init(blockPos));
                }
            }
        }
    }

    public void crack(@NotNull TilePosc blockPos, @NotNull Side side) {
        if (GameSettings.PARTICLES_QUALITY.value == ParticlesQuality.NONE) {
            return;
        }
        Block<?> block = this.world.getBlockType(blockPos);
        if (block == Blocks.AIR) {
            return;
        }
        AABBdc bounds = block.getBounds();
        float r = 0.1f;
        double xp = (double)blockPos.x() + this.rand.nextDouble() * (bounds.maxX() - bounds.minX() - (double)(r * 2.0f)) + (double)r + bounds.minX();
        double yp = (double)blockPos.y() + this.rand.nextDouble() * (bounds.maxY() - bounds.minY() - (double)(r * 2.0f)) + (double)r + bounds.minY();
        double zp = (double)blockPos.z() + this.rand.nextDouble() * (bounds.maxZ() - bounds.minZ() - (double)(r * 2.0f)) + (double)r + bounds.minZ();
        if (side == Side.BOTTOM) {
            yp = (double)blockPos.y() + bounds.minY() - (double)r;
        } else if (side == Side.TOP) {
            yp = (double)blockPos.y() + bounds.maxY() + (double)r;
        } else if (side == Side.NORTH) {
            zp = (double)blockPos.z() + bounds.minZ() - (double)r;
        } else if (side == Side.SOUTH) {
            zp = (double)blockPos.z() + bounds.maxZ() + (double)r;
        } else if (side == Side.WEST) {
            xp = (double)blockPos.x() + bounds.minX() - (double)r;
        } else if (side == Side.EAST) {
            xp = (double)blockPos.x() + bounds.maxX() + (double)r;
        }
        this.add(new ParticleBlockBreaking(this.world, xp, yp, zp, 0.0, 0.0, 0.0, block, side, this.world.getBlockData(blockPos)).init(blockPos).setPower(0.2f).setScale(0.6f));
    }

    public int countParticles() {
        return this.particles[0].size() + this.particles[1].size();
    }
}

