/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.uniform;

import java.nio.ByteBuffer;
import net.minecraft.client.render.uniform.BufferAdapter;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;

public class UniformBlock<T> {
    public static final int N = 4;
    @NotNull
    public final String name;
    public final int index;
    public final int ubo;
    @NotNull
    public final ByteBuffer buffer;
    @NotNull
    public final BufferAdapter<T> adapter;

    public UniformBlock(@NotNull String name, int index, int size, @NotNull BufferAdapter<T> adapter) {
        assert (size % 4 == 0) : "Size must be a multiple of GL's uniform slot size!";
        this.name = name;
        this.index = index;
        this.adapter = adapter;
        this.buffer = BufferUtils.createByteBuffer(size);
        this.ubo = GL41.glGenBuffers();
        GL41.glBindBuffer(35345, this.ubo);
        GL41.glBufferData(35345, size, 35048);
        GL41.glBindBuffer(35345, 0);
        GL41.glBindBufferRange(35345, index, this.ubo, 0L, size);
    }
}

