/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pos.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkProviderClient
implements IChunkProvider {
    @NotNull
    protected static final ChunkPos MIN_POS = new ChunkPos(Integer.MIN_VALUE, Integer.MIN_VALUE);
    @NotNull
    private final Chunk blankChunk;
    @NotNull
    private final Map<ChunkPos, Chunk> chunkMapping = new Object2ObjectOpenHashMap<ChunkPos, Chunk>();
    @NotNull
    private final World world;
    @NotNull
    protected Chunk lastQueriedChunk;
    @NotNull
    protected ChunkPos lastQueriedChunkPos = MIN_POS;

    public ChunkProviderClient(@NotNull World world) {
        this.lastQueriedChunk = this.blankChunk = new EmptyChunk(world, new ChunkPos(0, 0));
        this.world = world;
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        if (chunkPos.equals(this.lastQueriedChunkPos)) {
            return true;
        }
        if (this.chunkMapping.containsKey(chunkPos)) {
            this.lastQueriedChunkPos = new ChunkPos(chunkPos);
            this.lastQueriedChunk = this.chunkMapping.get(chunkPos);
            return true;
        }
        return false;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
    }

    public void dropChunk(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isChunkEmpty()) {
            chunk.onUnload();
        }
        this.chunkMapping.remove(chunkPos);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        if (this.chunkMapping.containsKey(chunkPos)) {
            return this.chunkMapping.get(chunkPos);
        }
        Chunk chunk = new Chunk(this.world, new ChunkPos(chunkPos));
        this.chunkMapping.put(chunk.pos, chunk);
        chunk.isLoaded = true;
        return chunk;
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        if (chunkPos.equals(this.lastQueriedChunkPos)) {
            return this.lastQueriedChunk;
        }
        Chunk chunk = this.chunkMapping.get(chunkPos);
        if (chunk != null) {
            this.lastQueriedChunkPos = chunkPos;
            this.lastQueriedChunk = chunk;
            return chunk;
        }
        return this.blankChunk;
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
    }

    @Override
    public boolean canSave() {
        return false;
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "MultiplayerChunkCache: " + this.chunkMapping.size();
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
    }
}

