/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.Gamemodes;

public class ArgumentTypeGameMode
implements ArgumentType<Gamemode> {
    private static final Collection<String> EXAMPLES = Arrays.asList(Gamemodes.CREATIVE.getId(), Gamemodes.SURVIVAL.getId());

    public static ArgumentType<Gamemode> gameMode() {
        return new ArgumentTypeGameMode();
    }

    @Override
    public Gamemode parse(StringReader reader) throws CommandSyntaxException {
        char peak;
        StringBuilder builder = new StringBuilder();
        while (reader.canRead() && (peak = reader.peek()) != '[' && peak != '{' && peak != ' ') {
            builder.append(reader.read());
        }
        String string = builder.toString();
        Object gamemodeString = string;
        if (!string.contains(":")) {
            if (!string.contains("gamemode/")) {
                gamemodeString = "gamemode/" + string;
            }
        } else {
            int colonIndex = string.indexOf(":");
            String namespace = string.substring(0, colonIndex);
            String value = string.substring(colonIndex + 1);
            if (!string.contains("gamemode/")) {
                gamemodeString = namespace + ":gamemode/" + value;
            }
        }
        for (Gamemode gamemode : Registries.GAMEMODES) {
            if (!CommandHelper.matchesKeyString(gamemode.getId(), (String)gamemodeString)) continue;
            return gamemode;
        }
        try {
            return Gamemodes.getGamemodeByLegacyId(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new CommandSyntaxException(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument(), () -> I18n.getInstance().translateKey("command.argument_types.game_mode.invalid_game_mode"));
        }
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemainingLowerCase();
        for (Gamemode gamemode : Registries.GAMEMODES) {
            String id = gamemode.getId();
            Optional<String> optional = id.startsWith("minecraft:") ? CommandHelper.getStringToSuggest(gamemode.getId().replace("minecraft:gamemode/", ""), remaining) : CommandHelper.getStringToSuggest(gamemode.getId().replace("gamemode/", ""), remaining);
            optional.ifPresent(builder::suggest);
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

