/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryMobSpawningComponent
extends ButtonComponent {
    @Nullable
    private WorldConfiguration worldConfiguration = null;
    @NotNull
    private final SwitchElement button;
    @NotNull
    private final Type type;

    public CategoryMobSpawningComponent(@NotNull Type type) {
        super(type.getKey(), null);
        this.type = type;
        this.button = new SwitchElement(0, 0, 0, 150, 20, true, I18n.getInstance().translateKey("gui.world_settings.page.mob_spawning.button.on"), I18n.getInstance().translateKey("gui.world_settings.page.mob_spawning.button.off"));
        this.button.setOn(true);
    }

    public void setSpawnConfiguration(@NotNull WorldConfiguration worldConfiguration) {
        this.worldConfiguration = worldConfiguration;
    }

    @Override
    public void resetValue() {
        this.type.setValue(this.worldConfiguration, true);
        this.onChange();
    }

    @Override
    public void init(Minecraft mc) {
        this.onChange();
    }

    @Override
    public boolean isDefault() {
        return this.button.isOn();
    }

    protected void onChange() {
        this.button.setOn(this.type.getValue(this.worldConfiguration));
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.type.setValue(this.worldConfiguration, !this.type.getValue(this.worldConfiguration));
        this.onChange();
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (CategoryMobSpawningComponent.mc.currentScreen != null && relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            CategoryMobSpawningComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }

    public static enum Type {
        HOSTILE("hostile"),
        PASSIVE("passive");

        @NotNull
        private final String key;

        private Type(String key) {
            this.key = "gui.world_settings.page.mob_spawning." + key;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        public void setValue(@NotNull WorldConfiguration worldConfiguration, boolean flag) {
            if (this == HOSTILE) {
                worldConfiguration.getSpawnerConfig().setHostileSpawning(flag);
            } else {
                worldConfiguration.getSpawnerConfig().setPassiveSpawning(flag);
            }
        }

        public boolean getValue(@NotNull WorldConfiguration worldConfiguration) {
            if (this == HOSTILE) {
                return worldConfiguration.getSpawnerConfig().allowHostile;
            }
            return worldConfiguration.getSpawnerConfig().allowPassive;
        }
    }
}

