/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import com.mojang.logging.LogUtils;
import net.minecraft.client.option.Option;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class OptionColor
extends Option<Color> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public OptionColor(@NotNull String name, @NotNull Color defaultValue) {
        super(name, defaultValue);
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        try {
            ((Color)this.value).parse(string);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse color for '{}'!", (Object)string, (Object)e);
        }
    }

    @Override
    @NotNull
    public String toOptionsString() {
        return ((Color)this.value).toPropertiesString();
    }
}

