/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.entity.MobRendererBipedArmored;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.BlocksContainer;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class MobRendererPlayer
extends MobRendererBipedArmored<Player> {
    private BlocksContainer container = null;

    public MobRendererPlayer() {
        super(0.5f);
    }

    @NotNull
    protected StaticEntityModel getActiveModel(@NotNull Player player, boolean onlyArms) {
        Specials specials = Specials.getSpecialsForPlayer(player);
        if (onlyArms) {
            if (specials != null && specials.armsModelReference != null) {
                return this.getModel(specials.armsModelReference);
            }
            return player.slimModel ? this.getModel("arms.slim") : this.getModel("arms");
        }
        if (specials != null) {
            return this.getModel(specials.mainModelReference);
        }
        return player.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }

    public void drawFirstPersonHand(@NotNull TessellatorGeneral tessellator, @NotNull Player player, boolean isLeft) {
        StaticEntityModel activeModel = this.getActiveModel(player, true);
        activeModel.resetBones();
        activeModel.getTransform((String)"leftSleeve").visible = player.playerConfig.sleeveLeftEnabled();
        activeModel.getTransform((String)"rightSleeve").visible = player.playerConfig.sleeveRightEnabled();
        if (isLeft) {
            activeModel.getTransform((String)"rightArm").visible = false;
        } else {
            activeModel.getTransform((String)"leftArm").visible = false;
        }
        activeModel.render();
    }

    public void drawHeldObject(Player player, float partialTick) {
        ICarriable iCarriable = player.getHeldObject();
        if (iCarriable instanceof CarriedBlock) {
            CarriedBlock carriedBlock = (CarriedBlock)iCarriable;
            if (this.container == null || this.container.world != player.world) {
                this.container = new BlocksContainer(player.world);
            }
            TessellatorShader tessellator = GLRenderer.getTessellator();
            TextureRegistry.worldAtlas.bind();
            GLRenderer.pushFrame();
            Lighting.disable();
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.disableState(State.CULL_FACE);
            GLRenderer.modelM4f().scale(0.55f, -0.55f, 0.55f);
            GLRenderer.modelM4f().translate(0.0f, -0.75f, -0.75f);
            TilePos blockPos = new TilePos(player.x, player.y + 1.0, player.z);
            tessellator.startDrawingQuads();
            tessellator.setTranslation((double)(-blockPos.x) - 0.5, (double)(-blockPos.y) - 0.5, (double)(-blockPos.z) - 0.5);
            this.container.setLightReferenceEntity(player);
            this.container.partialTick = partialTick;
            this.container.setBlock(blockPos.x, blockPos.y, blockPos.z, carriedBlock.blockId, carriedBlock.metadata, carriedBlock.entity);
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(carriedBlock.block())).renderNoCulling(GLRenderer.getTessellator(), this.container, blockPos);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            this.container.setLightReferenceEntity(null);
            this.container.clear();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(carriedBlock.entity);
            if (renderer != null) {
                carriedBlock.entity.worldObj = player.world;
                renderer.doRender(tessellator, carriedBlock.entity, -0.5, -0.5, -0.5, partialTick);
                carriedBlock.entity.worldObj = null;
            }
            GLRenderer.popFrame();
        }
    }

    @Override
    protected void renderSpecials(@NotNull TessellatorGeneral t, @NotNull Player entity, double x, double y, double z) {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.thePlayer.getGamemode() != Gamemodes.SPECTATOR && entity.getGamemode() == Gamemodes.SPECTATOR) {
            return;
        }
        if (GameSettings.IMMERSIVE_MODE.drawNames() && mc.activeCamera != null) {
            float f3;
            ICamera iCamera = mc.activeCamera;
            if (iCamera instanceof EntityCamera) {
                EntityCamera entityCamera = (EntityCamera)iCamera;
                if (entityCamera.mob == entity) {
                    return;
                }
            }
            float f = 1.6f;
            float f1 = 0.026666671f;
            float f2 = (float)mc.activeCamera.distanceTo(entity);
            float f4 = f3 = entity.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entity.getDisplayName();
                if (!entity.isSneaking()) {
                    if (entity.isPlayerSleeping()) {
                        this.renderLivingLabel(t, entity, s, x, y - 1.5, z, 64, false);
                    } else {
                        this.renderLivingLabel(t, entity, s, x, y, z, 64, false);
                    }
                } else {
                    FontRenderer font = this.getFont();
                    GLRenderer.pushFrame();
                    GLRenderer.modelM4f().translate((float)x + 0.0f, (float)y + 2.3f, (float)z);
                    GLRenderer.modelM4f().rotateY(Math.toRadians(-this.renderDispatcher.viewLerpYaw));
                    GLRenderer.modelM4f().rotateX(Math.toRadians(this.renderDispatcher.viewLerpPitch));
                    GLRenderer.modelM4f().scale(-0.026666671f, -0.026666671f, 0.026666671f);
                    GLRenderer.globalSetLightEnabled(false);
                    GLRenderer.modelM4f().translate(0.0f, 9.374998f, 0.0f);
                    GLRenderer.setDepthMask(false);
                    GLRenderer.enableState(State.BLEND);
                    GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                    GLRenderer.pushFrame();
                    GLRenderer.setShader(Shaders.COLOR);
                    t.startDrawingQuads();
                    int halfWidth = font.stringWidth(s) / 2;
                    t.setColor4f(0.0f, 0.0f, 0.0f, 0.25f);
                    t.addVertex(-halfWidth - 1, -1.0, 0.0);
                    t.addVertex(-halfWidth - 1, 8.0, 0.0);
                    t.addVertex(halfWidth + 1, 8.0, 0.0);
                    t.addVertex(halfWidth + 1, -1.0, 0.0);
                    t.draw();
                    GLRenderer.popFrame();
                    GLRenderer.setDepthMask(true);
                    font.renderCentered(s, 0, 0).setColor(0x20FFFFFF).call();
                    GLRenderer.globalSetLightEnabled(true);
                    GLRenderer.disableState(State.BLEND);
                    GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                    GLRenderer.popFrame();
                }
            }
        }
    }

    @Override
    protected void preRenderTransform(@NotNull Player entity, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            GLRenderer.modelM4f().translate(entity.sleepOffX, entity.sleepOffY, entity.sleepOffZ);
            GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
            GLRenderer.modelM4f().translate(0.0f, -4.5f, 0.0f);
            GLRenderer.modelM4f().rotateY(Math.toRadians(-entity.getBedOrientationInDegrees()));
            GLRenderer.modelM4f().rotateZ(Math.toRadians(this.getMaxDeathRotation(entity)));
            GLRenderer.modelM4f().rotateY(Math.toRadians(270.0f));
        } else {
            GLRenderer.modelM4f().rotateY(-this.getBodyYaw(entity, partialTick));
            GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
        }
        if (entity.deathTime > 0) {
            float rotationProgress = ((float)entity.deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GLRenderer.modelM4f().rotateZ(Math.toRadians(rotationProgress * this.getMaxDeathRotation(entity)));
        }
        float scale = 0.9375f;
        GLRenderer.modelM4f().scale(0.9375f, 0.9375f, 0.9375f);
        if (entity.isDwarf()) {
            GLRenderer.modelM4f().scale(0.6f, 0.5f, 0.6f);
        }
        if (Specials.getSpecialsForPlayer(entity) == Specials.MELON || Specials.getSpecialsForPlayer(entity) == Specials.WATERMELON) {
            GLRenderer.modelM4f().scale(0.9f, 0.9f, 0.9f);
        }
    }

    @Override
    protected void renderAdditional(@NotNull TessellatorGeneral tessellator, @NotNull Player player, float partialTick) {
        StaticEntityModel activeModel = this.getActiveModel(player, false);
        super.renderAdditional(tessellator, player, partialTick);
        if (player.playerConfig.capeEnabled()) {
            boolean renderCape = this.bindDownloadableTexture("https://api.betterthanadventure.net/capes?username=" + player.username, null, null);
            if (!renderCape) {
                renderCape = this.bindDownloadableTexture(player.capeURL, null, null);
            }
            if (renderCape) {
                GLRenderer.pushFrame();
                GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                GLRenderer.modelM4f().translate(0.0f, 0.0f, 0.125f);
                float yawOff = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialTick;
                float bodyAngle = 5.0f;
                double xd = MathHelper.lerp(player.xdO, player.xd, (double)partialTick);
                double yd = java.lang.Math.min(MathHelper.lerp(player.ydO, player.yd, (double)partialTick), 0.0);
                double zd = MathHelper.lerp(player.zdO, player.zd, (double)partialTick);
                double vel = -1.0 / (3.0 * java.lang.Math.hypot(xd, zd) + 1.0) + 1.0;
                double moveAng = java.lang.Math.atan2(xd, zd);
                double yawRad = java.lang.Math.toRadians(yawOff);
                double multiplier = 1.0 - java.lang.Math.abs((java.lang.Math.cos(yawRad) + 1.0 - (java.lang.Math.cos(moveAng) + 1.0) + 2.0) / 2.0 - 1.0);
                player.wobbleTimer += (float)((double)((float)player.tickCount + partialTick - (float)player.lastRenderTick) / (30.0 - 29.0 * MathHelper.clamp(vel, 0.0, 1.0)));
                player.lastRenderTick = player.tickCount;
                double wobble = java.lang.Math.sin(player.wobbleTimer) * (1.5 + 4.5 * vel * multiplier);
                activeModel.translateToBone("cape");
                StaticEntityModel cape = this.getModel("cape");
                cape.getTransform((String)"cape").rotX = -MathHelper.clamp(MathHelper.clamp(5.0 + vel * 100.0 * multiplier, 5.0, 100.0) + wobble - yd * 60.0, 0.0, 180.0) * (double)MathHelper.DEG_TO_RAD;
                cape.render();
                GLRenderer.popFrame();
            }
        }
        if (player.getHeldObject() != null) {
            float walkSpeed = player.walkAnimSpeedO + (player.walkAnimSpeed - player.walkAnimSpeedO) * partialTick;
            float walkProgress = player.walkAnimPos - player.walkAnimSpeed * (1.0f - partialTick);
            float swingProgress = player.getSwingProgress(partialTick);
            float swing = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)java.lang.Math.PI * -2.0f) * 0.4f;
            GLRenderer.modelM4f().translate(0.0f, (MathHelper.cos(walkProgress / 2.0f * 2.0f / 3.0f + (float)java.lang.Math.PI) / 12.0f * walkSpeed + 0.1f - swing / 4.0f) * 16.0f, 0.0f);
            GLRenderer.modelM4f().translate(0.0f, 20.0f, 0.0f);
            if (player.isSneaking()) {
                GLRenderer.modelM4f().translate(0.0f, 0.0f, 4.0f);
            }
            GLRenderer.modelM4f().scale(-16.0f, -16.0f, 16.0f);
            this.drawHeldObject(player, partialTick);
        }
    }

    @Override
    @Nullable
    protected StaticEntityModel getActiveModel(@NotNull Player entity) {
        Specials specials = Specials.getSpecialsForPlayer(entity);
        if (specials != null) {
            return this.getModel(specials.mainModelReference);
        }
        return entity.slimModel ? this.getModel("main.slim") : this.getModel("main");
    }

    @Override
    @Nullable
    protected StaticEntityModel getAndSetupModelForLayer(@NotNull Player entity, float brightness, float partialTick, int layer) {
        if (layer == 0) {
            return this.setupAnimations(entity, this.getActiveModel(entity, false), partialTick, layer);
        }
        return super.getAndSetupModelForLayer(entity, brightness, partialTick, layer);
    }

    @Override
    @Nullable
    protected StaticEntityModel setupAnimations(@NotNull Player entity, @Nullable StaticEntityModel model, float partialTick, int layer) {
        StaticEntityModel model1 = super.setupAnimations(entity, model, partialTick, layer);
        if (model1 != null && layer == 0) {
            model1.getTransform((String)"hat").visible = entity.playerConfig.hatEnabled();
            model1.getTransform((String)"jacket").visible = entity.playerConfig.jacketEnabled();
            model1.getTransform((String)"leftSleeve").visible = entity.playerConfig.sleeveLeftEnabled();
            model1.getTransform((String)"rightSleeve").visible = entity.playerConfig.sleeveRightEnabled();
            model1.getTransform((String)"leftPant").visible = entity.playerConfig.pantLeftEnabled();
            model1.getTransform((String)"rightPant").visible = entity.playerConfig.pantRightEnabled();
        }
        if (entity.isDwarf() && entity.isSneaking()) {
            BoneTransform waist = model.getTransform("waist");
            waist.posY -= 4.0;
        }
        return model1;
    }

    @Override
    public void loadEntityTexture(@NotNull Player entity) {
        this.bindDownloadableTexture(entity.skinURL, entity.getEntityTexture(), entity.slimModel ? PlayerSkinParser.instanceAlex : PlayerSkinParser.instanceSteve);
    }

    public static enum Specials {
        SHIGN(UUID.fromString("49f6ea39-30b2-4441-b07c-7bfe0beeb61e"), "ShignBright", "main.shign", null),
        COOKIE(UUID.fromString("2c3bfa2c-95b0-48a8-baa2-9f3802190d86"), "DaCookieCakes", "main.cookie", null),
        THA_BOAR(UUID.fromString("f73086f5-d583-408b-a65c-d2dbdd9afaae"), "thaboar", "main.boar", null),
        MELON(UUID.fromString("9af822f9-ed7c-4afc-be28-2bd5b8c40b50"), "MelonMojito", "main.melon", "arms.melon"),
        WATERMELON(UUID.fromString("f9b18145-2be6-4817-8afb-a36e91369d2a"), "WatermelonMojito", "main.melon", "arms.melon");

        @NotNull
        public final UUID uuid;
        @NotNull
        public final String username;
        @NotNull
        public final String mainModelReference;
        @Nullable
        public final String armsModelReference;

        private Specials(@NotNull UUID uuid, @Nullable String username, String mainModelReference, String armsModelReference) {
            this.uuid = uuid;
            this.username = username;
            this.mainModelReference = mainModelReference;
            this.armsModelReference = armsModelReference;
        }

        @Nullable
        public static Specials getSpecialsForPlayer(@NotNull Player player) {
            if (!((Boolean)GameSettings.DEV_MODELS.value).booleanValue() || !player.playerConfig.devModelEnabled()) {
                return null;
            }
            if (player.uuid.equals(Specials.SHIGN.uuid) || player.username.equals(Specials.SHIGN.username)) {
                return SHIGN;
            }
            if (player.uuid.equals(Specials.COOKIE.uuid) || player.username.equals(Specials.COOKIE.username)) {
                return COOKIE;
            }
            if (player.uuid.equals(Specials.THA_BOAR.uuid) || player.username.equals(Specials.THA_BOAR.username)) {
                return THA_BOAR;
            }
            if (player.uuid.equals(Specials.MELON.uuid) || player.username.equals(Specials.MELON.username)) {
                return MELON;
            }
            if (player.uuid.equals(Specials.WATERMELON.uuid) || player.username.equals(Specials.WATERMELON.username)) {
                return WATERMELON;
            }
            return null;
        }

        @Nullable
        public static Specials getSpecialsForMob(@NotNull Mob mob) {
            if (!((Boolean)GameSettings.DEV_MODELS.value).booleanValue()) {
                return null;
            }
            if (mob.nickname.equals(Specials.SHIGN.username)) {
                return SHIGN;
            }
            if (mob.nickname.equals(Specials.COOKIE.username)) {
                return COOKIE;
            }
            if (mob.nickname.equals(Specials.THA_BOAR.username)) {
                return THA_BOAR;
            }
            if (mob.nickname.equals(Specials.MELON.username)) {
                return MELON;
            }
            if (mob.nickname.equals(Specials.WATERMELON.username)) {
                return WATERMELON;
            }
            return null;
        }
    }
}

