/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleArrowGolden
extends Particle {
    private final float oSize;

    public ParticleArrowGolden(World world, double x, double y, double z, double xa, double ya, double za) {
        this(world, x, y, z, xa, ya, za, 1.0f);
    }

    public ParticleArrowGolden(World world, double x, double y, double z, double xa, double ya, double za, float scale) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += xa;
        this.yd += ya;
        this.zd += za;
        this.gCol = 0.8f;
        this.rCol = 0.8f;
        this.bCol = (float)(Math.random() * 0.3);
        this.size *= 0.75f;
        this.size *= scale;
        this.oSize = this.size;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime * 32.0f;
        if (l < 0.0f) {
            l = 0.0f;
        }
        if (l > 1.0f) {
            l = 1.0f;
        }
        this.size = this.oSize * l;
        super.render(t, partialTick);
    }

    @Override
    public void tick() {
        int val;
        this.cachedLightmapCoord = this.calcLightmap(1.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.tex = (val = 7 - this.age * 8 / this.lifetime) >= 0 ? TextureRegistry.getTexture("minecraft:particle/puff_" + val) : null;
        this.yd += 0.004;
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

