/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleFootstep
extends Particle {
    private int life = 0;
    private final int lifeTime;
    private final TextureManager textureManager;

    public ParticleFootstep(TextureManager textureManager, World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.textureManager = textureManager;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.lifeTime = 200;
    }

    @Override
    public void renderLit(@NotNull TessellatorGeneral t, float partialTick, double xOff, double yOff, double zOff) {
        float a;
        float time = ((float)this.life + partialTick) / (float)this.lifeTime;
        if ((a = 2.0f - (time *= time) * 2.0f) > 1.0f) {
            a = 1.0f;
        }
        a *= 0.2f;
        GLRenderer.globalSetLightEnabled(false);
        float s = 0.125f;
        float x = (float)(this.x - xOff);
        float y = (float)(this.y - yOff);
        float z = (float)(this.z - zOff);
        float br = this.world.getLightBrightness(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
        this.textureManager.bindTexture(this.textureManager.loadTexture("/assets/minecraft/textures/misc/footprint.png"));
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        t.startDrawingQuads();
        t.setColor4f(br, br, br, a);
        t.addVertexWithUV(x - s, y, z + s, 0.0, 1.0);
        t.addVertexWithUV(x + s, y, z + s, 1.0, 1.0);
        t.addVertexWithUV(x + s, y, z - s, 1.0, 0.0);
        t.addVertexWithUV(x - s, y, z - s, 0.0, 0.0);
        t.draw();
        GLRenderer.disableState(State.BLEND);
        GLRenderer.globalSetLightEnabled(true);
    }

    @Override
    public void tick() {
        this.cachedLightmapCoord = this.calcLightmap(1.0f);
        ++this.life;
        if (this.life == this.lifeTime) {
            this.remove();
        }
    }

    @Override
    public int getParticleTexture() {
        return 1;
    }
}

