/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.tessellator.TessellatorTerrainImpl;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ChunkRendererMultiDraw
extends ChunkRenderer {
    @NotNull
    private static final TessellatorTerrainImpl tessellatorTerrain = new TessellatorTerrainImpl(0x200000);
    public final TerrainRendererMultiDraw terrainRenderer;
    public final VertexBuffer.Entry[] renderListEntries;

    public ChunkRendererMultiDraw(@NotNull TerrainRendererMultiDraw terrainRenderer, @NotNull World world, @NotNull @NotNull List<@NotNull TileEntity> globalRenderableTileEntities, int x, int y, int z, int size) {
        super(world, globalRenderableTileEntities, x, y, z, size);
        this.terrainRenderer = terrainRenderer;
        this.renderListEntries = new VertexBuffer.Entry[terrainRenderer.MAX_RENDER_PASSES];
    }

    @Override
    public boolean rebuild(boolean priority) {
        if (!this.dirty) {
            return false;
        }
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int maxX = this.posX + this.sizeX;
        int maxY = this.posY + this.sizeY;
        int maxZ = this.posZ + this.sizeZ;
        int renderPassCount = this.terrainRenderer.MAX_RENDER_PASSES;
        boolean cacheRadius = true;
        ChunkCache chunkCache = new ChunkCache(this.world, new TilePos(minX - 1, minY - 1, minZ - 1), new TilePos(maxX + 1, maxY + 1, maxZ + 1), priority);
        if (!chunkCache.allLoaded()) {
            return false;
        }
        this.terrainRenderer.chunkDeleted(this);
        Chunk.isLit = false;
        HashSet lastSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        this.renderableBlockEntities.clear();
        ++updates;
        TessellatorTerrainImpl tessellator = tessellatorTerrain;
        for (int renderPass = 0; renderPass < renderPassCount; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            TilePos pos = new TilePos(0, 0, 0);
            pos.y = minY;
            while (pos.y < maxY) {
                pos.z = minZ;
                while (pos.z < maxZ) {
                    pos.x = minX;
                    while (pos.x < maxX) {
                        BlockModel model;
                        int blockRenderPass;
                        TileEntity tileentity;
                        @NotNull Block<?> block = chunkCache.getBlockType(pos);
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            tessellator.startDrawingQuads();
                            RenderRegion region = this.terrainRenderer.getRenderRegionAtBlockPos(this.posX, this.posZ);
                            tessellator.setTranslation(-(region.posX << this.terrainRenderer.REGION_SIZE), 0.0, -(region.posZ << this.terrainRenderer.REGION_SIZE));
                        }
                        if (renderPass == 0 && block.isEntityTile() && (tileentity = chunkCache.getTileEntity(pos)) != null && TileEntityRenderDispatcher.instance.hasRenderer(tileentity)) {
                            this.renderableBlockEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).renderLayer()) != renderPass) {
                            needsMoreRenderPasses = true;
                        } else {
                            hasRenderedBlock |= this.renderBlock(tessellator, chunkCache, model, pos);
                        }
                        ++pos.x;
                    }
                    ++pos.z;
                }
                ++pos.y;
            }
            if (hasStartedDrawing) {
                this.terrainRenderer.chunkRendered(this, tessellator, renderPass);
                tessellator.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.empty[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet newSpecialTileEntities = new HashSet(this.renderableBlockEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.globalRenderableBlockEntities.addAll(newSpecialTileEntities);
        this.renderableBlockEntities.forEach(lastSpecialTileEntities::remove);
        this.globalRenderableBlockEntities.removeAll(lastSpecialTileEntities);
        this.skyLit = Chunk.isLit;
        this.compiled = true;
        return true;
    }

    @Override
    public void cull(CameraFrustum frustum, float partialTick) {
        boolean wasVisible = this.visible;
        super.cull(frustum, partialTick);
        if (wasVisible != this.visible) {
            this.terrainRenderer.chunkVisibilityChanged(this);
        }
    }

    @Override
    public void reset() {
        if (this.terrainRenderer != null) {
            this.terrainRenderer.chunkDeleted(this);
        }
        super.reset();
    }

    public String toString() {
        return "[" + this.posX + "," + this.posY + "," + this.posZ + "]";
    }
}

