/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.mojang.logging.CategorizedLogger;
import com.mojang.logging.LogUtils;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.render.terrain.VertexBuffer;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexConfigStandard;
import net.minecraft.client.render.terrain.VertexData;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;

public class RenderList {
    private static final CategorizedLogger LOGGER = LogUtils.getLogger();
    public final VertexBuffer vertexBuffer;
    private VertexConfig<?> vertexConfig;
    private boolean vertexConfigLocked = false;
    private IntBuffer posBuffer;
    private IntBuffer sizeBuffer;
    private final List<VertexBuffer.Entry> entryList = new ArrayList<VertexBuffer.Entry>();
    private final Set<VertexBuffer.Entry> visibleEntries = new HashSet<VertexBuffer.Entry>();
    private boolean visibleEntriesUpdated = true;

    public RenderList(VertexBuffer vertexBuffer, int capacity) {
        this.vertexBuffer = vertexBuffer;
        this.posBuffer = BufferUtils.createByteBuffer(capacity * 4).asIntBuffer();
        this.sizeBuffer = BufferUtils.createByteBuffer(capacity * 4).asIntBuffer();
    }

    public void draw() {
        if (this.entryList.isEmpty()) {
            return;
        }
        if (this.visibleEntriesUpdated) {
            int vertexSize = this.vertexConfig.getVertexSize();
            this.posBuffer = RenderList.expandIfNecessary(this.posBuffer, this.visibleEntries.size());
            this.sizeBuffer = RenderList.expandIfNecessary(this.sizeBuffer, this.visibleEntries.size());
            this.posBuffer.clear();
            this.sizeBuffer.clear();
            for (VertexBuffer.Entry entry : this.visibleEntries) {
                int pos = (int)(entry.position / (long)vertexSize);
                int size = (int)(entry.size / (long)vertexSize);
                assert (pos >= 0) : "Entry pos must be positive!";
                assert (size >= 0) : "Entry size must be positive!";
                this.posBuffer.put(pos);
                this.sizeBuffer.put(size);
            }
            this.posBuffer.flip();
            this.sizeBuffer.flip();
            this.visibleEntriesUpdated = false;
        }
        if (this.visibleEntries.isEmpty()) {
            return;
        }
        GL41.glMultiDrawArrays(this.vertexConfig.drawmode().cap, this.posBuffer, this.sizeBuffer);
    }

    public VertexBuffer.Entry add(VertexData vertexData, boolean visible) {
        if (vertexData.vertexCount <= 0) {
            return null;
        }
        if (this.entryList.isEmpty() && !this.vertexConfigLocked) {
            this.vertexConfig = vertexData.config.copy();
        } else {
            VertexConfigStandard.compareThrow(this.vertexConfig, vertexData.config);
        }
        VertexBuffer.Entry entry = this.vertexBuffer.addVertexData(vertexData);
        this.entryList.add(entry);
        if (visible) {
            this.visibleEntries.add(entry);
            this.visibleEntriesUpdated = true;
        }
        return entry;
    }

    public void setVisible(VertexBuffer.Entry entry, boolean visible) {
        if (entry == null) {
            throw new NullPointerException();
        }
        if (visible) {
            if (this.visibleEntries.add(entry)) {
                this.visibleEntriesUpdated = true;
            }
        } else if (this.visibleEntries.remove(entry)) {
            this.visibleEntriesUpdated = true;
        }
    }

    public void lockVertexConfig(VertexConfigStandard vertexConfig) {
        if (vertexConfig == null) {
            throw new NullPointerException("VertexConfig cannot be null!");
        }
        if (!this.entryList.isEmpty() && !this.vertexConfig.equals(vertexConfig)) {
            VertexConfigStandard.compareThrow(this.vertexConfig, vertexConfig);
        }
        this.vertexConfig = vertexConfig.copy();
        this.vertexConfigLocked = true;
    }

    public boolean remove(VertexBuffer.Entry entry) {
        if (this.entryList.remove(entry)) {
            this.vertexBuffer.removeEntry(entry);
            this.visibleEntries.remove(entry);
            this.visibleEntriesUpdated = true;
            return true;
        }
        return false;
    }

    public int size() {
        return this.entryList.size();
    }

    public int visibleEntryCount() {
        return this.visibleEntries.size();
    }

    public VertexConfig<?> getVertexConfig() {
        return this.vertexConfig;
    }

    public boolean isVertexConfigLocked() {
        return this.vertexConfigLocked;
    }

    public static IntBuffer expandIfNecessary(IntBuffer buffer, int requiredCapacity) {
        if (buffer.capacity() < requiredCapacity) {
            int newCapacity = Math.max(buffer.capacity() * 2, requiredCapacity);
            LOGGER.warn("Expanding RenderList IntBuffer from {} to {} ints...", (Object)buffer.capacity(), (Object)newCapacity);
            return BufferUtils.createIntBuffer(newCapacity);
        }
        return buffer;
    }
}

