/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.config.spawning;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.util.HardIllegalArgumentException;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class SpawnerConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    public boolean allowPassive = true;
    public boolean allowHostile = true;
    private final Map<NamespaceID, Boolean> mobSpawnOverrides = new HashMap<NamespaceID, Boolean>();

    public boolean canPassiveSpawn(@NotNull World world) {
        return this.allowPassive;
    }

    public void setPassiveSpawning(boolean flag) {
        this.allowPassive = flag;
    }

    public boolean canHostileSpawn(@NotNull World world) {
        return this.allowHostile && world.getDifficulty().canHostileMobsSpawn();
    }

    public void setHostileSpawning(boolean flag) {
        this.allowHostile = flag;
    }

    public boolean canMobSpawn(@NotNull NamespaceID mobID) {
        return this.mobSpawnOverrides.getOrDefault(mobID, true);
    }

    public void setMobSpawn(@NotNull NamespaceID mobID, boolean flag) {
        this.mobSpawnOverrides.put(mobID, flag);
    }

    public void set(@NotNull SpawnerConfig config) {
        this.mobSpawnOverrides.clear();
        this.mobSpawnOverrides.putAll(config.mobSpawnOverrides);
        this.allowHostile = config.allowHostile;
        this.allowPassive = config.allowPassive;
    }

    public Collection<Map.Entry<NamespaceID, Boolean>> getSpawnEntries() {
        return this.mobSpawnOverrides.entrySet();
    }

    public void writeToTag(CompoundTag tag) {
        tag.putBoolean("passive", this.allowPassive);
        tag.putBoolean("hostile", this.allowHostile);
        CompoundTag overridesTag = new CompoundTag();
        for (Map.Entry<NamespaceID, Boolean> e : this.mobSpawnOverrides.entrySet()) {
            overridesTag.putBoolean(e.getKey().toString(), e.getValue());
        }
        tag.putCompound("overrides", overridesTag);
    }

    public void readFromTag(CompoundTag tag) {
        this.allowPassive = tag.getBoolean("passive");
        this.allowHostile = tag.getBoolean("hostile");
        CompoundTag overrides = tag.getCompound("overrides");
        for (Map.Entry tagEntry : ((Map)overrides.getValue()).entrySet()) {
            try {
                this.mobSpawnOverrides.put((NamespaceID)NamespaceID.fromPool((String)tagEntry.getKey()).copyUnpooled(), (Byte)((ByteTag)tagEntry.getValue()).getValue() != 0);
            }
            catch (HardIllegalArgumentException e) {
                LOGGER.error("Failed to convert string '{}' to namespace id!", tagEntry.getKey(), (Object)e);
            }
        }
    }

    public static SpawnerConfig createFromTag(CompoundTag tag) {
        SpawnerConfig config = new SpawnerConfig();
        if (tag != null) {
            config.readFromTag(tag);
        }
        return config;
    }
}

