/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.ScaledResolution;
import net.minecraft.client.console.LogMessageReceiver;
import net.minecraft.client.console.shell.BindManager;
import net.minecraft.client.discord.RichPresenceHandlerThread;
import net.minecraft.client.entity.ClientSkinVariantList;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.enums.EnumGPUVendor;
import net.minecraft.client.gui.ExceptionPopupElement;
import net.minecraft.client.gui.MainMenuBackground;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenConnecting;
import net.minecraft.client.gui.ScreenConsole;
import net.minecraft.client.gui.ScreenGameOver;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.ScreenSleepSP;
import net.minecraft.client.gui.ScreenStats;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.gui.chat.ScreenSleepMP;
import net.minecraft.client.gui.container.ScreenInventory;
import net.minecraft.client.gui.container.ScreenInventoryCreative;
import net.minecraft.client.gui.error.ScreenBadJavaArch;
import net.minecraft.client.gui.error.ScreenConflictWarning;
import net.minecraft.client.gui.error.ScreenMissingMinecraft;
import net.minecraft.client.gui.error.ScreenOutOfMemory;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.gui.subtitles.SubtitleTracker;
import net.minecraft.client.gui.toasts.GuiElementToastsHud;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.input.InputHandler;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.MouseInput;
import net.minecraft.client.input.PlayerInput;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.Joystick;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.client.net.thread.ThreadDownloadResources;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.option.OptionInteger;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.EntityRendererDispatcher;
import net.minecraft.client.render.LoadingScreenRenderer;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.ParticleEngine;
import net.minecraft.client.render.PostProcessingManager;
import net.minecraft.client.render.RenderGlobal;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCameraFirstPerson;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.font.FontRendererDefault;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.CullFace;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.shader.ShadersRenderer;
import net.minecraft.client.render.terrain.ChunkRenderer;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.texturepack.TexturePackList;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.client.render.window.GameWindowGLFW;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.sound.SoundRepository;
import net.minecraft.client.util.debug.DebugRender;
import net.minecraft.client.util.helper.ScreenShot;
import net.minecraft.client.util.helper.ScreenshotHelper;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.client.world.WorldClient;
import net.minecraft.client.world.WorldClientMP;
import net.minecraft.client.world.chunk.provider.ChunkProviderDynamic;
import net.minecraft.client.world.chunk.provider.ChunkProviderStatic;
import net.minecraft.client.world.chunk.provider.ChunkProviderThreadedClient;
import net.minecraft.client.world.chunk.provider.SelectedProvider;
import net.minecraft.client.world.save.SaveHandlerClientSP;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.MinecraftError;
import net.minecraft.core.MinecraftException;
import net.minecraft.core.Timer;
import net.minecraft.core.UnexpectedThrowable;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumOS;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.PlayerProfile;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.commands.CommandAchievement;
import net.minecraft.core.net.command.commands.CommandBiome;
import net.minecraft.core.net.command.commands.CommandChunk;
import net.minecraft.core.net.command.commands.CommandClear;
import net.minecraft.core.net.command.commands.CommandClone;
import net.minecraft.core.net.command.commands.CommandDamage;
import net.minecraft.core.net.command.commands.CommandFill;
import net.minecraft.core.net.command.commands.CommandGameMode;
import net.minecraft.core.net.command.commands.CommandGameRule;
import net.minecraft.core.net.command.commands.CommandGive;
import net.minecraft.core.net.command.commands.CommandHeal;
import net.minecraft.core.net.command.commands.CommandHelp;
import net.minecraft.core.net.command.commands.CommandKill;
import net.minecraft.core.net.command.commands.CommandMessage;
import net.minecraft.core.net.command.commands.CommandMobSpawning;
import net.minecraft.core.net.command.commands.CommandParticle;
import net.minecraft.core.net.command.commands.CommandPlace;
import net.minecraft.core.net.command.commands.CommandPlaySound;
import net.minecraft.core.net.command.commands.CommandSay;
import net.minecraft.core.net.command.commands.CommandSeed;
import net.minecraft.core.net.command.commands.CommandSetBlock;
import net.minecraft.core.net.command.commands.CommandSetSpawn;
import net.minecraft.core.net.command.commands.CommandSpawn;
import net.minecraft.core.net.command.commands.CommandSummon;
import net.minecraft.core.net.command.commands.CommandTeleport;
import net.minecraft.core.net.command.commands.CommandTellRaw;
import net.minecraft.core.net.command.commands.CommandTestFor;
import net.minecraft.core.net.command.commands.CommandTime;
import net.minecraft.core.net.command.commands.CommandWeather;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.player.Session;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.debug.Debug;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.LoggedPrintStream;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Time;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.PortalHandler;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.save.DimensionData;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveConverters;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL41;
import org.lwjgl.system.Configuration;
import org.slf4j.Logger;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;

public class Minecraft
implements MinecraftAccessor {
    public static Logger LOGGER = LogUtils.getLogger();
    public static final String VERSION = Global.VERSION;
    public static final boolean isMultiplayerDisabled = false;
    public static boolean doPartialTick = true;
    public static EnumGPUVendor GPU_VENDOR = EnumGPUVendor.UNKNOWN;
    @NotNull
    private static Minecraft INSTANCE;
    @Nullable
    public PlayerController playerController = null;
    public boolean hasCrashed;
    public UnexpectedThrowable lastCrash;
    public final Timer timer;
    public WorldClient currentWorld;
    public RenderGlobal renderGlobal;
    public PlayerLocal thePlayer;
    public ICamera activeCamera;
    public ParticleEngine particleEngine;
    public Session session;
    public String minecraftUri;
    public boolean hideQuitButton;
    public volatile boolean isGamePaused;
    @NotNull
    public final TextureManager textureManager;
    @NotNull
    public final FontRenderer font;
    @Nullable
    public Screen currentScreen;
    public LoadingScreenRenderer loadingScreen;
    public WorldRenderer worldRenderer;
    public ThreadDownloadResources downloadResourcesThread;
    public int ticksRan;
    public GuiElementToastsHud guiToasts;
    public HudIngame hudIngame;
    public boolean skipRenderWorld;
    @Nullable
    public HitResult objectMouseOver;
    @NotNull
    public SoundEngine sndManager;
    @NotNull
    public final SubtitleTracker subtitleTracker = new SubtitleTracker();
    @NotNull
    public final TexturePackList texturePackList;
    @NotNull
    private final File mcDataDir;
    private ISaveFormat saveFormat;
    public static int numRecordedFrameTimes;
    public static long hasPaidCheckTime;
    public StatsCounter statsCounter;
    private String serverName;
    private int serverPort;
    public volatile boolean running;
    public String lineDebug;
    public String lingDebugFPS;
    boolean isTakingScreenshot;
    public boolean inGameHasFocus;
    private int mouseTicksRan;
    public boolean isRaining;
    long systemTime;
    private int joinPlayerCounter;
    protected boolean toggleFlyPressed = false;
    protected long flyPressedTime = 0L;
    public static final int HOTBAR_SWAP_ANIMATION_LENGTH_TICKS = 3;
    public int hotbarSwapAnimationProgress = 0;
    @NotNull
    public ScaledResolution resolution;
    public boolean fullbright = false;
    public Renderer renderer;
    @Nullable
    public ControllerInput controllerInput;
    public final MouseInput mouseInput = new MouseInput(this);
    public InputType inputType = InputType.KEYBOARD;
    public final ScreenshotHelper screenshotHelper = new ScreenshotHelper(this);
    private boolean f3Press = false;
    public Thread rpcThread = null;
    @NotNull
    public final PostProcessingManager ppm = new PostProcessingManager(this);
    private long lastFocusTime;
    @NotNull
    public GameWindow gameWindow;
    public ClientSkinVariantList skinVariantList = new ClientSkinVariantList(this);
    public MainMenuBackground mainMenuBackground = new MainMenuBackground(this);
    @Nullable
    public Integer overrideWidth = null;
    @Nullable
    public Integer overrideHeight = null;
    private boolean gameStarted = false;
    private final int mojrand = new Random(System.currentTimeMillis()).nextInt(200);
    public TerrainRenderer terrainRenderer;
    private static final TimeKeeper STARTUP_TIKE_KEEPER;

    public Minecraft(@NotNull File mcDataDir, @NotNull GameWindow gameWindow) {
        Global.accessor = this;
        this.hasCrashed = false;
        this.timer = new Timer(20.0f);
        this.session = null;
        this.hideQuitButton = false;
        this.isGamePaused = false;
        this.currentScreen = null;
        this.ticksRan = 0;
        this.skipRenderWorld = false;
        this.objectMouseOver = null;
        this.running = true;
        this.lineDebug = "";
        this.isTakingScreenshot = false;
        this.inGameHasFocus = false;
        this.mouseTicksRan = 0;
        this.isRaining = false;
        this.systemTime = System.currentTimeMillis();
        this.joinPlayerCounter = 0;
        INSTANCE = this;
        this.mcDataDir = mcDataDir;
        this.texturePackList = new TexturePackList(this, this.mcDataDir);
        this.textureManager = new TextureManager(this, this.texturePackList);
        this.font = new FontRendererDefault();
        this.gameWindow = gameWindow;
        this.resolution = new ScaledResolution(this.gameWindow);
        LoggedPrintStream.wrapStreams();
        this.loadingScreen = new LoadingScreenRenderer(this);
        this.guiToasts = new GuiElementToastsHud(this);
        this.sndManager = new SoundEngine();
        new Thread("Timer hack thread"){
            {
                this.setDaemon(true);
                this.start();
            }

            @Override
            public void run() {
                while (Minecraft.this.running) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
    }

    public static boolean isClientASteamDeck() {
        File vendor = new File("/sys/devices/virtual/dmi/id/board_vendor");
        File name = new File("/sys/devices/virtual/dmi/id/board_name");
        if (vendor.exists() && vendor.isFile() && name.exists() && name.isFile()) {
            try {
                List<String> vendorText = Files.readAllLines(vendor.toPath());
                List<String> nameText = Files.readAllLines(name.toPath());
                if (!vendorText.isEmpty() && vendorText.get(0).contains("Valve") && !nameText.isEmpty() && nameText.get(0).contains("Jupiter")) {
                    return true;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public void onMinecraftCrash(UnexpectedThrowable throwable) {
        if (!this.gameStarted) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!\n{}", (Object)throwable.description, (Object)throwable.exception);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        if (((Boolean)GameSettings.DISABLE_CRASH_HANDLER.value).booleanValue()) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!\n{}", (Object)throwable.description, (Object)throwable.exception);
            this.hasCrashed = true;
            this.shutdownMinecraftApplet();
            return;
        }
        if (this.hasCrashed) {
            this.running = false;
            LOGGER.error("An exception has occurred while trying to start the game!\n{}", (Object)throwable.description, (Object)throwable.exception);
            this.shutdownMinecraftApplet();
            return;
        }
        Debug.reset();
        LOGGER.error("Minecraft has crashed!", throwable.exception);
        this.hasCrashed = true;
        this.lastCrash = throwable;
        try {
            if (!this.gameStarted) {
                PopupScreen error = ExceptionPopupElement.createStartupError(throwable.exception, this);
                this.displayScreen(error);
                return;
            }
            if (throwable.exception instanceof RuntimeException) {
                this.changeWorld(null);
                ScreenMainMenu screenMainMenu = new ScreenMainMenu();
                this.displayScreen(screenMainMenu);
                PopupScreen error = ExceptionPopupElement.create(screenMainMenu, throwable.exception, this);
                this.displayScreen(error);
            } else {
                this.changeWorld(null);
                PopupScreen error = ExceptionPopupElement.createFatal(throwable.exception, this);
                this.displayScreen(error);
            }
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Trying to display crash handler", e));
        }
    }

    public void setServer(String serverName, int serverPort) {
        this.serverName = serverName;
        this.serverPort = serverPort;
    }

    private static void checkLwjglVersion() {
        LOGGER.info("LWJGL version = {}", (Object)Sys.getVersion());
        if (Integer.parseInt(Sys.getVersion().substring(0, 1)) < 3) {
            JOptionPane.showMessageDialog(null, new Object[]{"Better than Adventure! requires LWJGL 3 to run.", "If you're using MultiMC or Prism Launcher to run BTA!,", "please review the installation guide at", new JLabel("<html><a href=\"\">betterthanadventure.net</a>.</html>"){
                {
                    this.setCursor(new Cursor(12));
                    this.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            UrlHelper.openURL("https://www.betterthanadventure.net/installation-guide/");
                        }
                    });
                }
            }, "", "Please note that MultiMC/Prism Launcher instances from", "versions prior to 7.3 cannot be manually upgraded to 7.3", "or later and must be re-downloaded."}, "LWJGL Version Error", 0);
            System.exit(1);
        }
    }

    public void startGame() throws LWJGLException {
        LogMessageReceiver.init();
        Holidays.initialize();
        Blocks.init();
        Items.init();
        Dimension.init();
        EntityDispatcher.init();
        TileEntityDispatcher.init();
        CommandHelper.init();
        this.initCommands();
        GameSettings.init(this.mcDataDir);
        UUIDHelper.urlUUID = (String)GameSettings.UUID_SERVER.value;
        LOGGER.info("Java Version: {}", (Object)System.getProperty("java.version"));
        this.gameWindow.init(this, this.overrideWidth != null ? this.overrideWidth : (Integer)GameSettings.WINDOW_WIDTH.value, this.overrideHeight != null ? this.overrideHeight : (Integer)GameSettings.WINDOW_HEIGHT.value);
        this.font.init();
        @Nullable String vendorString = GL41.glGetString(7936);
        if (vendorString != null) {
            GPU_VENDOR = EnumGPUVendor.getVendorFromString(vendorString);
        }
        LOGGER.info("Resolution: {} x {}", (Object)this.gameWindow.getWidthPixels(), (Object)this.gameWindow.getHeightPixels());
        this.resolution.setScale((Integer)GameSettings.GUI_SCALE.value);
        SaveFormat19134 handlerBase = new SaveFormat19134(new File(this.mcDataDir, "saves"));
        handlerBase.factory = SaveHandlerClientSP::new;
        this.saveFormat = handlerBase;
        I18n.initialize((String)GameSettings.LANGUAGE.value);
        if (!((Boolean)GameSettings.START_IN_FULLSCREEN.value).booleanValue()) {
            GameSettings.FULLSCREEN.value = false;
        }
        this.resolution.setScale((Integer)GameSettings.GUI_SCALE.value);
        this.terrainRenderer = new TerrainRendererMultiDraw(this);
        this.setRenderer(new ShadersRenderer(this));
        Shaders.init();
        this.texturePackList.init();
        EntityGeometryMojangData.Cache.reload(this.texturePackList);
        TooltipElement.reloadStyles(this.texturePackList);
        SoundRepository.initialize(this);
        GLRenderer.init();
        this.loadScreen();
        STARTUP_TIKE_KEEPER.start("Biome Provider");
        BiomeProviderOverworld.init();
        STARTUP_TIKE_KEEPER.end("Biome Provider");
        this.worldRenderer = new WorldRenderer(this);
        BlockModelDispatcher.getInstance();
        ItemModelDispatcher.getInstance();
        this.loadScreen();
        LOGGER.info("Initializing input");
        try {
            InputHandler.init(this);
            this.controllerInput = InputHandler.getController((String)GameSettings.SELECTED_CONTROLLER.value);
        }
        catch (Exception e) {
            LOGGER.error("Input init error!", e);
        }
        this.mouseInput.setRawInput((Boolean)GameSettings.RAW_MOUSE_INPUT.value);
        LOGGER.info("Input done!");
        LOGGER.info("Setting up OpenGL values...");
        OpenGLHelper.checkError("pre startup");
        GL41.glClearDepth(1.0);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
        GLRenderer.setCullFace(CullFace.BACK);
        GLRenderer.projectionM4f().identity();
        GLRenderer.viewM4f().identity();
        OpenGLHelper.checkError("startup");
        this.sndManager.init();
        this.loadScreen();
        Colorizers.init(this);
        this.textureManager.refreshTextures(new ArrayList<Throwable>());
        OptionsPages.init();
        this.loadScreen();
        LOGGER.info("Initializing Renderer...");
        TextureRegistry.worldAtlas.bind();
        this.renderGlobal = new RenderGlobal(this, this.textureManager);
        GL41.glViewport(0, 0, this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels());
        this.particleEngine = new ParticleEngine(this.currentWorld);
        try {
            LOGGER.info("Starting Resource Download Thread...");
            this.downloadResourcesThread = new ThreadDownloadResources(this.mcDataDir, this);
            this.downloadResourcesThread.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start Resource Download Thread!", e);
        }
        OpenGLHelper.checkError("post startup");
        this.hudIngame = new HudIngame(this);
        new Registries();
        DataLoader.loadRecipesFromFile("/recipes/blast_furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/trommel.json");
        DataLoader.loadRecipesFromFile("/recipes/workbench.json");
        DataLoader.loadDataPacks(this);
        Registries.RECIPES_LOCAL_COPY = Registries.RECIPES;
        int recipes = Registries.RECIPES.getAllRecipes().size();
        int groups2 = Registries.RECIPES.getAllGroups().size();
        int namespaces = Registries.RECIPES.size();
        int itemGroups = Registries.ITEM_GROUPS.size();
        LOGGER.info("{} item groups.", (Object)itemGroups);
        LOGGER.info("{} recipes in {} groups in {} namespaces.", recipes, groups2, namespaces);
        StatList.init();
        this.statsCounter = new StatsCounter(this.session, this.mcDataDir);
        Achievements.OPEN_INVENTORY.setDescriptionFormatter(s -> {
            if (!GameSettings.KEY_INVENTORY.isBound()) {
                return "Set your inventory keybind in the controls menu!";
            }
            return String.format(s, GameSettings.KEY_INVENTORY.getKeyName());
        });
        Achievements.OPEN_GUIDEBOOK.setDescriptionFormatter(s -> {
            if (!GameSettings.KEY_GUIDEBOOK.isBound()) {
                return "Set your guidebook keybind in the controls menu!";
            }
            return String.format(s, GameSettings.KEY_GUIDEBOOK.getKeyName());
        });
        this.loadScreen();
        if (((Boolean)GameSettings.DISCORD_RICH_PRESENCE.value).booleanValue()) {
            this.rpcThread = new RichPresenceHandlerThread(this);
            this.rpcThread.setName("Discord RPC Thread");
            this.rpcThread.start();
        }
        ObjectPool.freeAllPools();
        this.gameStarted = true;
        boolean hasBeta173 = true;
        try {
            Class.forName("a");
        }
        catch (Exception e) {
            hasBeta173 = false;
        }
        if (!hasBeta173) {
            this.displayScreen(new ScreenMissingMinecraft());
        } else if (System.getProperty("sun.arch.data.model").equals("32")) {
            this.displayScreen(new ScreenBadJavaArch());
        } else if (this.serverName != null) {
            this.displayScreen(new ScreenConnecting(this, this.serverName, this.serverPort));
        } else {
            this.displayScreen(new ScreenMainMenu());
        }
        this.gameWindow.updateWindowState();
        STARTUP_TIKE_KEEPER.end("Startup");
        LOGGER.info(STARTUP_TIKE_KEEPER.toString());
    }

    public void initCommands() {
        CommandManager.registerCommand(new CommandAchievement());
        CommandManager.registerCommand(new CommandClear());
        CommandManager.registerCommand(new CommandKill());
        CommandManager.registerCommand(new CommandSeed());
        CommandManager.registerCommand(new CommandSetBlock());
        CommandManager.registerCommand(new CommandSummon());
        CommandManager.registerCommand(new CommandTeleport());
        CommandManager.registerCommand(new CommandMessage());
        CommandManager.registerCommand(new CommandSetSpawn());
        CommandManager.registerCommand(new CommandTime());
        CommandManager.registerCommand(new CommandGameMode());
        CommandManager.registerCommand(new CommandWeather());
        CommandManager.registerCommand(new CommandSpawn());
        CommandManager.registerCommand(new CommandPlace());
        CommandManager.registerCommand(new CommandHelp());
        CommandManager.registerCommand(new CommandChunk());
        CommandManager.registerCommand(new CommandGive());
        CommandManager.registerCommand(new CommandGameRule());
        CommandManager.registerCommand(new CommandFill());
        CommandManager.registerCommand(new CommandClone());
        CommandManager.registerCommand(new CommandBiome());
        CommandManager.registerCommand(new CommandSay());
        CommandManager.registerCommand(new CommandTellRaw());
        CommandManager.registerCommand(new CommandTestFor());
        CommandManager.registerCommand(new CommandDamage());
        CommandManager.registerCommand(new CommandHeal());
        CommandManager.registerCommand(new CommandMobSpawning());
        CommandManager.registerCommand(new CommandPlaySound());
        CommandManager.registerCommand(new CommandParticle());
    }

    @NotNull
    public Matrix4f getGuiProjectionMatrix(@NotNull Matrix4f dest) {
        return dest.identity().ortho(0.0f, (float)this.resolution.getExactScaledWidthScreenCoords(), (float)this.resolution.getExactScaledHeightScreenCoords(), 0.0f, 1000.0f, 3000.0f);
    }

    @NotNull
    public Matrix4f getGuiViewMatrix(@NotNull Matrix4f dest) {
        return dest.identity().translate(0.0f, 0.0f, -2000.0f);
    }

    private void loadScreen() throws LWJGLException {
        GL41.glClear(16640);
        this.getGuiProjectionMatrix(GLRenderer.projectionM4f());
        this.getGuiViewMatrix(GLRenderer.viewM4f());
        GL41.glViewport(0, 0, this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels());
        GL41.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        if (this.mojrand == 0) {
            this.textureManager.loadTexture("/assets/minecraft/textures/gui/title/majonk.png").bind();
        } else {
            this.textureManager.loadTexture("/assets/minecraft/textures/gui/title/mojang.png").bind();
        }
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.setColorOpaque1i(0xFFFFFF);
        t.addVertex(0.0, this.gameWindow.getHeightPixels(), 0.0);
        t.addVertex(0.0, 0.0, 0.0);
        t.addVertex(this.gameWindow.getWidthPixels(), 0.0, 0.0);
        t.addVertex(this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels(), 0.0);
        t.draw();
        int width = 256;
        int height = 256;
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.drawMojangLogoVertices(t, (this.resolution.getScaledWidthScreenCoords() - width) / 2, (this.resolution.getScaledHeightScreenCoords() - height) / 2, 0, 0, width, height);
        this.gameWindow.update();
    }

    public void drawMojangLogoVertices(@NotNull TessellatorGeneral t, int minX, int minY, int minU, int minV, int width, int height) {
        float scaleX = 0.00390625f;
        float scaleY = 0.00390625f;
        t.startDrawingQuads();
        t.setColorOpaque1i(0xFFFFFF);
        t.addVertexWithUV(minX, minY + height, 0.0, (float)minU * scaleX, (float)(minV + height) * scaleY);
        t.addVertexWithUV(minX, minY, 0.0, (float)minU * scaleX, (float)minV * scaleY);
        t.addVertexWithUV(minX + width, minY, 0.0, (float)(minU + width) * scaleX, (float)minV * scaleY);
        t.addVertexWithUV(minX + width, minY + height, 0.0, (float)(minU + width) * scaleX, (float)(minV + height) * scaleY);
        t.draw();
    }

    @Override
    public File getMinecraftDir() {
        return this.mcDataDir;
    }

    @Override
    public String getMinecraftVersion() {
        return VERSION;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return switch ((SelectedProvider)((Object)GameSettings.CHUNK_PROVIDER.value)) {
            case SelectedProvider.DYNAMIC -> new ChunkProviderDynamic(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
            case SelectedProvider.THREADED -> new ChunkProviderThreadedClient(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
            default -> new ChunkProviderStatic(world, chunkLoader, world.getWorldType().createChunkGenerator(world));
        };
    }

    public static File getAppDir(String s) {
        String homeDirPath = System.getProperty("user.home", ".");
        File appDir = switch (Minecraft.getOs()) {
            case EnumOS.linux, EnumOS.solaris -> new File(homeDirPath, "." + s + "/");
            case EnumOS.windows -> {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    yield new File(s2, "." + s + "/");
                }
                yield new File(homeDirPath, "." + s + "/");
            }
            case EnumOS.macos -> new File(homeDirPath, "Library/Application Support/" + s);
            default -> new File(homeDirPath, s + "/");
        };
        if (!appDir.exists() && !appDir.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + String.valueOf(appDir));
        }
        return appDir;
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris") || s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux") || s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public ISaveFormat getSaveFormat() {
        return this.saveFormat;
    }

    public void displayScreen(@Nullable Screen screen) {
        if (this.currentScreen == null && screen != null && this.controllerInput != null) {
            this.controllerInput.cursorX = (double)this.resolution.getScaledWidthScreenCoords() / 2.0;
            this.controllerInput.cursorY = (double)this.resolution.getScaledHeightScreenCoords() / 2.0;
        }
        if (this.currentScreen != null) {
            this.currentScreen.removed();
        }
        if (screen instanceof ScreenMainMenu) {
            this.statsCounter.fetchStats();
        }
        if (this.statsCounter != null) {
            this.statsCounter.saveStats();
        }
        if (screen == null && this.currentWorld == null) {
            screen = new ScreenMainMenu();
        } else if (screen == null && this.thePlayer.getHealth() <= 0) {
            screen = new ScreenGameOver();
        }
        if (screen instanceof ScreenMainMenu) {
            this.hudIngame.clearChatMessages();
        }
        this.currentScreen = screen;
        if (screen != null) {
            this.setIngameNotInFocus();
            screen.opened(this.resolution.getScaledWidthScreenCoords(), this.resolution.getScaledHeightScreenCoords());
            this.skipRenderWorld = false;
        } else {
            this.setIngameFocus();
        }
    }

    public void shutdownMinecraftApplet() {
        LOGGER.info("Shutting Down");
        try {
            GameSettings.saveOptions();
        }
        catch (Throwable e) {
            LOGGER.error("Exception occurred while saving settings! Some settings may be lost!", e);
        }
        if (this.statsCounter != null) {
            try {
                this.statsCounter.fetchStats();
                this.statsCounter.saveStats();
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to save stats!");
            }
        }
        if (this.currentWorld != null) {
            try {
                this.changeWorld(null);
            }
            catch (Throwable throwable) {
                LOGGER.error("Failed to close world!", throwable);
            }
        }
        try {
            if (OpenGLHelper.contextCreated) {
                GLAllocation.deleteTextures();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to free texture handles!", throwable);
        }
        try {
            this.sndManager.destroy();
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to close sound manager!", throwable);
        }
        try {
            this.gameWindow.free();
        }
        catch (Throwable throwable) {
            LOGGER.error("Failed to free window resources!", throwable);
        }
        System.gc();
        if (!this.hasCrashed) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.running = true;
        try {
            this.startGame();
        }
        catch (Throwable e) {
            this.onMinecraftCrash(new UnexpectedThrowable("Failed to start game", e));
        }
        try {
            long currentTime = System.currentTimeMillis();
            int fpsCounter = 0;
            while (this.running) {
                try {
                    long now;
                    long sleepTime;
                    Debug.reset();
                    Debug.push("update");
                    Debug.push("misc");
                    long tickStartTime = System.currentTimeMillis();
                    Time.tick();
                    ObjectPool.resetAllPools();
                    if (this.gameWindow.shouldClose()) {
                        this.shutdown();
                    }
                    if (this.isGamePaused && this.currentWorld != null && !(this.currentScreen instanceof ScreenModelViewer)) {
                        float temp = this.timer.partialTicks;
                        this.timer.advanceTime();
                        this.timer.partialTicks = temp;
                    } else {
                        this.timer.advanceTime();
                    }
                    if (!doPartialTick) {
                        this.timer.partialTicks = 1.0f;
                    }
                    this.mouseInput.update();
                    if (this.controllerInput != null && this.currentScreen != null) {
                        this.controllerInput.moveCursor();
                    }
                    Debug.pop();
                    Debug.change("tick");
                    WorldClient worldClient = this.currentWorld;
                    if (worldClient instanceof WorldClientMP) {
                        WorldClientMP clientMP = (WorldClientMP)worldClient;
                        clientMP.processPackets();
                    }
                    if (this.currentScreen instanceof ScreenSelectServer) {
                        this.currentScreen.tick();
                    }
                    for (int tick = 0; tick < this.timer.frames; ++tick) {
                        ++this.ticksRan;
                        try {
                            this.runTick();
                            continue;
                        }
                        catch (MinecraftException e) {
                            this.currentWorld = null;
                            LOGGER.error("MinecraftException occurred while attempting to run tick, exiting world!", e);
                            this.changeWorld(null);
                            this.displayScreen(new ScreenConflictWarning());
                        }
                    }
                    Debug.change("update");
                    Debug.push("misc");
                    OpenGLHelper.checkError("pre render");
                    EntityItem.enableItemClumping = (Boolean)GameSettings.ENABLE_ITEM_CLUMPING.value;
                    BlockLogicLeavesBase.enableTreeShadowing = (Boolean)GameSettings.TREE_SHADOWS.value;
                    this.sndManager.updateListener(this.thePlayer, this.timer.partialTicks);
                    if (this.currentWorld != null) {
                        Debug.change("updatelight");
                        try {
                            this.currentWorld.updatingLighting();
                        }
                        catch (Throwable t) {
                            LOGGER.error("Unhandled exception when updating lighting!", t);
                        }
                        Debug.change("misc");
                    }
                    Debug.change("misc");
                    if (this.thePlayer != null && this.thePlayer.isInWall()) {
                        GameSettings.THIRD_PERSON_VIEW.value = 0;
                    }
                    Debug.change("displayupdate");
                    this.gameWindow.update();
                    Debug.change("render");
                    Debug.push("post");
                    this.renderer.beginRenderGame(this.timer.partialTicks);
                    Debug.change("misc");
                    if (!this.skipRenderWorld) {
                        if (this.playerController != null) {
                            this.playerController.render(this.timer.partialTicks);
                        }
                        this.worldRenderer.updateCameraAndRender(this.timer.partialTicks);
                    }
                    if (((Boolean)GameSettings.PAUSE_ON_LOST_FOCUS.value).booleanValue()) {
                        if (!this.gameWindow.isFocused()) {
                            if (System.currentTimeMillis() > this.lastFocusTime + 250L) {
                                this.displayInGameMenu();
                            }
                        } else {
                            this.lastFocusTime = System.currentTimeMillis();
                        }
                    }
                    this.sndManager.setMuted((Boolean)GameSettings.MUTE_ON_LOST_FOCUS.value != false && !this.gameWindow.isFocused());
                    switch (this.downloadResourcesThread.downloading) {
                        case DOWNLOADING: {
                            double b = Math.sin((double)System.currentTimeMillis() / 1000.0 * 4.0);
                            b = b * 0.2 + 0.8;
                            int ib = (int)Math.round(b * 255.0);
                            int color = 0xFF000000 | ib << 16 | ib << 8 | ib;
                            int barColor = Color.doubleToIntARGB(1.0, 0.5 * b, b, 0.5 * b);
                            int sWidth = this.font.stringWidth(I18n.getInstance().translateKey("gui.main_menu.label.downloading_resources.2"));
                            double progress = (double)this.downloadResourcesThread.downloadProgress.get() / (double)this.downloadResourcesThread.toDownload;
                            int minX = (this.resolution.getScaledWidthScreenCoords() - sWidth) / 2;
                            int maxX = (this.resolution.getScaledWidthScreenCoords() + sWidth) / 2 + 1;
                            this.guiToasts.drawRect(minX - 1, 6, maxX + 1, 38, -1610612736);
                            this.guiToasts.drawStringCenteredShadow(this.font, I18n.getInstance().translateKey("gui.main_menu.label.downloading_resources.1"), this.resolution.getScaledWidthScreenCoords() / 2, 7, color);
                            this.guiToasts.drawRectDouble(minX, 16.0, (double)minX + (double)sWidth * progress, 28.0, barColor);
                            this.guiToasts.drawBox(minX, 16, maxX, 28, color, 1);
                            this.guiToasts.drawStringCenteredShadow(this.font, String.format("%d / %d", this.downloadResourcesThread.downloadProgress.get(), this.downloadResourcesThread.toDownload), this.resolution.getScaledWidthScreenCoords() / 2, 18, color);
                            this.guiToasts.drawStringCenteredShadow(this.font, I18n.getInstance().translateKey("gui.main_menu.label.downloading_resources.2"), this.resolution.getScaledWidthScreenCoords() / 2, 29, color);
                            break;
                        }
                        case ERROR: {
                            long timePassedSinceError = System.currentTimeMillis() - this.downloadResourcesThread.timeOfError;
                            if (timePassedSinceError >= 35000L) break;
                            int sWidth = this.font.stringWidth(I18n.getInstance().translateKey("gui.main_menu.label.downloading_resources.connection.error"));
                            int minX = (this.resolution.getScaledWidthScreenCoords() - sWidth) / 2;
                            int maxX = (this.resolution.getScaledWidthScreenCoords() + sWidth) / 2;
                            this.guiToasts.drawRect(minX - 2, 5, maxX + 2, 17, -1610612736);
                            this.guiToasts.drawStringCenteredShadow(this.font, I18n.getInstance().translateKey("gui.main_menu.label.downloading_resources.connection.error"), this.resolution.getScaledWidthScreenCoords() / 2, 7, -65536);
                            break;
                        }
                    }
                    Debug.change("post");
                    this.renderer.endRenderGame(this.timer.partialTicks);
                    Debug.pop();
                    Debug.change("misc");
                    if (this.gameWindow.wasResized()) {
                        this.resize();
                    }
                    OpenGLHelper.checkError("post render");
                    ++fpsCounter;
                    boolean bl = this.isGamePaused = !this.isMultiplayerWorld() && this.currentScreen != null && this.currentScreen.isPauseScreen();
                    while (System.currentTimeMillis() >= currentTime + 1000L) {
                        this.lineDebug = fpsCounter + " fps, " + ChunkRenderer.updates + " chunk updates";
                        this.lingDebugFPS = fpsCounter + " fps";
                        ChunkRenderer.updates = 0;
                        currentTime += 1000L;
                        fpsCounter = 0;
                    }
                    if (this.currentWorld == null && (sleepTime = 16L - ((now = System.currentTimeMillis()) - tickStartTime) - 1L) > 0L) {
                        long currentSleep = 0L;
                        while (currentSleep < sleepTime - 1L) {
                            Thread.sleep(1L);
                            ++currentSleep;
                            WorldClient worldClient2 = this.currentWorld;
                            if (worldClient2 instanceof WorldClientMP) {
                                WorldClientMP worldClientMP = (WorldClientMP)worldClient2;
                                worldClientMP.processPackets();
                            }
                            if (!(this.currentScreen instanceof ScreenSelectServer)) continue;
                            this.currentScreen.tick();
                        }
                    }
                    Debug.pop();
                    Debug.pop();
                    if (((Boolean)GameSettings.SHOW_FRAME_TIMES.value).booleanValue()) {
                        DebugRender.render(this.font);
                    }
                    this.screenshotListener();
                }
                catch (MinecraftException minecraftexception) {
                    this.currentWorld = null;
                    this.changeWorld(null);
                    this.displayScreen(new ScreenConflictWarning());
                }
                catch (OutOfMemoryError outofmemoryerror) {
                    this.freeUpMemory();
                    this.displayScreen(new ScreenOutOfMemory());
                    System.gc();
                }
                catch (Throwable throwable) {
                    if (this.currentWorld != null) {
                        try {
                            this.changeWorld(null);
                        }
                        catch (Throwable t) {
                            LOGGER.error("Exception when panic leaving world!", t);
                        }
                    }
                    this.freeUpMemory();
                    this.onMinecraftCrash(new UnexpectedThrowable("Unexpected error", throwable));
                }
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.shutdownMinecraftApplet();
        }
        if (this.hasCrashed) {
            LOGGER.error("--------------------==========##########==========--------------------");
            LOGGER.error("                  Better than Adventure has crashed!                  ");
            LOGGER.error("      Please report this to https://bugs.betterthanadventure.net      ");
            LOGGER.error("--------------------==========##########==========--------------------");
        }
    }

    public void freeUpMemory() {
        try {
            System.gc();
            ObjectPool.freeAllPools();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.changeWorld(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    private void screenshotListener() {
        if (GameSettings.KEY_SCREENSHOT.isPressed()) {
            if (!this.isTakingScreenshot) {
                this.isTakingScreenshot = true;
                boolean ctrl = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                Debug.push("screenshot");
                if (ctrl) {
                    try {
                        this.screenshotHelper.takePanoramaScreenshot();
                        this.hudIngame.addChatMessage("Saved panorama screenshot!");
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception occurred while taking panoramic screenshot!", e);
                    }
                } else {
                    this.hudIngame.addChatMessage(ScreenShot.saveScreenshot(this.getMinecraftDir(), this.gameWindow.getWidthPixels(), this.gameWindow.getHeightPixels()));
                }
                Debug.pop();
            }
        } else {
            this.isTakingScreenshot = false;
        }
    }

    public void shutdown() {
        this.running = false;
    }

    public void setIngameFocus() {
        if (!this.gameWindow.isFocused()) {
            return;
        }
        if (!this.inGameHasFocus) {
            this.inGameHasFocus = true;
            this.mouseInput.grabCursor();
            this.displayScreen(null);
            this.mouseTicksRan = this.ticksRan + 10000;
            if (this.thePlayer != null) {
                this.thePlayer.input.onGameFocused();
            }
        }
    }

    public void setIngameNotInFocus() {
        if (!this.inGameHasFocus) {
            return;
        }
        if (this.thePlayer != null) {
            this.thePlayer.input.onGameUnfocused();
        }
        this.inGameHasFocus = false;
        if (this.inputType == InputType.KEYBOARD) {
            this.mouseInput.releaseCursor();
        }
        this.worldRenderer.zooming = false;
    }

    public void displayInGameMenu() {
        if (this.currentScreen == null) {
            this.displayScreen(new ScreenPause());
        }
    }

    private void mineBlocks(boolean leftClickDown) {
        HitResult hitResult;
        @NotNull PlayerController playerController = Objects.requireNonNull(this.playerController);
        if (leftClickDown && (hitResult = this.objectMouseOver) instanceof HitResult.Tile) {
            @NotNull HitResult.Tile hitTile = (HitResult.Tile)hitResult;
            double xPlaced = hitTile.side.getAxis() == Axis.X ? hitTile.location.x() - (double)hitTile.tilePos.x() : (hitTile.side.getAxis() == Axis.Z ? hitTile.location.z() - (double)hitTile.tilePos.z() : hitTile.location.x() - (double)hitTile.tilePos.x());
            double yPlaced = hitTile.location.y() - (double)hitTile.tilePos.y();
            playerController.continueDestroyBlock(hitTile.tilePos, hitTile.side, xPlaced, yPlaced);
        } else {
            playerController.stopDestroyBlock();
        }
    }

    private void clickMouse(int clickType, boolean attack, boolean repeat) {
        ItemStack itemstack;
        this.mouseTicksRan = this.ticksRan;
        boolean flag = true;
        if (this.objectMouseOver == null) {
            AABBdc cube;
            List<AABBdc> cubes;
            if (((Boolean)GameSettings.EASY_BRIDGE.value).booleanValue() && clickType == 1 && !(this.thePlayer.xRot < 45.0f) && !(cubes = this.thePlayer.world.getCubes(this.thePlayer, this.thePlayer.bb.translate(0.0, -1.0, 0.0, new AABBd()))).isEmpty() && (cube = cubes.get(0)) != null) {
                @NotNull TilePos tilePos = new TilePos(MathHelper.floor(this.thePlayer.x), MathHelper.floor(this.thePlayer.y - (double)this.thePlayer.heightOffset - 0.25), MathHelper.floor(this.thePlayer.z));
                Direction playerDirection = Direction.getHorizontalDirection(this.thePlayer);
                if (!playerDirection.isVertical()) {
                    int numItemsInStack;
                    Side side = playerDirection.getSide();
                    double yPlaced = 0.5;
                    double xPlaced = 0.5;
                    ItemStack stack = this.thePlayer.inventory.getCurrentItem();
                    int n = numItemsInStack = stack == null ? 0 : stack.stackSize;
                    if (stack != null) {
                        if (this.playerController.placeItemStackOnTile(this.thePlayer, this.currentWorld, stack, tilePos, side, xPlaced, yPlaced)) {
                            this.playerController.swingItem(true);
                        }
                        if (stack.stackSize <= 0) {
                            this.thePlayer.inventory.setCurrentItem(null);
                        } else if (stack.stackSize != numItemsInStack) {
                            this.worldRenderer.itemRenderer.updateEquippedItem();
                        }
                    }
                }
            }
            if (clickType == 0 && attack) {
                this.playerController.swingItem(true);
            }
        } else {
            HitResult cubes = this.objectMouseOver;
            if (cubes instanceof HitResult.Entity) {
                HitResult.Entity hitEntity = (HitResult.Entity)cubes;
                if (clickType == 0 && attack) {
                    this.playerController.swingItem(true);
                    this.playerController.attack(this.thePlayer, hitEntity.entity);
                }
                if (clickType == 1 && this.playerController.interact(this.thePlayer, hitEntity.entity)) {
                    flag = false;
                }
            } else {
                cubes = this.objectMouseOver;
                if (cubes instanceof HitResult.Tile) {
                    HitResult.Tile hitTile = (HitResult.Tile)cubes;
                    double yPlaced = hitTile.location.y() - (double)hitTile.tilePos.y();
                    double xPlaced = hitTile.side.getAxis() == Axis.X ? hitTile.location.x() - (double)hitTile.tilePos.x() : (hitTile.side.getAxis() == Axis.Z ? hitTile.location.z() - (double)hitTile.tilePos.z() : hitTile.location.x() - (double)hitTile.tilePos.x());
                    if (clickType == 0) {
                        this.playerController.startDestroyBlock(hitTile.tilePos, hitTile.side, xPlaced, yPlaced, repeat);
                        if (this.thePlayer.getHeldObject() == null) {
                            this.playerController.swingItem(true);
                        }
                    } else {
                        int numItemsInStack;
                        ItemStack stack = this.thePlayer.inventory.getCurrentItem();
                        int n = numItemsInStack = stack == null ? 0 : stack.stackSize;
                        if (this.playerController.useOrPlaceItemStackOnTile(this.thePlayer, this.currentWorld, stack, hitTile.tilePos, hitTile.side, xPlaced, yPlaced)) {
                            flag = false;
                            this.playerController.swingItem(true);
                        }
                        if (stack == null) {
                            return;
                        }
                        if (stack.stackSize <= 0) {
                            this.thePlayer.inventory.mainInventory[this.thePlayer.inventory.getCurrentSlot()] = null;
                        } else if (stack.stackSize != numItemsInStack) {
                            this.worldRenderer.itemRenderer.resetEquippedProgress();
                        }
                    }
                }
            }
        }
        if (flag && clickType == 1 && (itemstack = this.thePlayer.inventory.getCurrentItem()) != null && this.playerController.useItemStackOnNothing(this.thePlayer, this.currentWorld, itemstack)) {
            this.worldRenderer.itemRenderer.resetEquippedProgress();
        }
    }

    public void resize() {
        this.resolution.setScale((Integer)GameSettings.GUI_SCALE.value);
        if (this.currentScreen != null) {
            this.currentScreen.opened(this.resolution.getScaledWidthScreenCoords(), this.resolution.getScaledHeightScreenCoords());
        }
    }

    private void clickMiddleMouseButton(boolean shift, boolean control) {
        HitResult mouseOver = this.thePlayer.rayCast(256.0, this.timer.partialTicks, false, false, false);
        if (mouseOver instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)mouseOver;
            int x = hitTile.tilePos.x();
            int y = hitTile.tilePos.y();
            int z = hitTile.tilePos.z();
            this.thePlayer.pickBlock(x, y, z, control);
        }
    }

    private void startCheckPaidThread() {
        new Thread(() -> {
            try {
                HttpURLConnection httpurlconnection = (HttpURLConnection)new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.session.username + "&session=" + this.session.sessionId).openConnection();
                httpurlconnection.connect();
                if (httpurlconnection.getResponseCode() == 400) {
                    hasPaidCheckTime = System.currentTimeMillis();
                }
                httpurlconnection.disconnect();
            }
            catch (Exception exception) {
                LOGGER.error("Error occurred while checking if paid client", exception);
            }
        }).start();
    }

    public void runTick() {
        if (this.ticksRan == 6000) {
            this.startCheckPaidThread();
        }
        if (this.hotbarSwapAnimationProgress > 0) {
            --this.hotbarSwapAnimationProgress;
        } else if (this.hotbarSwapAnimationProgress < 0) {
            ++this.hotbarSwapAnimationProgress;
        }
        Debug.push("gui");
        this.subtitleTracker.tick();
        this.statsCounter.tick();
        this.hudIngame.updateTick();
        Debug.change("misc");
        this.worldRenderer.getMouseOver(1.0f);
        if (this.thePlayer != null) {
            IChunkProvider chunkProvider = this.currentWorld.getChunkProvider();
            int playerChunkX = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
            int playerChunkZ = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
            chunkProvider.setCurrentChunkOver(playerChunkX, playerChunkZ);
        }
        if (!this.isGamePaused && this.currentWorld != null) {
            this.playerController.tick();
        }
        Debug.change("textureTick");
        TextureRegistry.worldAtlas.bind();
        this.textureManager.updateDynamicTextures(this.isGamePaused && this.currentScreen instanceof ScreenPause);
        Debug.change("misc");
        if (this.currentScreen == null && this.thePlayer != null) {
            if (this.thePlayer.getHealth() <= 0) {
                this.displayScreen(null);
            } else if (this.thePlayer.isPlayerSleeping() && this.currentWorld != null) {
                if (this.currentWorld.isClientSide) {
                    this.displayScreen(new ScreenSleepMP());
                } else {
                    this.displayScreen(new ScreenSleepSP());
                }
            }
        } else if (this.currentScreen != null && this.currentScreen instanceof ScreenSleepMP && !this.thePlayer.isPlayerSleeping()) {
            this.displayScreen(null);
        }
        Debug.change("input");
        if (this.currentScreen != null) {
            this.mouseTicksRan = this.ticksRan + 10000;
        }
        if (this.currentScreen != null && this.inputType == InputType.CONTROLLER && (this.mouseInput.deltaX != 0.0 || this.mouseInput.deltaY != 0.0)) {
            this.setInputType(InputType.KEYBOARD);
        }
        if (this.currentScreen != null) {
            this.currentScreen.updateEvents();
            if (this.currentScreen != null) {
                this.currentScreen.tick();
            }
        }
        if (this.currentScreen == null || this.currentScreen.passEvents) {
            boolean placeBlockPressed;
            while (Mouse.next()) {
                long delta = System.currentTimeMillis() - this.systemTime;
                if (delta <= 200L) {
                    int scrollDelta = Mouse.getEventDWheel();
                    if (scrollDelta != 0) {
                        if (this.thePlayer.noPhysics && this.toggleFlyPressed) {
                            float steps = 20.0f;
                            int step = Math.round(((Float)GameSettings.FLIGHT_SPEED.value).floatValue() * 20.0f);
                            float newSpeed = (float)(step += MathHelper.clamp(scrollDelta, -1, 1)) / 20.0f;
                            newSpeed = MathHelper.clamp(newSpeed, 0.0f, 5.0f);
                            GameSettings.FLIGHT_SPEED.value = Float.valueOf(newSpeed);
                            this.thePlayer.setFlySpeed(newSpeed);
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.FLIGHT_SPEED);
                        } else if (!GameSettings.KEY_ZOOM.isPressed()) {
                            this.thePlayer.inventory.changeCurrentSlot(scrollDelta);
                        }
                    }
                    if (!this.inGameHasFocus && Mouse.getEventButtonState()) {
                        this.setIngameFocus();
                    } else if (this.checkBoundInputs(InputDevice.mouse) && !Mouse.isGrabbed() && this.inputType == InputType.KEYBOARD && this.currentScreen == null) {
                        this.mouseInput.grabCursor();
                    }
                }
                this.thePlayer.input.keyEvent(-1, Mouse.getEventButton(), Mouse.getEventButtonState());
            }
            if (this.toggleFlyPressed && !GameSettings.KEY_FLY.isPressed()) {
                this.toggleFlyPressed = false;
                if (this.flyPressedTime + 400L > System.currentTimeMillis()) {
                    this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
                }
            }
            while (Keyboard.next()) {
                boolean control;
                if (Keyboard.getEventKeyState() && ((Boolean)GameSettings.SHOW_FRAME_TIMES.value).booleanValue() && DebugRender.keyPressed(Keyboard.getEventKey())) continue;
                @Nullable Runnable scriptBindAction = BindManager.getInstance().getActionForKey(Keyboard.getEventKey());
                if (scriptBindAction != null) {
                    scriptBindAction.run();
                    continue;
                }
                boolean shift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
                boolean bl = control = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
                if (!Keyboard.getEventKeyState() || !GameSettings.KEY_TOGGLE_DEBUG.isPressed()) {
                    this.thePlayer.input.keyEvent(Keyboard.getEventKey(), -1, Keyboard.getEventKeyState());
                }
                if (GameSettings.KEY_TOGGLE_DEBUG.isPressEvent()) {
                    this.f3Press = true;
                }
                if (GameSettings.KEY_TOGGLE_DEBUG.isReleaseEvent() && this.f3Press) {
                    if (control) {
                        GameSettings.SHOW_FRAME_TIMES.toggle();
                    } else {
                        GameSettings.SHOW_DEBUG_SCREEN.toggle();
                    }
                    this.f3Press = false;
                }
                if (Keyboard.getEventKeyState()) {
                    if (GameSettings.KEY_FULL_SCREEN.isPressEvent()) {
                        this.gameWindow.toggleFullscreen();
                        continue;
                    }
                    if (GameSettings.KEY_TOGGLE_DEBUG.isPressed()) {
                        if (Keyboard.getEventKey() == Keyboard.KEY_Q) {
                            this.hudIngame.addChatMessage(String.valueOf(TextFormatting.YELLOW) + "Keyboard shortcuts: ");
                            GameSettings.DEBUG_KEYS.sort(Comparator.comparing(KeyBinding::getKeyName));
                            for (KeyBinding binding : GameSettings.DEBUG_KEYS) {
                                this.hudIngame.addChatMessage(String.format("%s + %s: %s", GameSettings.KEY_TOGGLE_DEBUG.getKeyName(), binding.getKeyName(), I18n.getInstance().translateKey(binding.getId())));
                            }
                            this.hudIngame.addChatMessage(String.format("%s: %s", GameSettings.KEY_TOGGLE_TEXTURE_ATLAS.getKeyName(), I18n.getInstance().translateKey(GameSettings.KEY_TOGGLE_TEXTURE_ATLAS.getId())));
                            this.hudIngame.addChatMessage(String.format("%s: %s", GameSettings.KEY_RELEASE_CURSOR.getKeyName(), I18n.getInstance().translateKey(GameSettings.KEY_RELEASE_CURSOR.getId())));
                        }
                        if (GameSettings.KEY_RELOAD.isPressEvent()) {
                            this.forceReload();
                        } else if (GameSettings.KEY_SWITCH_GAMEMODE.isPressEvent()) {
                            if (this.currentWorld.getLevelData().getCheatsEnabled() || this.currentWorld.isClientSide) {
                                if (this.thePlayer.getGamemode() == Gamemodes.CREATIVE) {
                                    this.thePlayer.sendChatMessage("/gamemode survival");
                                } else {
                                    this.thePlayer.sendChatMessage("/gamemode creative");
                                }
                            }
                        } else if (GameSettings.KEY_DUMP_TEXTURES.isPressEvent()) {
                            Textures.dumpTextures();
                        } else if (GameSettings.KEY_FULLBRIGHT.isPressEvent()) {
                            PacketHandlerClient queue = this.getSendQueue();
                            if (queue != null) {
                                PlayerProfile profile = queue.getPlayer(this.thePlayer.username);
                                if (profile != null && profile.isOperator) {
                                    this.fullbright = !this.fullbright;
                                }
                            } else if (this.currentWorld.getLevelData().getCheatsEnabled()) {
                                this.fullbright = !this.fullbright;
                            }
                            this.hudIngame.heldItemTooltipElement.setString("Fullbright: " + (this.fullbright ? "On" : "Off"));
                        } else if (GameSettings.KEY_LIGHTMAPS.isPressEvent()) {
                            if (GameSettings.LIGHTMAP_STYLE.value == LightmapStyle.COLORIZED) {
                                GameSettings.LIGHTMAP_STYLE.value = LightmapStyle.GRAY;
                                this.hudIngame.heldItemTooltipElement.setString("Lightmap: Gray");
                            } else {
                                GameSettings.LIGHTMAP_STYLE.value = LightmapStyle.COLORIZED;
                                this.hudIngame.heldItemTooltipElement.setString("Lightmap: Colored");
                            }
                        } else if (GameSettings.KEY_COLLISION_BOXES.isPressEvent()) {
                            GameSettings.SHOW_COLLISION_BOXES.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.SHOW_COLLISION_BOXES);
                        } else if (GameSettings.KEY_CHUNK_BORDERS.isPressEvent()) {
                            GameSettings.SHOW_CHUNK_BORDERS.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.SHOW_CHUNK_BORDERS);
                        } else if (GameSettings.KEY_CLEAR_CHAT.isPressEvent()) {
                            this.hudIngame.clearChatMessages();
                        } else if (GameSettings.KEY_PAUSE_LOST_FOCUS.isPressEvent()) {
                            GameSettings.PAUSE_ON_LOST_FOCUS.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.PAUSE_ON_LOST_FOCUS);
                        } else if (GameSettings.KEY_TOGGLE_ITEM_INFO.isPressEvent()) {
                            GameSettings.SHOW_ITEM_DEBUG_INFO.toggle();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.SHOW_ITEM_DEBUG_INFO);
                        } else if (GameSettings.KEY_RELOAD_CHUNKS.isPressEvent()) {
                            this.renderGlobal.allChanged();
                        } else if (GameSettings.KEY_SMOOTH_LIGHTING.isPressEvent()) {
                            GameSettings.AMBIENT_OCCLUSION.toggle();
                            GameSettings.AMBIENT_OCCLUSION.onUpdate();
                            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.AMBIENT_OCCLUSION);
                        }
                        if (GameSettings.KEY_TOGGLE_DEBUG.isPressEvent()) continue;
                        this.f3Press = false;
                        continue;
                    }
                    if (GameSettings.KEY_RELEASE_CURSOR.isPressEvent()) {
                        this.mouseInput.releaseCursor();
                        continue;
                    }
                    if (GameSettings.KEY_SHOW_CONSOLE.isPressEvent() && ((Boolean)GameSettings.DEVELOPER_MODE.value).booleanValue()) {
                        this.displayScreen(new ScreenConsole(this.currentScreen));
                        continue;
                    }
                    if (Keyboard.getEventKey() == Keyboard.KEY_ESCAPE) {
                        this.displayInGameMenu();
                        continue;
                    }
                    if (GameSettings.KEY_COMMAND.isPressed()) {
                        this.displayScreen(new ScreenChat("/"));
                        continue;
                    }
                    this.checkBoundInputs(InputDevice.keyboard);
                    continue;
                }
                this.checkBoundInputs(InputDevice.keyboard);
            }
            boolean breakBlockPressed = GameSettings.KEY_ATTACK.isPressed() || this.controllerInput != null && this.controllerInput.buttonRightTrigger.isPressed();
            boolean bl = placeBlockPressed = GameSettings.KEY_INTERACT.isPressed() || this.controllerInput != null && this.controllerInput.buttonLeftTrigger.isPressed();
            if (this.currentScreen == null) {
                if (breakBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(0, (Boolean)GameSettings.AUTO_HIT.value, true);
                }
                if (placeBlockPressed && (float)(this.ticksRan - this.mouseTicksRan) >= this.timer.ticksPerSecond / 5.0f && this.inGameHasFocus) {
                    this.clickMouse(1, (Boolean)GameSettings.AUTO_HIT.value, true);
                }
            }
            this.mineBlocks(this.currentScreen == null && breakBlockPressed && this.inGameHasFocus);
        }
        InputHandler.poll();
        if (this.controllerInput != null) {
            this.handleControllerInput();
        }
        Debug.change("misc");
        if (this.currentWorld != null) {
            if (this.thePlayer != null) {
                ++this.joinPlayerCounter;
                if (this.joinPlayerCounter == 30) {
                    this.joinPlayerCounter = 0;
                    this.currentWorld.joinEntityInSurroundings(this.thePlayer);
                }
                this.thePlayer.setFlySpeed(((Float)GameSettings.FLIGHT_SPEED.value).floatValue());
                this.thePlayer.setFlightSmoothness(((Float)GameSettings.FLIGHT_SMOOTHNESS.value).floatValue());
                this.thePlayer.turnWithVehicle = (Boolean)GameSettings.TURN_WITH_VEHICLE.value;
            }
            if (!this.isGamePaused) {
                this.worldRenderer.updateRenderer();
                this.renderGlobal.tick();
                TileEntityRenderDispatcher.instance.tick();
                Debug.change("entity");
                if (this.currentWorld.lightningFlicker > 0) {
                    --this.currentWorld.lightningFlicker;
                }
                try {
                    this.currentWorld.updateEntities();
                }
                catch (StackOverflowError stackOverflowError) {
                    LOGGER.error("Stack overflow while updating world entities! Closing world!", stackOverflowError);
                    this.changeWorld(null);
                    throw new RuntimeException(stackOverflowError);
                }
                catch (Throwable t) {
                    LOGGER.error("Unhandled exception while updating world entities! Closing world!", t);
                    this.changeWorld(null);
                    throw t;
                }
                Debug.change("misc");
            }
            if (!this.isGamePaused || this.isMultiplayerWorld()) {
                Debug.change("world");
                try {
                    this.currentWorld.tick();
                }
                catch (StackOverflowError stackOverflowError) {
                    LOGGER.error("Stack overflow while updating world entities! Closing world!", stackOverflowError);
                    this.changeWorld(null);
                    throw new RuntimeException(stackOverflowError);
                }
                catch (Throwable t) {
                    LOGGER.error("Unhandled exception while ticking world! Closing world!", t);
                    this.changeWorld(null);
                    throw t;
                }
                Debug.change("misc");
            } else {
                try {
                    this.currentWorld.getChunkProvider().tick();
                }
                catch (Throwable throwable) {
                    LOGGER.error("Issue while ticking chunk provider!", throwable);
                }
            }
            if (!this.isGamePaused && this.currentWorld != null) {
                Debug.change("randomDisplayTick");
                this.currentWorld.randomDisplayUpdates(MathHelper.floor(this.thePlayer.x), MathHelper.floor(this.thePlayer.y), MathHelper.floor(this.thePlayer.z));
                Debug.change("misc");
            }
            if (!this.isGamePaused) {
                Debug.change("effects");
                this.particleEngine.tick();
                Debug.change("misc");
            }
        }
        this.systemTime = System.currentTimeMillis();
        Debug.pop();
    }

    private boolean checkBoundInputs(InputDevice currentInputDevice) {
        boolean control;
        boolean shift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
        boolean bl = control = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
        if (GameSettings.KEY_ATTACK.isPressEvent(currentInputDevice)) {
            this.clickMouse(0, true, false);
            return true;
        }
        if (GameSettings.KEY_INTERACT.isPressEvent(currentInputDevice)) {
            this.clickMouse(1, true, false);
            return true;
        }
        if (GameSettings.KEY_PICK_BLOCK.isPressEvent(currentInputDevice)) {
            this.clickMiddleMouseButton(shift, control);
            return true;
        }
        if (GameSettings.KEY_TOGGLE_OVERLAY.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger optionInteger = GameSettings.OVERLAY_MODE;
                Integer n = (Integer)optionInteger.value;
                optionInteger.value = (Integer)optionInteger.value + 1;
                optionInteger = GameSettings.OVERLAY_MODE;
                optionInteger.value = (Integer)optionInteger.value % 3;
            } else {
                int i;
                boolean on = false;
                for (i = 0; i < GameSettings.OVERLAY_ELEMENTS.length; ++i) {
                    if (!((Boolean)GameSettings.OVERLAY_ELEMENTS[i].value).booleanValue()) continue;
                    on = true;
                    break;
                }
                for (i = 0; i < GameSettings.OVERLAY_ELEMENTS.length; ++i) {
                    GameSettings.OVERLAY_ELEMENTS[i].value = !on;
                }
            }
            return true;
        }
        if (GameSettings.KEY_HIDE_GUI.isPressEvent(currentInputDevice)) {
            GameSettings.IMMERSIVE_MODE.toggle();
            return true;
        }
        if (GameSettings.KEY_SWITCH_PERSPECTIVE.isPressEvent(currentInputDevice)) {
            GameSettings.THIRD_PERSON_VIEW.value = ((Integer)GameSettings.THIRD_PERSON_VIEW.value + 1) % 3;
            return true;
        }
        if (GameSettings.KEY_CINEMATIC_CAMERA.isPressEvent(currentInputDevice)) {
            GameSettings.SMOOTH_CAMERA.value = (Boolean)GameSettings.SMOOTH_CAMERA.value == false;
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.SMOOTH_CAMERA);
            return true;
        }
        if (GameSettings.KEY_INVENTORY.isPressEvent(currentInputDevice)) {
            this.displayScreen(this.getInventoryScreen());
            return true;
        }
        if (GameSettings.KEY_GUIDEBOOK.isPressEvent(currentInputDevice)) {
            this.thePlayer.displayGuidebookScreen();
            return true;
        }
        if (GameSettings.KEY_DROP.isPressEvent(currentInputDevice)) {
            this.thePlayer.dropCurrentItem(control);
            return true;
        }
        if (GameSettings.KEY_PHOTO_MODE.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenPhotoMode());
            return true;
        }
        if (GameSettings.KEY_CHAT.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenChat());
            return true;
        }
        if (this.isMultiplayerWorld() && GameSettings.KEY_PLAYER_LIST.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger on = GameSettings.PLAYER_LIST_POSITION;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = GameSettings.PLAYER_LIST_POSITION;
                on.value = (Integer)on.value % 3;
            } else {
                GameSettings.SHOW_PLAYER_LIST.value = (Boolean)GameSettings.SHOW_PLAYER_LIST.value == false;
            }
            return true;
        }
        if (this.thePlayer.getGamemode().hasPlayerFlight() && GameSettings.KEY_FLY.isPressEvent(currentInputDevice)) {
            if (!this.toggleFlyPressed) {
                this.toggleFlyPressed = true;
            }
            this.flyPressedTime = System.currentTimeMillis();
            return true;
        }
        if (GameSettings.KEY_HOT_BAR_SWITCH.isPressEvent(currentInputDevice)) {
            if (!this.thePlayer.inventory.currentSlotLocked()) {
                if (shift) {
                    this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 27) % 36);
                    this.hotbarSwapAnimationProgress = -3;
                } else {
                    this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 9) % 36);
                    this.hotbarSwapAnimationProgress = 3;
                }
                this.thePlayer.inventory.changeCurrentSlot(0);
            }
            return true;
        }
        if (GameSettings.KEY_CENTER_VIEW.isPressEvent(currentInputDevice)) {
            this.thePlayer.xRot = 0.0f;
            return true;
        }
        if (GameSettings.KEY_LOCK_ROTATION.isPressEvent(currentInputDevice)) {
            if (control) {
                OptionInteger on = GameSettings.ROTATION_OVERLAY_MODE;
                Integer i = (Integer)on.value;
                on.value = (Integer)on.value + 1;
                on = GameSettings.ROTATION_OVERLAY_MODE;
                on.value = (Integer)on.value % 4;
            } else {
                if (this.thePlayer.rotationLock == null || this.thePlayer.rotationLock == Direction.NONE) {
                    this.thePlayer.rotationLock = Direction.getDirection(this.thePlayer);
                    this.thePlayer.rotationLockHorizontal = Direction.getHorizontalDirection(this.thePlayer);
                    this.thePlayer.rotationLockVertical = Direction.getVerticalDirection(this.thePlayer);
                } else {
                    this.thePlayer.rotationLock = null;
                    this.thePlayer.rotationLockHorizontal = null;
                    this.thePlayer.rotationLockVertical = null;
                }
                this.thePlayer.syncPlacementMode();
            }
            return true;
        }
        if (GameSettings.KEY_TOGGLE_FOG.isPressEvent(currentInputDevice)) {
            int renderDistance = (Integer)GameSettings.RENDER_DISTANCE.value;
            int nextRenderDistance = !shift ? renderDistance / 8 * 8 + 8 : (renderDistance - 1) / 8 * 8;
            if (nextRenderDistance > GameSettings.RENDER_DISTANCE.highest && !shift) {
                nextRenderDistance = GameSettings.RENDER_DISTANCE.highest;
            }
            if (nextRenderDistance < GameSettings.RENDER_DISTANCE.lowest && shift) {
                nextRenderDistance = GameSettings.RENDER_DISTANCE.lowest;
            }
            if (renderDistance == GameSettings.RENDER_DISTANCE.highest && !shift) {
                nextRenderDistance = GameSettings.RENDER_DISTANCE.lowest;
            }
            if (renderDistance == GameSettings.RENDER_DISTANCE.lowest && shift) {
                nextRenderDistance = GameSettings.RENDER_DISTANCE.highest;
            }
            GameSettings.RENDER_DISTANCE.set(nextRenderDistance);
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.RENDER_DISTANCE);
            return true;
        }
        if (GameSettings.KEY_TOGGLE_GAMMA.isPressEvent(currentInputDevice)) {
            int currentGammaStep = 2;
            if (((Float)GameSettings.GAMMA.value).floatValue() < 0.125f) {
                currentGammaStep = 0;
            } else if (((Float)GameSettings.GAMMA.value).floatValue() < 0.375f) {
                currentGammaStep = 1;
            } else if (((Float)GameSettings.GAMMA.value).floatValue() > 0.875f) {
                currentGammaStep = 4;
            } else if (((Float)GameSettings.GAMMA.value).floatValue() > 0.625f) {
                currentGammaStep = 3;
            }
            int newGammaStep = (currentGammaStep + (shift ? -1 : 1) + 5) % 5;
            GameSettings.GAMMA.value = Float.valueOf((float)newGammaStep * 0.25f);
            this.hudIngame.heldItemTooltipElement.setOptionNameAndValueString(GameSettings.GAMMA);
            return true;
        }
        if (GameSettings.KEY_HOT_BAR_LEFT.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentSlot(1);
            return true;
        }
        if (GameSettings.KEY_HOT_BAR_RIGHT.isPressEvent(currentInputDevice)) {
            this.thePlayer.inventory.changeCurrentSlot(-1);
            return true;
        }
        KeyBinding[] hotbarSlots = new KeyBinding[]{GameSettings.KEY_HOT_BAR_SLOT_1, GameSettings.KEY_HOT_BAR_SLOT_2, GameSettings.KEY_HOT_BAR_SLOT_3, GameSettings.KEY_HOT_BAR_SLOT_4, GameSettings.KEY_HOT_BAR_SLOT_5, GameSettings.KEY_HOT_BAR_SLOT_6, GameSettings.KEY_HOT_BAR_SLOT_7, GameSettings.KEY_HOT_BAR_SLOT_8, GameSettings.KEY_HOT_BAR_SLOT_9};
        for (int i = 0; i < hotbarSlots.length; ++i) {
            if (!hotbarSlots[i].isPressEvent(currentInputDevice)) continue;
            this.thePlayer.inventory.setCurrentSlot(i + this.thePlayer.inventory.getHotbarOffset(), false);
            return true;
        }
        if (GameSettings.KEY_ZOOM.isPressEvent(currentInputDevice)) {
            Mouse.getDWheel();
            this.worldRenderer.zooming = true;
            return true;
        }
        if (GameSettings.KEY_ZOOM.isReleaseEvent(currentInputDevice)) {
            this.worldRenderer.zooming = false;
            return true;
        }
        if (GameSettings.KEY_OPEN_ACHIEVEMENTS.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenAchievements(null, this.statsCounter));
        }
        if (GameSettings.KEY_OPEN_STATISTICS.isPressEvent(currentInputDevice)) {
            this.displayScreen(new ScreenStats(null, this.statsCounter));
        }
        return false;
    }

    private ScreenInventory getInventoryScreen() {
        if (this.thePlayer.getGamemode() == Gamemodes.CREATIVE) {
            return new ScreenInventoryCreative(this.thePlayer);
        }
        return new ScreenInventory(this.thePlayer);
    }

    public void handleControllerInput() {
        assert (this.controllerInput != null);
        try {
            this.controllerInput.update();
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred while updating controller input! Disabling controller input!", e);
            this.controllerInput = null;
            this.setInputType(InputType.KEYBOARD);
            return;
        }
        for (Joystick joystick : this.controllerInput.joysticks) {
            if (!(joystick.getX() < -0.5f || joystick.getX() > 0.5f || joystick.getY() < -0.5f) && !(joystick.getY() > 0.5f)) continue;
            this.setInputType(InputType.CONTROLLER);
        }
        ControllerInput controller = this.controllerInput;
        if (this.currentScreen == null) {
            if (controller.buttonRightTrigger.pressedThisFrame()) {
                this.clickMouse(0, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonLeftTrigger.pressedThisFrame()) {
                this.clickMouse(1, true, false);
                this.mouseTicksRan = this.ticksRan;
            }
            if (controller.buttonB.pressedThisFrame()) {
                this.thePlayer.dropCurrentItem(false);
            }
            if (controller.buttonY.pressedThisFrame() || controller.buttonX.pressedThisFrame()) {
                this.displayScreen(this.getInventoryScreen());
            }
            if (controller.buttonBack.pressedThisFrame()) {
                GameSettings.SHOW_PLAYER_LIST.value = (Boolean)GameSettings.SHOW_PLAYER_LIST.value == false;
            }
            if (controller.buttonStart.pressedThisFrame()) {
                this.displayScreen(new ScreenPause());
            }
            if (controller.digitalPad.up.pressedThisFrame() && !this.thePlayer.inventory.currentSlotLocked()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 27) % 36);
                this.hotbarSwapAnimationProgress = -3;
                this.thePlayer.inventory.changeCurrentSlot(0);
            }
            if (controller.digitalPad.down.pressedThisFrame() && !this.thePlayer.inventory.currentSlotLocked()) {
                this.thePlayer.setHotbarOffset((this.thePlayer.inventory.getHotbarOffset() + 9) % 36);
                this.hotbarSwapAnimationProgress = 3;
                this.thePlayer.inventory.changeCurrentSlot(0);
            }
            if (controller.digitalPad.left.pressedThisFrame() && this.thePlayer.getGamemode().hasPlayerFlight()) {
                this.thePlayer.setNoclip(!this.thePlayer.noPhysics);
            }
            if (controller.buttonLeftShoulder.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentSlot(1);
            }
            if (controller.buttonRightShoulder.pressedThisFrame()) {
                this.thePlayer.inventory.changeCurrentSlot(-1);
            }
            if (controller.joyLeft.getButton().pressedThisFrame()) {
                OptionInteger optionInteger = GameSettings.THIRD_PERSON_VIEW;
                Integer n = (Integer)optionInteger.value;
                optionInteger.value = (Integer)optionInteger.value + 1;
                optionInteger = GameSettings.THIRD_PERSON_VIEW;
                optionInteger.value = (Integer)optionInteger.value % 3;
            }
            if (this.controllerInput.digitalPad.right.pressedThisFrame()) {
                this.thePlayer.displayGuidebookScreen();
            }
        } else {
            try {
                this.currentScreen.controllerInput(controller);
            }
            catch (Exception e) {
                LOGGER.error("Exception occurred while running gui specific controller actions!", e);
            }
        }
    }

    private void forceReload() {
        long start = System.nanoTime();
        LOGGER.info("FORCING RELOAD!");
        I18n.getInstance().reload((String)GameSettings.LANGUAGE.value);
        this.sndManager = new SoundEngine();
        this.sndManager.init();
        this.texturePackList.refresh();
        this.renderer.reload();
        Shaders.reload();
        if (this.renderGlobal != null) {
            this.renderGlobal.allChanged();
        }
        LOGGER.debug("RELOAD TOOK '{}' SECONDS!", (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public boolean isMultiplayerWorld() {
        return this.currentWorld != null && this.currentWorld.isClientSide;
    }

    public void createAndStartWorld(@NotNull WorldConfiguration worldConfiguration) {
        @NotNull LevelStorage levelStorage = this.saveFormat.getSaveHandler(worldConfiguration.getFolderName(this.saveFormat), false);
        for (Dimension dimension : Dimension.getDimensionList().values()) {
            @Nullable WorldType worldType = worldConfiguration.getWorldTypeGroup().get(dimension);
            if (worldType == null) continue;
            @NotNull DimensionData data = new DimensionData(worldType);
            levelStorage.saveDimensionData(dimension.id, data);
        }
        @NotNull WorldClient world = new WorldClient(levelStorage, worldConfiguration.getFinalWorldName(), worldConfiguration.getFinalNumericSeed(), Dimension.OVERWORLD, null, worldConfiguration.getStartingBiome());
        world.getLevelData().setCheatsEnabled(worldConfiguration.getCheatsEnabled());
        world.getLevelData().getGameRules().setValues(worldConfiguration.getGameRuleCollection());
        world.getSpawnerConfig().set(worldConfiguration.getSpawnerConfig());
        this.statsCounter.add(StatList.createWorldStat, 1);
        this.statsCounter.add(StatList.startGameStat, 1);
        this.playerController = new PlayerControllerSP(this);
        this.changeWorld(world, I18n.getInstance().translateKey("gui.loading.label.generating"));
        this.thePlayer.setGamemode(worldConfiguration.getGamemode());
        if (worldConfiguration.getGamemode() == Gamemodes.ADVENTURE) {
            this.thePlayer.inventory.insertItem(Items.TOOL_AXE_WOOD.getDefaultStack(), true);
        }
    }

    public void startWorld(String worldDirName) {
        this.changeWorld(null);
        System.gc();
        int worldSaveVersion = 0;
        try {
            LevelData info = new LevelData(new File(this.mcDataDir, "saves/" + worldDirName));
            worldSaveVersion = info.getSaveVersion();
        }
        catch (IOException e) {
            worldSaveVersion = this.saveFormat.getSaveVersion();
        }
        if (worldSaveVersion < 19134) {
            this.convertSaveVersion(worldSaveVersion, worldDirName);
        } else {
            I18n i18n = I18n.getInstance();
            LevelStorage saveHandler = this.saveFormat.getSaveHandler(worldDirName, false);
            Dimension dimension = null;
            CompoundTag tag = saveHandler.getPlayerData(this.session.username, this.session.uuid);
            if (tag != null) {
                dimension = (Dimension)Dimension.getDimensionList().get(tag.getInteger("Dimension"));
            }
            WorldClient world = new WorldClient(saveHandler, null, 0L, dimension, null, null);
            this.statsCounter.add(StatList.loadWorldStat, 1);
            this.statsCounter.add(StatList.startGameStat, 1);
            this.changeWorld(world, i18n.translateKey("gui.loading.label.loading"));
        }
    }

    public void usePortal(int dim, @Nullable DyeColor portalColor) {
        double dz;
        double dy;
        double dx;
        double distSqr;
        Dimension lastDim = (Dimension)Dimension.getDimensionList().get(this.thePlayer.dimension);
        Dimension newDim = (Dimension)Dimension.getDimensionList().get(dim);
        LOGGER.info("Switching to dimension \"{}\"!!", (Object)newDim.getTranslatedName());
        this.thePlayer.dimension = dim;
        this.currentWorld.setEntityDead(this.thePlayer);
        this.thePlayer.removed = false;
        double x = this.thePlayer.x;
        double z = this.thePlayer.z;
        double y = this.thePlayer.y;
        this.thePlayer.moveTo(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), this.thePlayer.yRot, this.thePlayer.xRot);
        ChunkCoordinates newCoordinates = new ChunkCoordinates(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
        if (this.thePlayer.isAlive() && this.thePlayer.dimensionEnterCoordinate != null && (distSqr = (dx = (double)this.thePlayer.dimensionEnterCoordinate.x - x) * dx + (dy = (double)this.thePlayer.dimensionEnterCoordinate.y - y) * dy + (dz = (double)this.thePlayer.dimensionEnterCoordinate.z - z) * dz) > 6.4E7) {
            this.thePlayer.addStat(Achievements.FAST_TRAVEL, 1);
        }
        this.thePlayer.dimensionEnterCoordinate = newCoordinates;
        if (this.thePlayer.isAlive()) {
            this.currentWorld.updateEntityWithOptionalForce(this.thePlayer, false);
        }
        WorldClient world = new WorldClient(this.currentWorld, newDim);
        I18n i18n = I18n.getInstance();
        if (newDim == lastDim.homeDim) {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.leaving", lastDim.getTranslatedName()), this.thePlayer);
        } else {
            this.changeWorld(world, i18n.translateKeyAndFormat("gui.loading.label.entering", newDim.getTranslatedName()), this.thePlayer);
        }
        this.thePlayer.world = this.currentWorld;
        if (this.thePlayer.isAlive()) {
            this.thePlayer.moveTo(x, y, z, this.thePlayer.yRot, this.thePlayer.xRot);
            this.currentWorld.updateEntityWithOptionalForce(this.thePlayer, false);
            new PortalHandler().teleportEntity(this.currentWorld, this.thePlayer, portalColor, lastDim, newDim);
        }
    }

    public void changeWorld(WorldClient world) {
        this.changeWorld(world, "");
    }

    public void changeWorld(WorldClient world, String loadingTitle) {
        this.changeWorld(world, loadingTitle, null);
    }

    public void changeWorld(WorldClient world, String loadingTitle, @Nullable Player player) {
        this.mainMenuBackground.deleteTextures();
        GameSettings.SHOW_COLLISION_BOXES.value = false;
        this.fullbright = false;
        this.statsCounter.fetchStats();
        this.statsCounter.saveStats();
        if (world != null) {
            this.loadingScreen.updateLoadingBackground(world.dimension);
            this.loadingScreen.progressStart(loadingTitle);
            this.loadingScreen.progressStage("");
        }
        this.sndManager.stopMusic();
        if (this.currentWorld != null) {
            this.currentWorld.saveWorldIndirectly(this.loadingScreen);
            if (this.currentWorld.saveHandler != null) {
                IChunkLoader loader = this.currentWorld.saveHandler.getChunkLoader(this.currentWorld.dimension);
                if (loader != null) {
                    while (loader.isSaving()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                this.currentWorld.getChunkProvider().unloadAllChunks();
                this.currentWorld.onUnload();
                this.currentWorld.close();
                if (player != null) {
                    this.currentWorld.saveHandler.save(player);
                }
            }
        }
        this.currentWorld = world;
        if (this.currentWorld != null) {
            Colorizers.update(true);
        }
        if (world != null) {
            if (!this.isMultiplayerWorld()) {
                if (player == null) {
                    this.thePlayer = null;
                }
            } else if (this.thePlayer != null) {
                this.thePlayer.resetPos();
                world.entityJoinedWorld(this.thePlayer);
            }
            if (!world.isClientSide) {
                this.prepareLevel(loadingTitle);
            }
            if (this.thePlayer == null) {
                this.thePlayer = (PlayerLocal)this.playerController.createPlayer(world);
                this.thePlayer.resetPos();
            }
            this.thePlayer.input = new PlayerInput(this);
            if (this.particleEngine != null) {
                this.particleEngine.setWorld(world);
            }
            IChunkProvider ichunkprovider = world.getChunkProvider();
            int i = MathHelper.floor_float((int)this.thePlayer.x) >> 4;
            int j = MathHelper.floor_float((int)this.thePlayer.z) >> 4;
            ichunkprovider.setCurrentChunkOver(i, j);
            world.spawnPlayerWithLoadedChunks(this.thePlayer, false);
            if (world.isNewWorld) {
                world.saveWorldIndirectly(this.loadingScreen);
            }
            this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
            this.thePlayer.syncPlacementMode();
            if (this.renderGlobal != null) {
                this.renderGlobal.setWorld(world);
            }
        } else {
            this.thePlayer = null;
        }
        System.gc();
        this.systemTime = 0L;
        if (world != null) {
            this.loadingScreen.progressStop();
        }
        this.worldRenderer.lightmapHelper.setup();
        Colorizers.reload();
        BlockColorDispatcher.getInstance().onWorldChanged(this.currentWorld);
        EntityRendererDispatcher.instance.onWorldChanged(this.currentWorld);
        TileEntityRenderDispatcher.instance.onWorldChanged(this.currentWorld);
        BlockModelDispatcher.getInstance().onWorldChanged(this.currentWorld);
    }

    private void convertSaveVersion(int fromVersion, String worldDirName) {
        ISaveFormat fromWorldFormat = SaveFormats.createSaveFormat(fromVersion, new File(this.mcDataDir, "saves"));
        if (fromWorldFormat != null) {
            ISaveFormat toWorldFormat;
            ISaveConverter converterToUse = null;
            for (ISaveConverter converter : SaveConverters.saveConverters) {
                if (converter.fromVersion() != fromVersion || converterToUse != null && converter.toVersion() <= converterToUse.toVersion()) continue;
                converterToUse = converter;
            }
            if (converterToUse != null && (toWorldFormat = SaveFormats.createSaveFormat(converterToUse.toVersion(), new File(this.mcDataDir, "saves"))) != null) {
                this.loadingScreen.updateLoadingBackground(null);
                this.loadingScreen.progressStartNoAbort("Converting world from " + fromWorldFormat.getFormatName() + " to " + toWorldFormat.getFormatName() + ".");
                this.loadingScreen.progressStage("This may take a while :)");
                CompoundTag levelDataTag = toWorldFormat.getLevelDataRaw(worldDirName);
                converterToUse.convertSave(levelDataTag, new File(this.mcDataDir, "saves"), worldDirName, this.loadingScreen);
                this.loadingScreen.progressStop();
                levelDataTag.putInt("version", toWorldFormat.getSaveVersion());
                LevelStorage saveHandler = toWorldFormat.getSaveHandler(worldDirName, false);
                saveHandler.saveLevelDataRaw(levelDataTag);
                this.startWorld(worldDirName);
            }
        }
    }

    private void prepareLevel(String loadingTitle) {
        this.loadingScreen.updateLoadingBackground(this.currentWorld.dimension);
        this.loadingScreen.progressStartNoAbort(loadingTitle);
        this.loadingScreen.progressStage("Building terrain");
        int c = 128;
        int i = 0;
        int j = c * 2 / 16 + 1;
        j *= j;
        IChunkProvider ichunkprovider = this.currentWorld.getChunkProvider();
        TilePos spawnPoint = this.currentWorld.getSpawnPoint();
        if (this.thePlayer != null) {
            spawnPoint.x = (int)this.thePlayer.x;
            spawnPoint.z = (int)this.thePlayer.z;
        }
        ichunkprovider.setCurrentChunkOver(Math.floorDiv(spawnPoint.x, 16), Math.floorDiv(spawnPoint.z, 16));
        for (int k = -c; k <= c; k += 16) {
            for (int l = -c; l <= c; l += 16) {
                this.loadingScreen.progressStagePercentage(i++ * 100 / j);
                this.currentWorld.getBlockId(spawnPoint.x + k, 64, spawnPoint.z + l);
            }
        }
        this.loadingScreen.progressStage("Updating Lights");
        int count = this.currentWorld.getLightingEngine().pendingUpdates();
        int v = 0;
        while (this.currentWorld.updatingLighting()) {
            this.loadingScreen.progressStagePercentage(Math.min(++v, count) * 100 / count);
            if (v < 10000) continue;
            LOGGER.error("Updating lights took to long panic skipping!");
            Thread.dumpStack();
            break;
        }
        this.loadingScreen.progressStage("Simulating world for a bit...");
        this.loadingScreen.progressStop();
        this.currentWorld.dropOldChunks();
    }

    public String getRendererDebugInfo() {
        return this.renderGlobal.getRendererDebugInfo();
    }

    public String getEntityDebugInfoString() {
        return this.renderGlobal.getEntityDebugInfo();
    }

    public String getChunkProviderInfoString() {
        return this.currentWorld.getChunkProviderInfoString();
    }

    public String getEntityCountsInfoString() {
        return "P: " + this.particleEngine.countParticles() + ". T: " + this.currentWorld.getNumLoadedEntitiesString();
    }

    public void respawn(boolean multiplayer, int targetDimension) {
        @Nullable PlayerLocal previousPlayer = this.thePlayer;
        if (!this.currentWorld.isClientSide && !this.currentWorld.dimension.defaultWorldType.mayRespawn()) {
            this.usePortal(targetDimension, null);
        }
        TilePos spawnCoordinates = null;
        TilePos bedSpawnCoordinates = null;
        TilePos lastDeathCoordinates = null;
        boolean canRespawnAtBed = true;
        if (this.thePlayer != null && !multiplayer) {
            spawnCoordinates = this.thePlayer.getPlayerSpawnPoint();
            lastDeathCoordinates = this.thePlayer.getLastDeathPoint();
            if (spawnCoordinates != null && (bedSpawnCoordinates = Player.getValidBedSpawnCoordinates(this.currentWorld, spawnCoordinates)) == null) {
                this.thePlayer.sendTranslatedChatMessage("bed.notValid");
            }
        }
        if (bedSpawnCoordinates == null) {
            bedSpawnCoordinates = this.currentWorld.getSpawnPoint();
            canRespawnAtBed = false;
        }
        IChunkProvider ichunkprovider = this.currentWorld.getChunkProvider();
        ichunkprovider.setCurrentChunkOver(bedSpawnCoordinates.x >> 4, bedSpawnCoordinates.z >> 4);
        this.currentWorld.getRespawnLocation();
        this.currentWorld.updateEntityList();
        int j = 0;
        Gamemode playerGamemode = Gamemodes.SURVIVAL;
        if (this.thePlayer != null) {
            j = this.thePlayer.id;
            this.currentWorld.setEntityDead(this.thePlayer);
            playerGamemode = this.thePlayer.getGamemode();
        }
        this.thePlayer = (PlayerLocal)this.playerController.createPlayer(this.currentWorld);
        this.thePlayer.dimension = targetDimension;
        this.thePlayer.setGamemode(playerGamemode);
        if (previousPlayer != null && previousPlayer.getHeldObject() != null) {
            this.thePlayer.setHeldObject(previousPlayer.getHeldObject());
            this.thePlayer.inventory.setCurrentSlot(previousPlayer.inventory.getCurrentSlot(), true);
            this.thePlayer.inventory.setHotbarOffset(previousPlayer.inventory.getHotbarOffset(), true);
        }
        this.activeCamera = new EntityCameraFirstPerson(this, this.thePlayer);
        this.thePlayer.resetPos();
        if (previousPlayer != null) {
            this.thePlayer.messageHistory = previousPlayer.messageHistory;
            if (!this.currentWorld.isClientSide) {
                this.thePlayer.inventory.transferAllContents(previousPlayer.inventory);
            }
        }
        if (canRespawnAtBed) {
            this.thePlayer.setPlayerSpawnPoint(spawnCoordinates);
            this.thePlayer.moveTo((float)bedSpawnCoordinates.x + 0.5f, (float)bedSpawnCoordinates.y + 0.1f, (float)bedSpawnCoordinates.z + 0.5f, 0.0f, 0.0f);
        }
        this.thePlayer.setLastDeathPoint(lastDeathCoordinates);
        this.currentWorld.spawnPlayerWithLoadedChunks(this.thePlayer, true);
        this.thePlayer.input = new PlayerInput(this);
        this.thePlayer.id = j;
        this.thePlayer.animate4();
        this.prepareLevel("Respawning");
        if (this.currentScreen instanceof ScreenGameOver) {
            this.displayScreen(null);
        }
    }

    public PacketHandlerClient getSendQueue() {
        if (this.thePlayer instanceof PlayerLocalMultiplayer) {
            return ((PlayerLocalMultiplayer)this.thePlayer).sendQueue;
        }
        return null;
    }

    public void setRenderer(Renderer renderer) {
        if (this.renderer != null) {
            this.renderer.delete();
        }
        this.renderer = renderer;
        this.renderer.reload();
    }

    public static void startMainThread(@Nullable String username, @Nullable String sessionId, @Nullable String uuid, @Nullable String server, @Nullable Integer port, @Nullable Integer width, @Nullable Integer height, @Nullable File mcDataDir) {
        GameWindowGLFW gameWindow = new GameWindowGLFW();
        Minecraft mc = new Minecraft(mcDataDir == null ? Minecraft.getAppDir("minecraft-bta") : mcDataDir, gameWindow);
        mc.minecraftUri = "www.minecraft.net";
        username = username == null ? "Player" + System.currentTimeMillis() % 1000L : username;
        String string = sessionId = sessionId == null ? "" : sessionId;
        if (uuid == null || !UUIDHelper.isUUID(uuid)) {
            UUID nameUUID = UUIDHelper.getUUIDFromName(username);
            if (nameUUID != null) {
                uuid = nameUUID.toString();
            }
            if (uuid == null) {
                uuid = "00000000-0000-0000-0000-000000000000";
            }
        }
        mc.session = new Session(username, uuid, sessionId);
        if (server != null) {
            mc.setServer(server, port == null ? 25565 : port);
        }
        if (width != null) {
            mc.overrideWidth = width;
        }
        if (height != null) {
            mc.overrideHeight = height;
        }
        mc.run();
    }

    public static void main(String[] args2) {
        STARTUP_TIKE_KEEPER.start("Startup");
        ImageIO.setUseCache(false);
        Minecraft.checkLwjglVersion();
        if (Minecraft.isClientASteamDeck()) {
            LOGGER.info("Client is a Steam Deck!");
        }
        String playerName = null;
        String sessionId = null;
        File gameDirectory = null;
        String uuid = null;
        String server = null;
        Integer port = null;
        Integer width = null;
        Integer height = null;
        int pointer = 0;
        block38: while (pointer < args2.length) {
            switch (args2[pointer]) {
                case "--debug": {
                    Global.DEBUG_MODE = true;
                    continue block38;
                }
                case "--username": {
                    try {
                        playerName = args2[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--session": {
                    try {
                        sessionId = args2[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--uuid": {
                    try {
                        uuid = args2[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--gameDir": {
                    try {
                        gameDirectory = new File(args2[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--server": {
                    try {
                        server = args2[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--port": {
                    try {
                        port = Integer.parseInt(args2[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--width": {
                    try {
                        width = Integer.parseInt(args2[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
                case "--height": {
                    try {
                        height = Integer.parseInt(args2[pointer + 1]);
                        ++pointer;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                    ++pointer;
                    continue block38;
                }
            }
            ++pointer;
        }
        if (Global.DEBUG_MODE) {
            LOGGER.info("Enabling LWJGL debug stack");
            Configuration.DEBUG.set(true);
            Configuration.DEBUG_LOADER.set(true);
            Configuration.DEBUG_STACK.set(true);
            Configuration.DEBUG_MEMORY_ALLOCATOR.set(true);
            Configuration.DEBUG_FUNCTIONS.set(true);
        }
        Minecraft.startMainThread(playerName, sessionId, uuid, server, port, width, height, gameDirectory);
    }

    public void setInputType(InputType inputType) {
        if (inputType != this.inputType) {
            LOGGER.info("Set input type to {}", (Object)inputType.name());
        }
        this.inputType = inputType;
        if (inputType == InputType.CONTROLLER) {
            this.mouseInput.grabCursor();
        }
        if (inputType == InputType.KEYBOARD) {
            if (this.inGameHasFocus && !Mouse.isGrabbed()) {
                this.mouseInput.grabCursor();
            }
            if (!this.inGameHasFocus && Mouse.isGrabbed()) {
                this.mouseInput.releaseCursor();
            }
        }
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return this.skinVariantList;
    }

    @Override
    public Collection<String> getAvailableSoundKeys() {
        return SoundRepository.allKeys;
    }

    public boolean isAmbientOcclusionEnabled() {
        return (Boolean)GameSettings.AMBIENT_OCCLUSION.value;
    }

    public boolean isTreeShadingEnabled() {
        return (Boolean)GameSettings.TREE_SHADOWS.value;
    }

    public boolean isDebugInfoEnabled() {
        return (Boolean)GameSettings.SHOW_DEBUG_SCREEN.value;
    }

    @Override
    public boolean isFullbrightEnabled() {
        return this.fullbright;
    }

    public boolean canRenderEntityLabel() {
        return this.isDebugInfoEnabled() && this.thePlayer != null && this.thePlayer.getGamemode() == Gamemodes.CREATIVE;
    }

    public float getOutlineWidth() {
        return ((Float)GameSettings.BLOCK_OUTLINE_WIDTH.value).floatValue();
    }

    @Override
    public int getAutosaveTimer() {
        return (int)(((Float)GameSettings.AUTOSAVE_TIMER.value).floatValue() * 24.0f) * 5;
    }

    @Override
    public void copyToClipboard(String str) {
        GLFW.glfwSetClipboardString(this.gameWindow.getHandle(), str);
    }

    @Override
    public String readFromClipboard() {
        return GLFW.glfwGetClipboardString(this.gameWindow.getHandle());
    }

    @NotNull
    public static Minecraft getMinecraft() {
        return INSTANCE;
    }

    static {
        numRecordedFrameTimes = 0;
        hasPaidCheckTime = 0L;
        STARTUP_TIKE_KEEPER = new TimeKeeper();
        System.setProperty("java.awt.headless", "true");
    }

    private static class TimeKeeper {
        @NotNull
        private final @NotNull Object2LongMap<@NotNull String> startTimes = new Object2LongLinkedOpenHashMap<String>();
        @NotNull
        private final @NotNull Object2LongMap<@NotNull String> endTimes = new Object2LongLinkedOpenHashMap<String>();

        private TimeKeeper() {
        }

        public void start(@NotNull String key) {
            if (this.startTimes.containsKey(key)) {
                LOGGER.error("Start key {} already assigned", (Object)key);
            }
            this.startTimes.put(key, System.currentTimeMillis());
        }

        public void end(@NotNull String key) {
            if (this.endTimes.containsKey(key)) {
                LOGGER.error("End key {} already assigned", (Object)key);
            }
            this.endTimes.put(key, System.currentTimeMillis());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Startup Times: ");
            for (String s : this.startTimes.keySet()) {
                if (!this.endTimes.containsKey(s)) {
                    LOGGER.error("Perf key {} not ended!", (Object)s);
                    continue;
                }
                long start = this.startTimes.getLong(s);
                long end = this.endTimes.getLong(s);
                builder.append("\n\t").append(s).append(": ").append((double)(end - start) / 1000.0).append("s");
            }
            return builder.toString();
        }
    }
}

