/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.entity.player.PlayerLocalMultiplayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.HeldItemTooltipElement;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.gui.chat.ScreenChat;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.terrain.RenderList;
import net.minecraft.client.render.terrain.RenderRegion;
import net.minecraft.client.render.terrain.TerrainRenderer;
import net.minecraft.client.render.terrain.TerrainRendererMultiDraw;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.tessellator.TessellatorTerrainImpl;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ChatLine;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Utils;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindProvider;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.Version;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class HudIngame
extends Gui {
    public static final float DEBUG_SCALE = 1.0f;
    public static final int MAX_CHAT_WIDTH = 320;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    @NotNull
    private final @NotNull List<@NotNull ChatLine> chatMessageList = new ArrayList<ChatLine>();
    protected Minecraft mc;
    public int updateCounter = 0;
    private String recordPlaying = "";
    private int recordPlayingUpFor = 0;
    private boolean colorString = false;
    public float destroyProgress;
    float prevVignetteBrightness = 1.0f;
    protected FontRenderer fontRenderer;
    public int chatScroll = 0;
    public final HeldItemTooltipElement heldItemTooltipElement;
    private int debugLine = 0;
    private int debugLineRight = 0;
    private int debugOffset = 0;
    private int debugOffsetRight = 0;
    private final int debugLineHeight = 10;
    private final List<String> playerListScoreStrings = new ArrayList<String>();

    public HudIngame(Minecraft minecraft) {
        this.mc = minecraft;
        this.fontRenderer = this.mc.font;
        this.heldItemTooltipElement = new HeldItemTooltipElement();
    }

    public void renderGameOverlay(float partialTicks, boolean flag, int mouseX, int mouseY) {
        float portalIntensity;
        if (this.mc.currentScreen instanceof ScreenPhotoMode) {
            return;
        }
        I18n stringtranslate = I18n.getInstance();
        int width = this.mc.resolution.getScaledWidthScreenCoords();
        int height = this.mc.resolution.getScaledHeightScreenCoords();
        int sp = (int)(((Float)GameSettings.SCREEN_PADDING.value).floatValue() * (float)height / 8.0f);
        this.mc.worldRenderer.setupScaledResolution();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        if (GameSettings.IMMERSIVE_MODE.drawVignette() && ((Boolean)GameSettings.VIGNETTE.value).booleanValue()) {
            this.renderVignette(this.mc.thePlayer.getBrightness(partialTicks), width, height);
        }
        ItemStack headSlotItem = this.mc.thePlayer.inventory.armorItemInSlot(HumanArmorShape.HEAD);
        if ((Integer)GameSettings.THIRD_PERSON_VIEW.value == 0 && headSlotItem != null && (headSlotItem.getItem() == Blocks.PUMPKIN_CARVED_IDLE.asItem() || headSlotItem.getItem() == Blocks.PUMPKIN_REDSTONE.asItem())) {
            this.renderPumpkinBlur(width, height);
        }
        if ((portalIntensity = MathHelper.lerp(this.mc.thePlayer.prevTimeInPortal, this.mc.thePlayer.timeInPortal, partialTicks)) > 0.0f) {
            this.renderPortalOverlay(portalIntensity, width, height);
        }
        for (HudComponent component : HudComponents.INSTANCE.getComponents()) {
            if (!component.isVisible()) continue;
            GLRenderer.pushFrame();
            component.render(this, width - sp * 2, height - sp * 2, partialTicks);
            GLRenderer.popFrame();
        }
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        Lighting.disable();
        if (this.mc.thePlayer.getSleepTimer() > 0) {
            GLRenderer.disableState(State.DEPTH_TEST);
            int i2 = this.mc.thePlayer.getSleepTimer();
            float f3 = (float)i2 / 100.0f;
            if (f3 > 1.0f) {
                f3 = 1.0f - (float)(i2 - 100) / 10.0f;
            }
            int j4 = (int)(220.0f * f3) << 24 | 0x101020;
            this.drawRect(0, 0, width, height, j4);
            GLRenderer.enableState(State.DEPTH_TEST);
        }
        if (GameSettings.IMMERSIVE_MODE.drawOverlays()) {
            this.drawRecordPlayingOverlay(width, height - sp, partialTicks);
            boolean clock = false;
            boolean compass = false;
            boolean rotaryCalendar = false;
            if (this.mc.thePlayer.getGamemode() == Gamemodes.CREATIVE) {
                clock = true;
                compass = true;
                rotaryCalendar = true;
            } else {
                for (int iinv = 0; iinv < this.mc.thePlayer.inventory.getContainerSize(); ++iinv) {
                    ItemStack item = this.mc.thePlayer.inventory.getItem(iinv);
                    if (item == null) continue;
                    if (item.itemID == Items.TOOL_CLOCK.id) {
                        clock = true;
                    }
                    if (item.itemID == Items.TOOL_COMPASS.id) {
                        compass = true;
                    }
                    if (item.itemID != Items.TOOL_CALENDAR.id) continue;
                    rotaryCalendar = true;
                }
            }
            if (!((Boolean)GameSettings.SHOW_DEBUG_SCREEN.value).booleanValue()) {
                this.drawPlayerList(width, height, sp);
            }
            if (((Boolean)GameSettings.SHOW_DEBUG_SCREEN.value).booleanValue()) {
                GLRenderer.pushFrame();
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                GLRenderer.modelM4f().scale(1.0f, 1.0f, 1.0f);
                this.debugLine = 0;
                this.debugLineRight = 0;
                this.debugOffset = 0;
                this.debugOffsetRight = 0;
                long memMax = Runtime.getRuntime().maxMemory();
                long memTotal = Runtime.getRuntime().totalMemory();
                long memFree = Runtime.getRuntime().freeMemory();
                long memUsed = memTotal - memFree;
                int space = 6;
                this.drawDebugScreenLineRight("Used memory: " + memUsed * 100L / memMax + "% (" + memUsed / 1024L / 1024L + "MB) of " + memMax / 1024L / 1024L + "MB");
                this.drawDebugScreenLineRight("Allocated memory: " + memTotal * 100L / memMax + "% (" + memTotal / 1024L / 1024L + "MB)");
                this.drawDebugScreenLineRight("JRE: " + System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
                this.drawDebugScreenLineRight("LWJGL version: " + Version.getVersion());
                this.debugOffsetRight += space;
                this.drawDebugScreenLineRight(OpenGLHelper.vendor);
                this.drawDebugScreenLineRight(OpenGLHelper.renderer);
                this.drawDebugScreenLineRight(OpenGLHelper.version);
                this.drawDebugScreenLineRight(String.format("OpenGL %s.%s", GL41.glGetInteger(33307), GL41.glGetInteger(33308)));
                long availableVRam = OpenGLHelper.availableVRam();
                long totalVRam = OpenGLHelper.totalVRam();
                if (totalVRam != -1L || availableVRam != -1L) {
                    this.drawDebugScreenLineRight(String.format("Available Video Memory (%sMB) of %sMB", availableVRam / 1024L, totalVRam / 1024L));
                }
                this.drawDebugScreenLineRight("Resolution: " + this.mc.gameWindow.getWidthPixels() + "x" + this.mc.gameWindow.getHeightPixels());
                this.drawDebugScreenLineRight("Render Resolution: " + this.mc.renderer.getRenderWidth() + "x" + this.mc.renderer.getRenderHeight());
                this.drawDebugScreenLine("Better than Adventure! " + Minecraft.VERSION);
                this.drawDebugScreenLine(this.mc.lineDebug);
                TerrainRenderer terrainRenderer = this.mc.terrainRenderer;
                if (terrainRenderer instanceof TerrainRendererMultiDraw) {
                    TerrainRendererMultiDraw terrainRenderer2 = (TerrainRendererMultiDraw)terrainRenderer;
                    int regionCount = terrainRenderer2.regionBuffer.size();
                    int playerX = MathHelper.floor(this.mc.thePlayer.x);
                    int playerZ = MathHelper.floor(this.mc.thePlayer.z);
                    List<RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig>> allRegions = terrainRenderer2.regionBuffer.getAllRegions();
                    int totalEntries = 0;
                    int visibleEntries = 0;
                    for (int i = 0; i < allRegions.size(); ++i) {
                        RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> region = allRegions.get(i);
                        for (int j = 0; j < region.renderLists.length; ++j) {
                            RenderList renderList = region.renderLists[j];
                            if (renderList == null) continue;
                            totalEntries += renderList.size();
                            visibleEntries += renderList.visibleEntryCount();
                        }
                    }
                    this.drawDebugScreenLine("R: " + regionCount + " D: " + terrainRenderer2.getTotalDrawCalls() + " T: " + visibleEntries + "/" + totalEntries + " VBO: " + terrainRenderer2.vertexBuffer.entryCount());
                    RenderRegion<TessellatorTerrainImpl.TerrainVertexConfig> currentRegion = terrainRenderer2.getRenderRegionAtBlockPos(playerX, playerZ);
                    totalEntries = 0;
                    visibleEntries = 0;
                    for (int j = 0; j < currentRegion.renderLists.length; ++j) {
                        RenderList renderList = currentRegion.renderLists[j];
                        if (renderList == null) continue;
                        totalEntries += renderList.size();
                        visibleEntries += renderList.visibleEntryCount();
                    }
                    this.drawDebugScreenLine("CR: " + String.valueOf(currentRegion) + " E: " + visibleEntries + "/" + totalEntries);
                } else {
                    this.drawDebugScreenLine(this.mc.getRendererDebugInfo());
                }
                this.drawDebugScreenLine(this.mc.getEntityDebugInfoString());
                this.drawDebugScreenLine(this.mc.getEntityCountsInfoString());
                this.drawDebugScreenLine(this.mc.getChunkProviderInfoString());
                this.debugOffset += space;
                this.debugOffsetRight += space;
                if (compass) {
                    this.drawDebugScreenLine("X: " + this.mc.thePlayer.x);
                    this.drawDebugScreenLine("Y: " + this.mc.thePlayer.y);
                    this.drawDebugScreenLine("Z: " + this.mc.thePlayer.z);
                    int chunkX = MathHelper.floor(this.mc.thePlayer.x) >> 4;
                    int chunkZ = MathHelper.floor(this.mc.thePlayer.z) >> 4;
                    this.drawDebugScreenLine("Chunk: " + chunkX + ", " + chunkZ);
                    int yaw = DynamicTexture.pmod(Math.round(this.mc.thePlayer.yRot), 360);
                    int pitch = Math.round(this.mc.thePlayer.xRot);
                    this.drawDebugScreenLine("Facing: " + yaw + "\u00b0, " + pitch + "\u00b0 (" + I18n.getInstance().translateKey(HudIngame.getFacingDirection(this.mc.thePlayer).getTranslationKey()) + ")");
                } else {
                    this.drawDebugScreenLine("Hold a compass for more information");
                }
                if (clock) {
                    if (!compass) {
                        this.debugOffset += space;
                    }
                    int playerX = MathHelper.floor(this.mc.thePlayer.x);
                    int playerY = MathHelper.floor(this.mc.thePlayer.y);
                    int playerZ = MathHelper.floor(this.mc.thePlayer.z);
                    this.drawDebugScreenLine("Light: Sky: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Sky, playerX, playerY, playerZ) + " Block: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Block, playerX, playerY, playerZ));
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Entities: " + this.mc.currentWorld.getLoadedEntityList().size());
                this.drawDebugScreenLine("Tile Entities: " + this.mc.currentWorld.getLoadedTileEntityList().size());
                this.debugOffset += space;
                if (clock) {
                    this.drawDebugScreenLine("Time: " + HudIngame.getTimeString(this.mc) + " (Day " + this.mc.currentWorld.getWorldTime() / 24000L + ")");
                } else {
                    this.drawDebugScreenLine("Hold a clock for more information");
                }
                this.debugOffset += space;
                if (rotaryCalendar) {
                    Season season = this.mc.currentWorld.getSeasonManager().getCurrentSeason();
                    String seasonString = season != null ? season.getTranslatedName() : "None";
                    Weather weather = this.mc.currentWorld.getCurrentWeather();
                    String weatherString = weather != null ? stringtranslate.translateKey(weather.getNameLanguageKey()) : "None";
                    int blockX = MathHelper.floor(this.mc.thePlayer.x);
                    int blockY = MathHelper.floor(this.mc.thePlayer.y);
                    int blockZ = MathHelper.floor(this.mc.thePlayer.z);
                    this.drawDebugScreenLine("Season: " + seasonString);
                    this.drawDebugScreenLine("Weather: " + weatherString + " (" + this.mc.currentWorld.weatherManager.getWeatherDuration() / 20L + "s I: " + Utils.percentRound(this.mc.currentWorld.weatherManager.getWeatherIntensity()) + "% P: " + Utils.percentRound(this.mc.currentWorld.weatherManager.getWeatherPower()) + "%)");
                    this.drawDebugScreenLine("Biome: " + Registries.BIOMES.getKey(this.mc.currentWorld.getBlockBiome(blockX, blockY, blockZ)));
                    float temperature = (float)Utils.floor100(this.mc.currentWorld.getBlockTemperature(blockX, blockZ));
                    float humidity = (float)Utils.floor100(this.mc.currentWorld.getBlockHumidity(blockX, blockZ));
                    this.drawDebugScreenLine("Temperature: " + temperature + " Humidity: " + humidity);
                    WindProvider windProvider = this.mc.currentWorld.worldType.getWindManager();
                    if (windProvider != null) {
                        float direction = (float)Utils.floor100(windProvider.getWindDirection(this.mc.currentWorld, 0.0f, 500.0f, 0.0f));
                        float intensity = (float)Utils.floor100(windProvider.getWindIntensity(this.mc.currentWorld, 0.0f, 500.0f, 0.0f));
                        int yaw = DynamicTexture.pmod(Math.round(direction * 360.0f + 270.0f), 360);
                        this.drawDebugScreenLine("Wind: " + yaw + "\u00b0, " + Math.round(intensity * 100.0f) + "%");
                    }
                } else {
                    this.drawDebugScreenLine("Hold a rotary calendar for more information");
                }
                this.debugOffset += space;
                this.drawDebugScreenLine("Seed: " + this.mc.currentWorld.getRandomSeed());
                this.debugOffset += space;
                this.drawDebugScreenLine("CTRL + F3: Show Frametimes");
                this.drawDebugScreenLine("F3 + Q: Show Keyboard Shortcuts");
                HitResult seasonString = this.mc.objectMouseOver;
                if (seasonString instanceof HitResult.Tile) {
                    String name;
                    HitResult.Tile hitTile = (HitResult.Tile)seasonString;
                    this.debugOffset += space;
                    Block<?> block = this.mc.currentWorld.getBlockType(hitTile.tilePos);
                    this.drawDebugScreenLineRight("Looking at:");
                    int meta = this.mc.currentWorld.getBlockData(hitTile.tilePos);
                    try {
                        name = new ItemStack(block, 1, meta).getDisplayName();
                    }
                    catch (Exception e) {
                        name = "<ERROR>";
                    }
                    String id = String.valueOf(block.namespaceId()) + " [" + block.id() + ":" + meta + "]";
                    this.drawDebugScreenLineRight(name);
                    this.drawDebugScreenLineRight(block.getLanguageKey(meta));
                    this.drawDebugScreenLineRight(id);
                    if (compass) {
                        this.drawDebugScreenLineRight("[" + hitTile.tilePos.x() + ", " + hitTile.tilePos.y() + ", " + hitTile.tilePos.z() + "]");
                    }
                    this.drawDebugScreenLineRight("Harvest: " + this.mc.thePlayer.canHarvestBlock(block));
                    if (clock) {
                        int lightX = hitTile.tilePos.x();
                        int lightY = hitTile.tilePos.y();
                        int lightZ = hitTile.tilePos.z();
                        Side side = hitTile.side;
                        this.drawDebugScreenLineRight("Light: Sky: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Sky, lightX += side.getOffsetX(), lightY += side.getOffsetY(), lightZ += side.getOffsetZ()) + " Block: " + this.mc.currentWorld.getSavedLightValue(LightLayer.Block, lightX, lightY, lightZ));
                    }
                    this.drawDebugScreenLineRight("Signal: " + this.mc.currentWorld.hasSignal(hitTile.tilePos, hitTile.side));
                    this.drawDebugScreenLineRight("Direct signal: " + this.mc.currentWorld.hasDirectSignal(hitTile.tilePos, hitTile.side));
                    for (Tag<Block<?>> tag : BlockTags.TAG_LIST) {
                        if (!tag.appliesTo(block)) continue;
                        this.drawDebugScreenLineRight(tag.getName());
                    }
                }
                GLRenderer.popFrame();
            }
        }
        if (GameSettings.IMMERSIVE_MODE.drawChat()) {
            this.drawChat(width, height, sp);
        }
        if (GameSettings.KEY_TOGGLE_TEXTURE_ATLAS.isPressed()) {
            GLRenderer.pushFrame();
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            TessellatorShader tessellator = GLRenderer.getTessellator();
            TextureRegistry.worldAtlas.bind();
            int blockW = TextureRegistry.worldAtlas.getAtlasWidth();
            int blockH = TextureRegistry.worldAtlas.getAtlasHeight();
            float scaleBlock = (float)(width - 40) / (float)blockW;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(20.0, 20.0f + (float)blockH * scaleBlock, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(20.0f + (float)blockW * scaleBlock, 20.0f + (float)blockH * scaleBlock, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(20.0f + (float)blockW * scaleBlock, 20.0, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(20.0, 20.0, 0.0, 0.0, 0.0);
            tessellator.draw();
            int blockEndX = (int)(20.0f + (float)blockW * scaleBlock + 10.0f);
            GLRenderer.popFrame();
        }
    }

    private void drawDebugScreenLine(CharSequence string, boolean right, int line, int offset) {
        int width = MathHelper.ceil(this.fontRenderer.stringWidthDouble(string));
        int height = this.debugLineHeight;
        int x = right ? (int)((float)this.mc.resolution.getScaledWidthScreenCoords() / 1.0f - (float)width - 2.0f) : 2;
        int y = 3 + line * this.debugLineHeight + offset;
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        GLRenderer.setColor4f(0.2f, 0.2f, 0.2f, 0.6f);
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.drawRectangle(x - 1, y - 1, width + 2, height);
        t.draw();
        GLRenderer.popFrame();
        this.drawStringNoShadow(this.fontRenderer, string, x, y, 0xFFFFFF);
    }

    private void drawDebugScreenLine(CharSequence string) {
        this.drawDebugScreenLine(string, false, this.debugLine++, this.debugOffset);
    }

    private void drawDebugScreenLineRight(CharSequence string) {
        this.drawDebugScreenLine(string, true, this.debugLineRight++, this.debugOffsetRight);
    }

    public void drawPlayerList(int screenWidth, int screenHeight, int screenPadding) {
        if (!this.mc.isMultiplayerWorld()) {
            return;
        }
        if ((Integer)GameSettings.PLAYER_LIST_POSITION.value == 1) {
            GameSettings.SHOW_PLAYER_LIST.value = GameSettings.KEY_PLAYER_LIST.isPressed() && this.mc.currentScreen == null;
        }
        if (!((Boolean)GameSettings.SHOW_PLAYER_LIST.value).booleanValue()) {
            return;
        }
        PlayerLocal playerLocal = this.mc.thePlayer;
        if (!(playerLocal instanceof PlayerLocalMultiplayer)) {
            return;
        }
        PlayerLocalMultiplayer player = (PlayerLocalMultiplayer)playerLocal;
        HashMap<String, String> players = player.sendQueue.playerList;
        int longestNameWidth = 0;
        int longestScoreWidth = 0;
        this.playerListScoreStrings.clear();
        for (Map.Entry<String, String> a1 : players.entrySet()) {
            longestNameWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(a1.getKey())), longestNameWidth);
            longestScoreWidth = Math.max(MathHelper.ceil(this.fontRenderer.stringWidthDouble(a1.getValue())), longestScoreWidth);
            this.playerListScoreStrings.add(a1.getValue());
        }
        int nameScoreSpace = 4;
        int lineHeight = 8;
        int outerPadding = 12;
        int innerPadding = 8;
        int columnWidth = longestNameWidth + longestScoreWidth + 4;
        int columns = (int)Math.ceil((float)players.size() / 8.0f);
        int rows = (int)Math.ceil((float)players.size() / (float)columns) + 1;
        int width = columns * columnWidth + 8 * (columns - 1) + 24;
        int height = rows * 8 + 8 * (rows - 1) + 2 + 12 - 8 + 2;
        int listX = 0;
        int listY = screenPadding;
        if ((Integer)GameSettings.PLAYER_LIST_POSITION.value == 0) {
            listX = (screenWidth - width) / 2;
        }
        if ((Integer)GameSettings.PLAYER_LIST_POSITION.value == 1) {
            listX = (screenWidth - width) / 2;
            listY = screenHeight / 6 + screenPadding;
        }
        if ((Integer)GameSettings.PLAYER_LIST_POSITION.value == 2) {
            listX = screenWidth - width - screenPadding;
        }
        this.drawRect(listX, listY, listX + width, listY + height, -1475868664);
        int i = 0;
        for (Map.Entry<String, String> a2 : players.entrySet()) {
            int x = i % columns;
            int y = i / columns;
            int posX = listX + x * columnWidth + x * 8 + 12;
            int posY = listY + y * 8 + y * 8 + 12;
            int scoreStringWidth = MathHelper.ceil(this.fontRenderer.stringWidthDouble(a2.getValue()));
            this.drawRect(posX - 2, posY - 2, posX + columnWidth + 2, posY + 10, -5921371);
            this.drawRect(posX - 1, posY - 1, posX + columnWidth + 1, posY + 9, -1475868664);
            this.drawStringShadow(this.fontRenderer, a2.getKey(), posX, posY, 0xFFFFFF);
            this.drawStringShadow(this.fontRenderer, String.valueOf(TextFormatting.YELLOW) + a2.getValue(), posX + columnWidth - scoreStringWidth, posY, 0xFFFFFF);
            ++i;
        }
    }

    public void drawRecordPlayingOverlay(int width, int height, float partialTicks) {
        if (this.recordPlayingUpFor > 0) {
            float f2 = (float)this.recordPlayingUpFor - partialTicks;
            int j3 = (int)(f2 * 256.0f / 20.0f);
            if (j3 > 255) {
                j3 = 255;
            }
            if (j3 > 0) {
                GLRenderer.pushFrame();
                GLRenderer.modelM4f().translate((float)width / 2.0f, height - 48, 0.0f);
                GLRenderer.enableState(State.BLEND);
                GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                int k4 = 0xFFFFFF;
                if (this.colorString) {
                    k4 = Color.HSBtoRGB(f2 / 50.0f, 0.7f, 0.6f) & 0xFFFFFF;
                }
                this.drawStringNoShadow(this.fontRenderer, this.recordPlaying, MathHelper.ceil(-this.fontRenderer.stringWidthDouble(this.recordPlaying) / 2.0), -4, k4 + (j3 << 24));
                GLRenderer.disableState(State.BLEND);
                GLRenderer.popFrame();
            }
        }
    }

    public void drawChat(int width, int height, int sp) {
        if (GameSettings.chatVisibility.value == ChatVisibility.NEVER_SHOW) {
            return;
        }
        int linesToShow = 10;
        boolean ignoreFadeout = false;
        if (this.mc.currentScreen instanceof ScreenChat) {
            int acceptableSize = height - 48 - 48;
            linesToShow = acceptableSize / 9;
            ignoreFadeout = true;
        } else if (GameSettings.chatVisibility.value == ChatVisibility.SHOW_WHEN_CHATTING) {
            return;
        }
        if (this.chatScroll > this.chatMessageList.size() - linesToShow) {
            this.chatScroll = this.chatMessageList.size() - linesToShow;
        }
        if (this.chatScroll < 0) {
            this.chatScroll = 0;
        }
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(0.0f, height - 48, 0.0f);
        int y = -12;
        for (int i = 0; i < linesToShow; ++i) {
            if (this.chatScroll + i >= this.chatMessageList.size()) continue;
            ChatLine line = this.chatMessageList.get(this.chatScroll + i);
            if (line.updateCounter >= 190 && !ignoreFadeout) continue;
            double fadeAmount = (double)line.updateCounter / 200.0;
            fadeAmount = 1.0 - fadeAmount;
            if ((fadeAmount *= 10.0) < 0.0) {
                fadeAmount = 0.0;
            }
            if (fadeAmount > 1.0) {
                fadeAmount = 1.0;
            }
            fadeAmount *= fadeAmount;
            int alpha = (int)(255.0 * fadeAmount);
            if (ignoreFadeout) {
                alpha = 255;
            }
            if (alpha <= 0) continue;
            CharSequence message = line.message;
            int xPad = 2;
            int h = MathHelper.ceil(this.fontRenderer.heightOfConstrainedChars(message, 320.0));
            this.drawRect(2 + sp, (y -= h + 2) - sp - 1, 322, y + h - sp + 1, alpha / 2 << 24);
            GLRenderer.enableState(State.BLEND);
            this.fontRenderer.renderWidthConstrained(message, 2 + sp, y - sp, 320).setShadow().setColor(0xFFFFFF + (alpha << 24)).call();
        }
        GLRenderer.popFrame();
        GLRenderer.disableState(State.BLEND);
    }

    public static String getTimeString(Minecraft mc) {
        long worldTime = mc.currentWorld.getWorldTime();
        int dayLength = 24000;
        int dayTime = (int)(worldTime % (long)dayLength);
        int hourLength = dayLength / 24;
        int hour = dayTime / hourLength;
        hour = (hour + 6) % 24;
        double hp = (double)(dayTime % hourLength) / (double)hourLength;
        int minute = (int)(hp * 60.0);
        return hour + ":" + HudIngame.addZero(minute);
    }

    public static String addZero(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return String.valueOf(i);
    }

    protected void renderPumpkinBlur(int xSize, int ySize) {
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.setDepthMask(false);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/pumpkinblur.png").bind();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void renderVignette(float intensity, int xSize, int ySize) {
        intensity = MathHelper.clamp(1.0f - intensity, 0.0f, 1.0f);
        this.prevVignetteBrightness = (float)((double)this.prevVignetteBrightness + (double)(intensity - this.prevVignetteBrightness) * 0.01);
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.setDepthMask(false);
        GLRenderer.setBlendFunc(BlendFactor.ZERO, BlendFactor.ONE_MINUS_SRC_COLOR);
        GLRenderer.setColor4f(this.prevVignetteBrightness, this.prevVignetteBrightness, this.prevVignetteBrightness, 1.0f);
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/misc/vignette.png").bind();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, 0.0, 1.0);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, 1.0, 1.0);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
    }

    protected void renderPortalOverlay(float intensity, int xSize, int ySize) {
        if (intensity < 1.0f) {
            intensity *= intensity;
            intensity *= intensity;
            intensity = intensity * 0.8f + 0.2f;
        }
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.setDepthMask(false);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, intensity);
        IconCoordinate portal = ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.getBlock(this.mc.thePlayer.portalID))).getOverlayTexture(this.mc.thePlayer.portalColor.blockMeta << 4 | 8);
        portal.parentAtlas.bind();
        float f1 = (float)portal.getIconUMin();
        float f2 = (float)portal.getIconVMin();
        float f3 = (float)portal.getIconUMax();
        float f4 = (float)portal.getIconVMax();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, ySize, -90.0, f1, f4);
        tessellator.addVertexWithUV(xSize, ySize, -90.0, f3, f4);
        tessellator.addVertexWithUV(xSize, 0.0, -90.0, f3, f2);
        tessellator.addVertexWithUV(0.0, 0.0, -90.0, f1, f2);
        tessellator.draw();
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.DEPTH_TEST);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void updateTick() {
        if (this.recordPlayingUpFor > 0) {
            --this.recordPlayingUpFor;
        }
        ++this.updateCounter;
        for (ChatLine chatLine : this.chatMessageList) {
            ++chatLine.updateCounter;
        }
    }

    public void clearChatMessages() {
        this.chatMessageList.clear();
    }

    public void addChatMessage(CharSequence s) {
        LOGGER.info("[CHAT] {}", (Object)s);
        this.chatMessageList.add(0, new ChatLine(s));
        while (this.chatMessageList.size() > 100) {
            this.chatMessageList.remove(this.chatMessageList.size() - 1);
        }
    }

    public void setRecordPlayingMessage(String s) {
        this.recordPlaying = I18n.getInstance().translateKeyAndFormat("gui.ingame.label.now_playing", s);
        this.recordPlayingUpFor = 60;
        this.colorString = true;
    }

    public static Direction getFacingDirection(Player player) {
        return directions[MathHelper.floor((double)(player.yRot * 4.0f / 360.0f) + 0.5) + 2 & 3];
    }
}

