/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.SwitchElement;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntryMobSpawningComponent
extends ButtonComponent {
    @NotNull
    private final EntityDispatcher.EntityDispatcherEntry<?> entry;
    @Nullable
    private WorldConfiguration worldConfiguration = null;
    @NotNull
    private final SwitchElement button;

    public EntryMobSpawningComponent(@NotNull EntityDispatcher.EntityDispatcherEntry<?> entry) {
        super(Objects.requireNonNullElse(entry.nameKey, entry.namespaceID.toString()), null);
        this.entry = entry;
        this.button = new SwitchElement(0, 0, 0, 150, 20, true, I18n.getInstance().translateKey("gui.world_settings.page.mob_spawning.button.on"), I18n.getInstance().translateKey("gui.world_settings.page.mob_spawning.button.off"));
        this.button.setOn(true);
    }

    public void setSpawnConfiguration(@NotNull WorldConfiguration worldConfiguration) {
        this.worldConfiguration = worldConfiguration;
    }

    @Override
    public void resetValue() {
        this.worldConfiguration.getSpawnerConfig().setMobSpawn(this.entry.namespaceID, true);
        this.onChange();
    }

    @Override
    public void init(Minecraft mc) {
        this.onChange();
    }

    @Override
    public boolean isDefault() {
        return this.button.isOn();
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        this.worldConfiguration.getSpawnerConfig().setMobSpawn(this.entry.namespaceID, this.worldConfiguration.getSpawnerConfig().canMobSpawn(this.entry.namespaceID));
        this.onChange();
    }

    protected void onChange() {
        this.button.setOn(this.worldConfiguration.getSpawnerConfig().canMobSpawn(this.entry.namespaceID));
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (EntryMobSpawningComponent.mc.currentScreen != null && relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            EntryMobSpawningComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }
}

