/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.worldsettings;

import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.worldsettings.ButtonComponent;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.settings.WorldConfiguration;
import net.minecraft.core.world.type.WorldTypeGroups;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartingBiomeButtonComponent
extends ButtonComponent {
    @Nullable
    private WorldConfiguration worldConfiguration = null;
    @NotNull
    private final ButtonElement button = new ButtonElement(0, 0, 0, 150, 20, "");
    @Nullable
    private WorldTypeGroups.Group lastGroup = null;

    public StartingBiomeButtonComponent(@NotNull String translationKey, @Nullable String tooltipTranslationKey) {
        super(translationKey, tooltipTranslationKey);
    }

    public void setWorldConfiguration(@NotNull WorldConfiguration worldConfiguration) {
        this.worldConfiguration = worldConfiguration;
        Biome biome = this.worldConfiguration.getStartingBiome();
        this.button.displayString = I18n.getInstance().translateKey(biome == null ? "gui.world_settings.page.starting_biome.biome.none" : biome.translationKey);
    }

    @Override
    public void resetValue() {
        Objects.requireNonNull(this.worldConfiguration).setStartingBiome(null);
        Biome biome = this.worldConfiguration.getStartingBiome();
        this.button.displayString = I18n.getInstance().translateKey(biome == null ? "gui.world_settings.page.starting_biome.biome.none" : biome.translationKey);
    }

    @Override
    public boolean isDefault() {
        return Objects.requireNonNull(this.worldConfiguration).getStartingBiome() == null;
    }

    @Override
    protected void buttonClicked(int mouseButton, int x, int y, int width, int height, int relativeMouseX, int relativeMouseY) {
        I18n i18n = I18n.getInstance();
        Biome[] biomes = this.worldConfiguration.getWorldTypeGroup().get(Dimension.OVERWORLD).allBiomes();
        @NotNull String @NotNull [] keys2 = new String[biomes.length + 1];
        for (int i = 0; i < keys2.length; ++i) {
            int selected = i - 1;
            Biome biome = selected >= 0 ? biomes[selected] : null;
            keys2[i] = i18n.translateKey(biome == null ? "gui.world_settings.page.starting_biome.biome.none" : biome.translationKey);
        }
        int b = 0;
        if (this.worldConfiguration.getStartingBiome() == null) {
            b = 0;
        } else {
            for (int i = 0; i < biomes.length; ++i) {
                if (biomes[i] != this.worldConfiguration.getStartingBiome()) continue;
                b = i + 1;
                break;
            }
        }
        PopupScreen popup = new PopupBuilder(Objects.requireNonNull(StartingBiomeButtonComponent.mc.currentScreen), 150).closeOnEsc(0).closeOnClickOut(0).withLabel("gui.world_settings.label.starting_biome").withList("biomeList", 140, keys2, null, b, true).withOnCloseListener((statusCode, results) -> {
            if (statusCode == 1) {
                int selected = (Integer)results.get("biomeList") - 1;
                Biome biome = selected >= 0 ? biomes[selected] : null;
                this.worldConfiguration.setStartingBiome(biome);
                this.button.displayString = I18n.getInstance().translateKey(biome == null ? "gui.world_settings.page.starting_biome.biome.none" : biome.translationKey);
            }
        }).build();
        mc.displayScreen(popup);
    }

    @Override
    protected void renderButton(int x, int y, int relativeButtonX, int relativeButtonY, int buttonWidth, int buttonHeight, int relativeMouseX, int relativeMouseY) {
        if (this.worldConfiguration.getWorldTypeGroup() != this.lastGroup) {
            this.lastGroup = this.worldConfiguration.getWorldTypeGroup();
            this.resetValue();
        }
        super.renderButton(x, y, relativeButtonX, relativeButtonY, buttonWidth, buttonHeight, relativeMouseX, relativeMouseY);
        this.button.xPosition = x + relativeButtonX;
        this.button.yPosition = y + relativeButtonY;
        this.button.width = buttonWidth;
        this.button.height = buttonHeight;
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
        if (StartingBiomeButtonComponent.mc.currentScreen != null && relativeMouseX >= relativeButtonX && relativeMouseX < relativeButtonX + buttonWidth && relativeMouseY >= relativeButtonY && relativeButtonY < relativeButtonY + buttonHeight) {
            StartingBiomeButtonComponent.mc.currentScreen.setDesiredCursor(CursorShape.HAND);
        }
    }
}

