/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CompareFunc;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.entity.AgedMob;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.primitives.AABBdc;
import org.slf4j.Logger;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public abstract class MobRenderer<T extends Mob>
extends EntityRenderer<T> {
    public static final float ENTITY_RENDER_SCALE = 16.0f;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final @NotNull List<@Nullable StaticEntityModel> setupModels = new ArrayList<StaticEntityModel>();

    public MobRenderer(float shadowSize) {
        super(shadowSize);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        boolean hasOverlayAlpha;
        this.loadEntityTexture(entity);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.enableState(State.BLEND);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.pushFrame();
        this.preRenderTransform(entity, x, y, z, yaw, partialTick);
        this.setupModels.clear();
        int maxRenderLayer = this.maxRenderLayer(entity);
        for (int layer = 0; layer <= maxRenderLayer; ++layer) {
            try {
                GLRenderer.pushFrame();
                StaticEntityModel model = this.getAndSetupModelForLayer(entity, 1.0f, partialTick, layer);
                this.setupModels.add(model);
                if (model != null) {
                    model.render();
                }
                GLRenderer.popFrame();
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error setting up model on layer '{}' in renderer '{}'", layer, this.getClass().getSimpleName(), e);
            }
        }
        this.renderAdditional(tessellator, entity, partialTick);
        int argb = this.getOverlayColor(entity, partialTick);
        boolean bl = hasOverlayAlpha = Color.alphaFromInt(argb) > 0;
        if (hasOverlayAlpha || ((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
            StaticEntityModel model;
            int layer;
            this.renderDispatcher.textureManager.loadTexture("/assets/minecraft/textures/misc/white.png").bind();
            GLRenderer.pushFrame();
            GLRenderer.setLightmapCoord2i(15, 15);
            GLRenderer.setShader(Shaders.COLOR_WORLD);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.setDepthFunc(CompareFunc.EQUAL);
            if (((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
                for (layer = 0; layer <= maxRenderLayer; ++layer) {
                    model = this.setupModels.get(layer);
                    if (model == null) continue;
                    GLRenderer.setColor4f(1.0f, 0.0f, 0.0f, 0.4f);
                    model.render();
                }
            }
            if (hasOverlayAlpha) {
                for (layer = 0; layer <= maxRenderLayer; ++layer) {
                    model = this.setupModels.get(layer);
                    if (model == null) continue;
                    GLRenderer.setColor1i(argb);
                    model.render();
                }
            }
            GLRenderer.setDepthFunc(CompareFunc.LESS_EQUAL);
            GLRenderer.disableState(State.BLEND);
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
        GLRenderer.enableState(State.CULL_FACE);
        GLRenderer.disableState(State.BLEND);
        this.renderSpecials(tessellator, entity, x, y, z);
    }

    protected void preRenderTransform(@NotNull T entity, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        GLRenderer.modelM4f().rotateY(-this.getBodyYaw(entity, partialTick));
        GLRenderer.modelM4f().scale(0.0625f, 0.0625f, -0.0625f);
        if (((Mob)entity).deathTime > 0) {
            float rotationProgress = ((float)((Mob)entity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GLRenderer.modelM4f().rotateZ(Math.toRadians(rotationProgress * this.getMaxDeathRotation(entity)));
        }
        if (entity instanceof AgedMob) {
            AgedMob agedMob = (AgedMob)entity;
            float ageScale = agedMob.getMobAge().getAgeScale();
            GLRenderer.modelM4f().scale(ageScale, ageScale, ageScale);
        }
    }

    @Override
    public float getShadowSize(@NotNull T entity) {
        float baseSize = super.getShadowSize(entity);
        if (entity instanceof AgedMob) {
            AgedMob agedMob = (AgedMob)entity;
            float ageScale = agedMob.getMobAge().getAgeScale();
            return baseSize * ageScale;
        }
        return baseSize;
    }

    protected float getLimbSwing(@NotNull T entity, float partialTick) {
        return ((Mob)entity).walkAnimPos - ((Mob)entity).walkAnimSpeed * (1.0f - partialTick);
    }

    protected float getLimbYaw(@NotNull T entity, float partialTick) {
        float limbYaw = MathHelper.lerp(((Mob)entity).walkAnimSpeedO, ((Mob)entity).walkAnimSpeed, partialTick);
        if (limbYaw > 1.0f) {
            limbYaw = 1.0f;
        }
        return limbYaw;
    }

    protected float getLimbPitch(@NotNull T entity, float partialTick) {
        return (float)((Mob)entity).tickCount + partialTick;
    }

    protected float getBodyYaw(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).yBodyRotO, ((Mob)entity).yBodyRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected float getHeadYaw(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).yRotO, ((Mob)entity).yRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected float getHeadPitch(@NotNull T entity, float partialTick) {
        return MathHelper.lerp(((Mob)entity).xRotO, ((Mob)entity).xRot, partialTick) * MathHelper.DEG_TO_RAD;
    }

    protected void renderSpecials(@NotNull TessellatorGeneral tessellator, @NotNull T entity, double x, double y, double z) {
        if (Minecraft.getMinecraft().canRenderEntityLabel()) {
            this.renderLivingLabel(tessellator, entity, Integer.toString(((Mob)entity).id), x, y, z, 64, false);
        } else if (!((Mob)entity).nickname.isEmpty()) {
            this.renderLivingLabel(tessellator, entity, ((Mob)entity).getDisplayName(), x, y, z, 64, true);
        }
    }

    protected void renderLivingLabel(@NotNull TessellatorGeneral t, @NotNull T entity, @NotNull CharSequence text, double x, double y, double z, int maxDistance, boolean depthTest) {
        float cameraDistance = (float)Minecraft.getMinecraft().activeCamera.distanceTo((Entity)entity);
        if (cameraDistance > (float)maxDistance) {
            return;
        }
        FontRenderer sr = this.getFont();
        float scale = 0.026666667f;
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y + ((Mob)entity).getHeadHeight() + 0.8f, (float)z);
        GLRenderer.modelM4f().rotateY(Math.toRadians(-this.renderDispatcher.viewLerpYaw));
        GLRenderer.modelM4f().rotateX(Math.toRadians(this.renderDispatcher.viewLerpPitch));
        GLRenderer.modelM4f().scale(-0.026666667f, -0.026666667f, 0.026666667f);
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.setDepthMask(false);
        if (!depthTest) {
            GLRenderer.disableState(State.DEPTH_TEST);
        }
        GLRenderer.enableState(State.BLEND);
        GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        t.startDrawingQuads();
        int halfTextWidth = sr.stringWidth(text) / 2;
        t.setColor4f(0.0f, 0.0f, 0.0f, 0.25f);
        t.addVertex(-halfTextWidth - 1, -1.0, 0.0);
        t.addVertex(-halfTextWidth - 1, 8.0, 0.0);
        t.addVertex(halfTextWidth, 8.0, 0.0);
        t.addVertex(halfTextWidth, -1.0, 0.0);
        t.draw();
        GLRenderer.popFrame();
        sr.render(text, -halfTextWidth, 0).setColor(0x20FFFFFF).call();
        if (!depthTest) {
            GLRenderer.enableState(State.DEPTH_TEST);
        }
        GLRenderer.setDepthMask(true);
        sr.render(text, -halfTextWidth, 0).setColor(0xFFFFFF).call();
        GLRenderer.globalSetLightEnabled(true);
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
    }

    protected int getOverlayColor(@NotNull T entity, float partialTick) {
        return 0;
    }

    protected float getMaxDeathRotation(@NotNull T entity) {
        return 90.0f;
    }

    protected int maxRenderLayer(@NotNull T entity) {
        return 0;
    }

    @Nullable
    protected abstract StaticEntityModel getAndSetupModelForLayer(@NotNull T var1, float var2, float var3, int var4);

    protected void renderAdditional(@NotNull TessellatorGeneral tessellator, @NotNull T entity, float partialTick) {
    }

    public void loadEntityTexture(@NotNull T entity) {
        if (!((Boolean)GameSettings.MOB_VARIANTS.value).booleanValue()) {
            this.bindTexture(((Mob)entity).getDefaultEntityTexture());
        } else {
            this.bindTexture(((Mob)entity).getEntityTexture());
        }
    }

    @Override
    @NotNull
    public AABBdc entityViewBox(@NotNull T entity) {
        return super.entityViewBox(entity);
    }
}

