/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import java.nio.ByteBuffer;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.terrain.VertexConfig;
import net.minecraft.client.render.terrain.VertexData;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class TessellatorTerrainImpl
implements TessellatorGeneral {
    private final float[] quadPoses = new float[12];
    private final float[] quadUVs = new float[8];
    private final byte[] quadNormals = new byte[12];
    private final byte[] quadLightMap = new byte[4];
    private final byte[] quadShade = new byte[4];
    private final int[] quadColors = new int[4];
    @NotNull
    public final TerrainVertexData data;
    public boolean drawing;
    private int color;
    private byte lightIndex;
    private byte shade = (byte)-1;
    private double textureU;
    private double textureV;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    private boolean lockedColor = false;
    private int quadVertCount = 0;

    public TessellatorTerrainImpl(int bufferSize) {
        this.data = new TerrainVertexData(bufferSize);
    }

    @Override
    public void startDrawing(@NotNull DrawMode drawMode) {
        if (this.drawing) {
            this.drawing = false;
            throw new IllegalStateException("Already drawing!");
        }
        this.drawing = true;
        this.data.vertexCount = 0;
        this.quadVertCount = 0;
        this.setLightmapCoord2i(15, 15);
        this.setColor4i(255, 255, 255, 255);
        this.setTextureUV(0.0, 0.0);
        this.setNormal(0.0f, 1.0f, 0.0f);
        this.lockedColor = false;
        this.data.getBuffer().clear();
    }

    @Override
    public void draw() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RenderBuffer record(int vao, int vbo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        int index = this.quadVertCount % 4;
        this.quadPoses[index * 3] = (float)(this.offsetX + x);
        this.quadPoses[index * 3 + 1] = (float)(this.offsetY + y);
        this.quadPoses[index * 3 + 2] = (float)(this.offsetZ + z);
        this.quadColors[index] = this.color;
        this.quadUVs[index * 2] = (float)this.textureU;
        this.quadUVs[index * 2 + 1] = (float)this.textureV;
        this.quadLightMap[index] = this.lightIndex;
        this.quadShade[index] = this.shade;
        this.quadNormals[index * 3] = this.normalX;
        this.quadNormals[index * 3 + 1] = this.normalY;
        this.quadNormals[index * 3 + 2] = this.normalZ;
        ++this.quadVertCount;
        if (index == 3) {
            this.data.resizeIfNeeded(128);
            ByteBuffer buffer = this.data.getBuffer();
            float spX = this.quadPoses[0];
            float spY = this.quadPoses[1];
            float spZ = this.quadPoses[2];
            byte nX = (byte)((this.quadNormals[0] + this.quadNormals[3] + this.quadNormals[6] + this.quadNormals[9]) / 4);
            byte nY = (byte)((this.quadNormals[1] + this.quadNormals[4] + this.quadNormals[7] + this.quadNormals[10]) / 4);
            byte nZ = (byte)((this.quadNormals[2] + this.quadNormals[5] + this.quadNormals[8] + this.quadNormals[11]) / 4);
            int color = this.quadColors[0];
            buffer.putFloat(spX).putFloat(spY).putFloat(spZ);
            buffer.put((byte)Color.blueFromInt(color)).put((byte)Color.greenFromInt(color)).put((byte)Color.redFromInt(color));
            buffer.put(nX).put(nY).put(nZ);
            buffer.putShort((short)(this.quadUVs[0] * 65535.0f)).putShort((short)(this.quadUVs[1] * 65535.0f));
            buffer.put(this.quadShade[0]).put(this.quadLightMap[0]);
            buffer.putShort(MathHelper.toHalfFloat(this.quadPoses[3] - spX)).putShort(MathHelper.toHalfFloat(this.quadPoses[4] - spY)).putShort(MathHelper.toHalfFloat(this.quadPoses[5] - spZ));
            buffer.putShort((short)(this.quadUVs[2] * 65535.0f)).putShort((short)(this.quadUVs[3] * 65535.0f));
            buffer.put(this.quadShade[1]).put(this.quadLightMap[1]);
            buffer.putShort(MathHelper.toHalfFloat(this.quadPoses[6] - spX)).putShort(MathHelper.toHalfFloat(this.quadPoses[7] - spY)).putShort(MathHelper.toHalfFloat(this.quadPoses[8] - spZ));
            buffer.putShort((short)(this.quadUVs[4] * 65535.0f)).putShort((short)(this.quadUVs[5] * 65535.0f));
            buffer.put(this.quadShade[2]).put(this.quadLightMap[2]);
            buffer.putShort(MathHelper.toHalfFloat(this.quadPoses[9] - spX)).putShort(MathHelper.toHalfFloat(this.quadPoses[10] - spY)).putShort(MathHelper.toHalfFloat(this.quadPoses[11] - spZ));
            buffer.putShort((short)(this.quadUVs[6] * 65535.0f)).putShort((short)(this.quadUVs[7] * 65535.0f));
            buffer.put(this.quadShade[3]).put(this.quadLightMap[3]);
            ++this.data.vertexCount;
        }
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void setLightmapCoord1i(int lightIndex) {
        this.checkIsDrawing();
        this.lightIndex = (byte)lightIndex;
    }

    @Override
    public void setColor1i(int argb) {
        this.checkIsDrawing();
        if (this.lockedColor) {
            return;
        }
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockedColor = true;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(double x, double y, double z) {
        this.offsetX += x;
        this.offsetY += y;
        this.offsetZ += z;
    }

    private void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    private int getUncompressVertexSize() {
        int size = 0;
        size += 12;
        size += 4;
        size += 8;
        ++size;
        return size += 3;
    }

    @Override
    public void setShade1i(int shade) {
        this.checkIsDrawing();
        this.shade = (byte)shade;
    }

    public static class TerrainVertexData
    extends VertexData<TerrainVertexConfig> {
        public TerrainVertexData(int size) {
            super(new TerrainVertexConfig(), size);
        }
    }

    public static class TerrainVertexConfig
    implements VertexConfig<TerrainVertexConfig> {
        @Override
        @NotNull
        public DrawMode drawMode() {
            return DrawMode.POINTS;
        }

        @Override
        public void enable(int vao, int vbo) {
            GL41.glBindVertexArray(vao);
            GL41.glBindBuffer(34962, vbo);
            int vertexSize = this.getVertexSize();
            int offset = 0;
            GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
            GL41.glVertexAttribPointer(1, 3, 5121, true, vertexSize, offset += 12);
            GL41.glVertexAttribPointer(2, 3, 5120, true, vertexSize, offset += 3);
            GL41.glVertexAttribPointer(3, 2, 5123, true, vertexSize, offset += 3);
            GL41.glVertexAttribPointer(4, 2, 5121, false, vertexSize, offset += 4);
            GL41.glVertexAttribPointer(5, 3, 5131, false, vertexSize, offset += 2);
            GL41.glVertexAttribPointer(6, 2, 5123, true, vertexSize, offset += 6);
            GL41.glVertexAttribPointer(7, 2, 5121, false, vertexSize, offset += 4);
            GL41.glVertexAttribPointer(8, 3, 5131, false, vertexSize, offset += 2);
            GL41.glVertexAttribPointer(9, 2, 5123, true, vertexSize, offset += 6);
            GL41.glVertexAttribPointer(10, 2, 5121, false, vertexSize, offset += 4);
            GL41.glVertexAttribPointer(11, 3, 5131, false, vertexSize, offset += 2);
            GL41.glVertexAttribPointer(12, 2, 5123, true, vertexSize, offset += 6);
            GL41.glVertexAttribPointer(13, 2, 5121, false, vertexSize, offset += 4);
            assert ((offset += 2) == vertexSize);
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glEnableVertexAttribArray(2);
            GL41.glEnableVertexAttribArray(3);
            GL41.glEnableVertexAttribArray(4);
            GL41.glEnableVertexAttribArray(5);
            GL41.glEnableVertexAttribArray(6);
            GL41.glEnableVertexAttribArray(7);
            GL41.glEnableVertexAttribArray(8);
            GL41.glEnableVertexAttribArray(9);
            GL41.glEnableVertexAttribArray(10);
            GL41.glEnableVertexAttribArray(11);
            GL41.glEnableVertexAttribArray(12);
            GL41.glEnableVertexAttribArray(13);
        }

        @Override
        public void disable() {
            GL41.glDisableVertexAttribArray(0);
            GL41.glDisableVertexAttribArray(1);
            GL41.glDisableVertexAttribArray(2);
            GL41.glDisableVertexAttribArray(3);
            GL41.glDisableVertexAttribArray(4);
            GL41.glDisableVertexAttribArray(5);
            GL41.glDisableVertexAttribArray(6);
            GL41.glDisableVertexAttribArray(7);
            GL41.glDisableVertexAttribArray(8);
            GL41.glDisableVertexAttribArray(9);
            GL41.glDisableVertexAttribArray(10);
            GL41.glDisableVertexAttribArray(11);
            GL41.glDisableVertexAttribArray(12);
            GL41.glDisableVertexAttribArray(13);
            GL41.glBindBuffer(34962, 0);
            GL41.glBindVertexArray(0);
        }

        @Override
        public int getVertexSize() {
            int size = 0;
            size += 12;
            size += 3;
            size += 3;
            size += 4;
            size += 2;
            size += 6;
            size += 4;
            size += 2;
            size += 6;
            size += 4;
            size += 2;
            size += 6;
            size += 4;
            return size += 2;
        }

        @Override
        @NotNull
        public TerrainVertexConfig copy() {
            return this;
        }

        public boolean equals(Object obj) {
            return obj instanceof TerrainVertexConfig;
        }
    }
}

