/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.render.texture.meta.TextureProperties;
import net.minecraft.client.util.helper.Buffer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class Texture {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean debugMipmap = false;
    protected static final boolean fixArtifacts = true;
    protected int id;

    public void init() {
    }

    public boolean hasMeta(String key) {
        return false;
    }

    @Nullable
    public <T> T getMeta(String key, Class<T> aClass) {
        return null;
    }

    public <T> T getOrDefaultMeta(String key, T metaDefault, Class<T> aClass) {
        return metaDefault;
    }

    public boolean generate() {
        if (this.isGenerated()) {
            return false;
        }
        this.id = GLAllocation.generateTexture();
        if (!this.isGenerated()) {
            throw new RuntimeException("Texture not created!");
        }
        return true;
    }

    public boolean delete() {
        if (!this.isGenerated()) {
            return false;
        }
        GLAllocation.deleteTexture(this.id);
        this.id = 0;
        return true;
    }

    public boolean bind() {
        if (!this.isGenerated()) {
            return false;
        }
        GL41.glBindTexture(3553, this.id);
        return true;
    }

    public void unbind() {
        GL41.glBindTexture(3553, 0);
    }

    public boolean isGenerated() {
        return this.id != 0;
    }

    public int getWidth() {
        return GL41.glGetTexLevelParameteri(3553, 0, 4096);
    }

    public int getHeight() {
        return GL41.glGetTexLevelParameteri(3553, 0, 4097);
    }

    public int id() {
        return this.id;
    }

    public void setupTexture(BufferedImage image) {
        boolean blurTexture = false;
        boolean clampTexture = false;
        boolean mipmap = false;
        if (this.hasMeta("texture")) {
            TextureProperties properties = this.getMeta("texture", TextureProperties.class);
            blurTexture = properties.blur;
            clampTexture = properties.clamp;
            mipmap = properties.mipmap;
        }
        this.setupTexture(image, blurTexture, clampTexture, mipmap);
    }

    public void setupTexture(BufferedImage img, boolean blurTexture, boolean clampTexture, boolean mipmap) {
        this.bind();
        if (blurTexture) {
            GL41.glTexParameteri(3553, 10241, 9729);
            GL41.glTexParameteri(3553, 10240, 9729);
        } else {
            GL41.glTexParameteri(3553, 10241, 9728);
            GL41.glTexParameteri(3553, 10240, 9728);
        }
        if (clampTexture) {
            GL41.glTexParameteri(3553, 10242, 33071);
            GL41.glTexParameteri(3553, 10243, 33071);
        } else {
            GL41.glTexParameteri(3553, 10242, 10497);
            GL41.glTexParameteri(3553, 10243, 10497);
        }
        int w = img.getWidth();
        int h = img.getHeight();
        Buffer.put(img);
        GL41.glTexImage2D(3553, 0, 6408, w, h, 0, 6408, 5121, Buffer.buffer);
        if (mipmap) {
            this.generateMipmaps(Buffer.buffer, img, (Integer)GameSettings.MIPMAP_LEVELS.value, GameSettings.MIPMAP_TYPE.value == MipmapType.SMOOTH);
        }
    }

    protected void generateMipmaps(ByteBuffer buffer, BufferedImage image, int levels, boolean smooth) {
        LOGGER.info("Generating Mipmaps...");
        int width = image.getWidth();
        int height = image.getHeight();
        int[] data = new int[width * height];
        int[] newData = null;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                data[width * y + x] = image.getRGB(x, y);
            }
        }
        for (int level = levels; level > 0; --level) {
            int lod = (int)Math.pow(2.0, level);
            int tilesX = width / lod;
            int tilesY = height / lod;
            for (int x = 0; x < tilesX; ++x) {
                for (int y = 0; y < tilesY; ++y) {
                    int color;
                    int x0;
                    int y0;
                    int j;
                    int i;
                    Integer nonTransparentColor = null;
                    block5: for (i = 0; i < lod; ++i) {
                        for (j = 0; j < lod; ++j) {
                            y0 = y * lod + j;
                            x0 = x * lod + i;
                            color = data[width * y0 + x0];
                            if ((color >> 24 & 0xFF) <= 0) continue;
                            nonTransparentColor = color;
                            break block5;
                        }
                    }
                    if (nonTransparentColor == null) continue;
                    nonTransparentColor = nonTransparentColor & 0xFFFFFF;
                    for (i = 0; i < lod; ++i) {
                        for (j = 0; j < lod; ++j) {
                            y0 = y * lod + j;
                            x0 = x * lod + i;
                            color = data[width * y0 + x0];
                            if ((color >> 24 & 0xFF) != 0) continue;
                            data[width * y0 + x0] = nonTransparentColor;
                        }
                    }
                }
            }
        }
        int previousWidth = width;
        int newWidth = width;
        int newHeight = height;
        for (int level = 0; level <= levels; ++level) {
            newData = new int[newWidth * newHeight];
            for (int y = 0; y < newHeight; ++y) {
                for (int x = 0; x < newWidth; ++x) {
                    int color;
                    if (level == 0) {
                        color = data[width * y + x];
                    } else {
                        int x1 = x << 1;
                        int y1 = y << 1;
                        if (smooth) {
                            int color0 = data[previousWidth * y1 + x1];
                            int color1 = data[previousWidth * y1 + (x1 + 1)];
                            int color2 = data[previousWidth * (y1 + 1) + x1];
                            int color3 = data[previousWidth * (y1 + 1) + (x1 + 1)];
                            color = this.blendColor(this.blendColor(color0, color1), this.blendColor(color2, color3));
                        } else {
                            color = data[previousWidth * y1 + x1];
                        }
                    }
                    newData[y * newWidth + x] = color;
                }
            }
            buffer.position(0).limit(buffer.capacity());
            for (int i = 0; i < newData.length; ++i) {
                int color = newData[i];
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                buffer.put((byte)(color >> 0 & 0xFF));
                buffer.put((byte)(color >> 24 & 0xFF));
            }
            buffer.limit(buffer.position()).flip();
            GL41.glTexImage2D(3553, debugMipmap ? 0 : level, 6408, newWidth, newHeight, 0, 6408, 5121, buffer);
            if (!debugMipmap) {
                GL41.glTexParameteri(3553, 33085, level);
                GL41.glTexParameteri(3553, 10241, 9986);
            }
            data = newData;
            previousWidth = newWidth;
            newWidth /= 2;
            newHeight /= 2;
        }
    }

    protected int blendColor(int color0, int color1) {
        int alpha0 = color0 >> 24 & 0xFF;
        int alpha1 = color1 >> 24 & 0xFF;
        int alphaAvg = (alpha0 + alpha1) / 2;
        if (alpha0 == 0 && alpha1 == 0) {
            alpha0 = 1;
            alpha1 = 1;
        } else {
            if (alpha0 == 0) {
                color0 = color1;
                alphaAvg /= 2;
            }
            if (alpha1 == 0) {
                color1 = color0;
                alphaAvg /= 2;
            }
        }
        int r0 = (color0 >> 16 & 0xFF) * alpha0;
        int g0 = (color0 >> 8 & 0xFF) * alpha0;
        int b0 = (color0 >> 0 & 0xFF) * alpha0;
        int r1 = (color1 >> 16 & 0xFF) * alpha1;
        int g1 = (color1 >> 8 & 0xFF) * alpha1;
        int b1 = (color1 >> 0 & 0xFF) * alpha1;
        int rAvg = (r0 + r1) / (alpha0 + alpha1);
        int gAvg = (g0 + g1) / (alpha0 + alpha1);
        int bAvg = (b0 + b1) / (alpha0 + alpha1);
        return alphaAvg << 24 | rAvg << 16 | gAvg << 8 | bAvg;
    }
}

