/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.save;

import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.util.List;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkLoaderRegionAsync;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveHandlerBase;
import org.jetbrains.annotations.NotNull;

public class SaveHandlerClientSP
extends SaveHandlerBase {
    public SaveHandlerClientSP(ISaveFormat saveFormat, File savesDir, String worldDirName) {
        super(saveFormat, savesDir, worldDirName);
    }

    @Override
    public void load(@NotNull Player player) {
        CompoundTag lastPlayerTag;
        LevelData data = this.getLevelData();
        if (data != null && data.getLastPlayerUUID() != null && (lastPlayerTag = this.getPlayerData(null, data.getLastPlayerUUID())) != null) {
            player.load(lastPlayerTag);
            return;
        }
        super.load(player);
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        File dimDir = this.saveFormat.getDimensionRootDir(this.worldDirName, dimension);
        dimDir.mkdirs();
        return new ChunkLoaderRegionAsync(dimDir);
    }

    @Override
    public void saveLevelDataAndPlayerData(@NotNull LevelData levelData, @NotNull List<Player> playerList) {
        levelData.setSaveVersion(this.saveFormat.getSaveVersion());
        super.saveLevelDataAndPlayerData(levelData, playerList);
    }
}

