/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicEdible;
import net.minecraft.core.item.Items;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPiePumpkin
extends BlockLogicEdible {
    public BlockLogicPiePumpkin(@NotNull Block<?> block) {
        super(block, 4, () -> Items.FOOD_PUMPKIN_PIE);
    }

    @Override
    public int getHealAmount(@NotNull World world, @NotNull TilePosc tilePos) {
        return 5;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int data = source.getBlockData(tilePos);
        float f = 0.0625f;
        float xMin = data >= 2 ? 0.5f : f;
        float zMin = data >= 3 ? 0.5f : f;
        float f2 = 0.375f;
        return new AABBd(xMin, 0.0, zMin, 1.0f - f, f2, 1.0f - f);
    }
}

