/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import org.jetbrains.annotations.NotNull;

public class WorldTypeGroups {
    @NotNull
    public static final @NotNull List<@NotNull Group> GROUPS = new ArrayList<Group>();
    @NotNull
    public static final Group DEFAULT = new Group(WorldTypes.OVERWORLD_EXTENDED);

    static {
        GROUPS.add(DEFAULT);
        GROUPS.add(new Group(WorldTypes.OVERWORLD_DEFAULT));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_WINTER));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_FLOATING));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_AMPLIFIED));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_ISLANDS));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_INLAND));
        GROUPS.add(new Group(WorldTypes.FLAT));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_HELL));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_WOODS));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_PARADISE));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_BETA_173));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_CLASSIC));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_INDEV));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_RETRO));
        GROUPS.add(new Group(WorldTypes.OVERWORLD_SKYBLOCK).with(Dimension.NETHER, WorldTypes.NETHER_SKYBLOCK));
        GROUPS.add(new Group(WorldTypes.EMPTY));
        GROUPS.add(new Group(WorldTypes.DEBUG));
    }

    public static class Group {
        private final Map<Dimension, WorldType> worldTypes = new HashMap<Dimension, WorldType>();

        public Group(WorldType overworldType) {
            for (int i = 0; i < Dimension.getDimensionList().size(); ++i) {
                this.worldTypes.put((Dimension)Dimension.getDimensionList().get(i), Objects.requireNonNull((Dimension)Dimension.getDimensionList().get((int)i)).defaultWorldType);
            }
            this.worldTypes.put(Dimension.OVERWORLD, overworldType);
        }

        @NotNull
        public Group with(Dimension dimension, WorldType worldType) {
            this.worldTypes.put(dimension, worldType);
            return this;
        }

        @NotNull
        public WorldType get(Dimension dimension) {
            return Objects.requireNonNull(this.worldTypes.get(dimension));
        }
    }
}

