/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.server;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenConnecting;
import net.minecraft.client.gui.paged.Page;
import net.minecraft.client.gui.paged.PageRegistry;
import net.minecraft.client.gui.paged.ScreenPaged;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.gui.server.ServerEntry;
import net.minecraft.client.gui.server.ServerEntryComponent;
import net.minecraft.client.gui.server.ServerListenerThread;
import net.minecraft.client.gui.server.ServerManager;
import net.minecraft.client.gui.server.SeverDirectConnectComponent;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ServerAddress;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenSelectServer
extends ScreenPaged {
    public static final Texture defaultIcon = Minecraft.getMinecraft().textureManager.loadTexture("/assets/minecraft/textures/gui/unknown_server.png");
    @NotNull
    public static final PageRegistry CREATE_WORLD_PAGES = new PageRegistry();
    private static final ItemStack MAP = Items.MAP.getDefaultStack();
    @NotNull
    public static final DateFormat timeFormatter;
    @NotNull
    public static final Page PAGE_FAVORITES;
    @NotNull
    public static final Page PAGE_HISTORY;
    @NotNull
    public static final Page PAGE_LAN;
    @NotNull
    public static final Page PAGE_DIRECT_CONNECT;
    @NotNull
    private static final StringBuilder stringBuilder;
    @NotNull
    public final ServerManager serverManager = ServerManager.getServerManager(this);
    @Nullable
    public ServerEntry selectedEntry = null;
    public ButtonElement buttonJoin;
    public ButtonElement buttonAddServer;
    public ButtonElement buttonEdit;
    public ButtonElement buttonDelete;
    public ButtonElement buttonRefresh;
    public ButtonElement buttonCancel;
    @Nullable
    public ServerAddress addressToJoin = null;
    public ServerListenerThread listenerThread = new ServerListenerThread(this);
    public boolean needToRefreshPages = false;
    protected float panelScrollAmount = 0.0f;
    protected int panelScrollRegionHeight;
    @Nullable
    protected Float oldPanelScrollAmount = null;
    protected float panelHeight = 100000.0f;

    public ScreenSelectServer(@Nullable Screen parent) {
        super(parent, CREATE_WORLD_PAGES, PAGE_FAVORITES, "gui.select_server.label.title", new String[0]);
        this.listenerThread.start();
        this.refreshPages();
    }

    @Override
    public void init() {
        super.init();
        this.setupButtons();
    }

    public void refreshPages() {
        PAGE_FAVORITES.clearComponents();
        PAGE_HISTORY.clearComponents();
        PAGE_LAN.clearComponents();
        PAGE_DIRECT_CONNECT.clearComponents();
        PAGE_DIRECT_CONNECT.withComponent(new SeverDirectConnectComponent(this));
        this.serverManager.getFavorites().forEach(e -> PAGE_FAVORITES.withComponent(new ServerEntryComponent(this, (ServerEntry)e)));
        this.serverManager.getLan().forEach(e -> PAGE_LAN.withComponent(new ServerEntryComponent(this, (ServerEntry)e)));
        this.serverManager.getHistory().forEach(e -> PAGE_HISTORY.withComponent(new ServerEntryComponent(this, (ServerEntry)e)));
    }

    public void setupButtons() {
        this.rightOffset = this.selectedPage != PAGE_DIRECT_CONNECT ? (int)((float)this.width * 0.25f) : 0;
        this.buttons.clear();
        I18n trans = I18n.getInstance();
        int x1 = this.width / 2 - 154;
        int y1 = this.height - 52;
        int y2 = this.height - 24;
        int w = this.width - this.rightOffset - this.leftWidth;
        this.buttonJoin = this.add(new ButtonElement(0, this.width - this.rightOffset + 10, this.bottom - 66, this.rightOffset - 12, 20, trans.translateKey("gui.select_server.button.join_server")));
        this.buttonEdit = this.add(new ButtonElement(3, this.width - this.rightOffset + 10, this.bottom - 44, this.rightOffset - 12, 20, trans.translateKey("gui.select_server.button.edit")));
        this.buttonDelete = this.add(new ButtonElement(4, this.width - this.rightOffset + 10, this.bottom - 22, this.rightOffset - 12, 20, trans.translateKey("gui.select_server.button.delete")));
        this.buttonAddServer = this.add(new ButtonElement(2, x1 + 208, y2, 100, 20, trans.translateKey("gui.select_server.button.add_server")));
        this.buttonRefresh = this.add(new ButtonElement(5, x1 + 104, y2, 100, 20, trans.translateKey("gui.select_server.button.refresh")));
        this.buttonCancel = this.add(new ButtonElement(6, x1, y2, 100, 20, trans.translateKey("gui.select_server.button.cancel")));
        if (this.selectedPage == PAGE_DIRECT_CONNECT) {
            this.buttonAddServer.visible = false;
            this.buttonAddServer.enabled = false;
            this.buttonRefresh.visible = false;
            this.buttonRefresh.enabled = false;
            this.buttonCancel.xPosition = (this.width - 100) / 2;
        }
        this.panelScrollRegionHeight = this.buttonJoin.yPosition - this.top;
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (button == this.buttonCancel) {
            this.mc.displayScreen(this.getParentScreen());
            this.freeResources();
        } else if (button == this.buttonAddServer) {
            PopupScreen add = new PopupBuilder(this, 160).withLabel("gui.select_server.popup.add.prompt.name").withTextField("name", "").withLabel("gui.select_server.popup.add.prompt.ip").withTextField("ip", "").withButtonGroup("1", new String[]{"gui.select_server.popup.add.button.cancel", "gui.select_server.popup.add.button.save"}, new int[]{0, 1}).withSwitch("showIp", true, "gui.select_server.popup.add.showip.on", "gui.select_server.popup.add.showip.off").closeOnEsc(0).closeOnEnter(1).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    String name = (String)results.get("name");
                    if (name.isEmpty()) {
                        name = null;
                    }
                    ServerEntry entry = new ServerEntry(UUID.randomUUID(), (String)results.get("ip"));
                    entry.overrideName = name;
                    entry.showIp = (Boolean)results.get("showIp");
                    entry.dirty = true;
                    entry.requestIcon = true;
                    this.serverManager.addEntry(entry);
                    this.serverManager.addFavorite(entry);
                    this.refreshPages();
                }
            }).build();
            this.mc.displayScreen(add);
        } else if (button == this.buttonEdit && this.selectedEntry != null) {
            ServerEntry tEntry = this.selectedEntry;
            PopupScreen edit = new PopupBuilder(this, 160).withLabel("gui.select_server.popup.edit.prompt.name").withTextField("name", tEntry.overrideName == null ? "" : tEntry.overrideName).withLabel("gui.select_server.popup.edit.prompt.ip").withTextField("ip", tEntry.address).withButtonGroup("1", new String[]{"gui.select_server.popup.edit.button.cancel", "gui.select_server.popup.edit.button.save"}, new int[]{0, 1}).withSwitch("showIp", tEntry.showIp, "gui.select_server.popup.edit.showip.on", "gui.select_server.popup.edit.showip.off").closeOnEsc(0).closeOnEnter(1).closeOnClickOut(0).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    String name = (String)results.get("name");
                    if (name.isEmpty()) {
                        name = null;
                    }
                    tEntry.overrideName = name;
                    tEntry.address = (String)results.get("ip");
                    tEntry.addressResolved = null;
                    tEntry.showIp = (Boolean)results.get("showIp");
                    tEntry.dirty = true;
                    tEntry.requestIcon = true;
                    this.refreshPages();
                }
            }).build();
            this.mc.displayScreen(edit);
        } else if (button == this.buttonJoin) {
            if (this.selectedEntry != null) {
                this.needToRefreshPages = true;
                this.serverManager.onJoined(this.selectedEntry);
                this.joinServer(this.selectedEntry.getServerAddress());
            }
        } else if (button == this.buttonRefresh) {
            this.refresh();
        } else if (button == this.buttonDelete && this.selectedEntry != null) {
            this.deleteEntry(this.selectedEntry);
        }
    }

    private void scrollPanel(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.panelScrollAmount += amount;
        this.onScrollPanel();
    }

    private void onScrollPanel() {
        int totalPanelHeight = this.getTotalPanelHeight();
        if (this.panelScrollAmount < 0.0f || this.panelScrollRegionHeight > totalPanelHeight) {
            this.panelScrollAmount = 0.0f;
        } else if (this.panelScrollAmount > (float)(totalPanelHeight - this.panelScrollRegionHeight)) {
            this.panelScrollAmount = totalPanelHeight - this.panelScrollRegionHeight;
        }
    }

    private int getTotalPanelHeight() {
        return (int)this.panelHeight;
    }

    public void joinServer(@NotNull ServerAddress address) {
        GameSettings.LAST_SERVER.value = address.toString().replaceAll(":", "_");
        GameSettings.saveOptions();
        this.mc.displayScreen(new ScreenConnecting(this.mc, address.getIP(), address.getPort()));
        this.freeResources();
    }

    public void freeResources() {
        this.serverManager.freeResources();
        this.listenerThread.keepAlive = false;
    }

    public void refresh() {
        this.serverManager.idToEntryLock.lock();
        try {
            this.serverManager.idToEntryMap.forEach((uuid, entry) -> {
                entry.dirty = true;
            });
        }
        finally {
            this.serverManager.idToEntryLock.unlock();
        }
    }

    @Override
    public void tick() {
        this.serverManager.idToEntryLock.lock();
        try {
            this.serverManager.idToEntryMap.values().stream().filter(entry -> entry.queuedIcon != null).forEach(entry -> {
                entry.icon = new TextureBuffered(entry.queuedIcon, false, false, false);
                entry.queuedIcon = null;
            });
        }
        finally {
            this.serverManager.idToEntryLock.unlock();
        }
    }

    public void deleteEntry(@NotNull ServerEntry entry) {
        if (this.selectedPage == PAGE_FAVORITES) {
            this.serverManager.removeFavorite(entry);
        } else if (this.selectedPage == PAGE_HISTORY) {
            this.serverManager.removeHistory(entry);
        }
        this.refreshPages();
    }

    @Override
    public void handleScroll(int mx, int my, float partialTick) {
        if (mx > this.width - this.rightOffset && mx < this.width) {
            if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                this.scrollPanel((float)Mouse.getDWheel() / -0.01f);
            } else {
                this.scrollPanel((float)Mouse.getDWheel() / -0.05f);
            }
            this.onScrollPanel();
            return;
        }
        super.handleScroll(mx, my, partialTick);
    }

    @Override
    public void render(int mx, int my, float renderPartialTicks) {
        if (this.addressToJoin != null) {
            this.joinServer(this.addressToJoin);
            return;
        }
        if (this.needToRefreshPages) {
            this.needToRefreshPages = false;
            this.refreshPages();
        }
        this.buttonJoin.enabled = this.selectedEntry != null;
        this.buttonJoin.visible = this.buttonJoin.enabled;
        this.buttonEdit.enabled = this.selectedEntry != null;
        this.buttonEdit.visible = this.buttonEdit.enabled;
        this.buttonDelete.enabled = this.selectedEntry != null;
        this.buttonDelete.visible = this.buttonDelete.enabled;
        super.render(mx, my, renderPartialTicks);
        this.overlayBackground(this.width - this.rightOffset, this.width - this.rightOffset + 8, this.top, this.bottom);
        Scissor.enable(this.width - this.rightOffset, this.top, this.rightOffset, this.buttonJoin.yPosition - this.top);
        this.renderSelectedEntry(mx, my, renderPartialTicks);
        Scissor.disable();
    }

    protected void drawPanelScrollBar(int mouseX, int mouseY) {
        int totalPanelHeight = this.getTotalPanelHeight();
        float scrollBarHeightPercent = (float)this.panelScrollRegionHeight / (float)totalPanelHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        int scrollBarX = this.width - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.panelScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.panelScrollAmount / (float)(totalPanelHeight - this.panelScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.panelScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        @NotNull TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.setColorOpaque3i(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.panelScrollRegionHeight);
        t.setColor2i(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColor2i(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GLRenderer.popFrame();
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldPanelScrollAmount == null) {
                    this.oldPanelScrollAmount = Float.valueOf(this.panelScrollAmount);
                }
                this.panelScrollAmount = this.oldPanelScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollPanel();
            }
        } else {
            this.oldPanelScrollAmount = null;
        }
    }

    public void renderSelectedEntry(int mx, int my, float partialTick) {
        if (this.selectedEntry != null) {
            int y;
            int totalPanelHeight = this.getTotalPanelHeight();
            float scrollBarHeightPercent = (float)this.panelScrollRegionHeight / (float)totalPanelHeight;
            TessellatorShader t = GLRenderer.getTessellator();
            int minX = this.width - this.rightOffset + 8;
            int maxX = this.width;
            int startY = y = (int)((float)(this.top + 4) - this.panelScrollAmount);
            if (this.selectedEntry.icon != null) {
                this.selectedEntry.icon.bind();
                t.startDrawingQuads();
                t.drawRectangleWithUV(minX + (maxX - minX - 64) / 2, y, 64, 64, 0.0, 0.0, 1.0, 1.0);
                y += 66;
                t.draw();
            }
            stringBuilder.setLength(0);
            if (this.selectedEntry.showIp) {
                stringBuilder.append(TextFormatting.GRAY).append(this.selectedEntry.getServerAddress().getIP()).append(":").append(this.selectedEntry.getServerAddress().getPort()).append(TextFormatting.RESET).append("\n");
            }
            stringBuilder.append(this.selectedEntry.getName("Unknown"));
            if (this.selectedEntry.version != null) {
                stringBuilder.append(TextFormatting.RESET).append("\n\n");
                stringBuilder.append(this.selectedEntry.protocolVersion == 65312 ? TextFormatting.YELLOW : TextFormatting.RED).append(this.selectedEntry.version);
            }
            stringBuilder.append(TextFormatting.RESET).append("\n\n");
            if (this.selectedEntry.motd != null) {
                stringBuilder.append(this.selectedEntry.motd);
            }
            if (!this.selectedEntry.players.isEmpty()) {
                stringBuilder.append(TextFormatting.RESET).append("\n\n");
                stringBuilder.append("Players:\n");
                for (int i = 0; i < this.selectedEntry.players.size(); ++i) {
                    stringBuilder.append(" - ").append(TextFormatting.GRAY).append(this.selectedEntry.players.get(i)).append(TextFormatting.RESET).append("\n");
                }
            }
            if (this.selectedEntry.lastPlayedTime >= 0L) {
                stringBuilder.append(TextFormatting.RESET).append("\n\n");
                stringBuilder.append("Last Played: ").append(timeFormatter.format(Date.from(Instant.ofEpochMilli(this.selectedEntry.lastPlayedTime))));
            }
            this.mc.font.renderWidthConstrained(stringBuilder, minX + 2, y, maxX - minX - 4 - (scrollBarHeightPercent > 1.0f ? 0 : 6)).setShadow().call();
            this.panelHeight = (float)(this.mc.font.getLastEndingY() - startY) + 8.0f;
            this.drawPanelScrollBar(mx, my);
        }
    }

    @Override
    public void onPageChanged(@NotNull Page lastPage, @NotNull Page newPage) {
        this.setSelectedEntry(null);
        this.setupButtons();
    }

    public void setSelectedEntry(@Nullable ServerEntry entry) {
        this.selectedEntry = entry;
        this.panelScrollAmount = 0.0f;
        this.oldPanelScrollAmount = null;
        this.panelHeight = 0.0f;
    }

    @Override
    public void renderBackground() {
        if (this.mc.currentWorld == null) {
            this.renderTexturedBackground();
            @NotNull TessellatorShader tessellator = GLRenderer.getTessellator();
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque1i(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width - this.rightOffset, this.bottom, 0.0, (float)(this.width - this.rightOffset) / 32.0f, ((float)this.bottom + this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width - this.rightOffset, this.top, 0.0, (float)(this.width - this.rightOffset) / 32.0f, ((float)this.top + this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.rightScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width - this.rightOffset, this.bottom, 0.0, (float)(this.width - this.rightOffset) / 32.0f, ((float)this.bottom + this.panelScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / 32.0f, ((float)this.bottom + this.panelScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / 32.0f, ((float)this.top + this.panelScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.width - this.rightOffset, this.top, 0.0, (float)(this.width - this.rightOffset) / 32.0f, ((float)this.top + this.panelScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, ((float)this.bottom + this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.leftWidth, this.bottom, 0.0, (float)this.leftWidth / 32.0f, ((float)this.bottom + this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(this.leftWidth, this.top, 0.0, (float)this.leftWidth / 32.0f, ((float)this.top + this.leftScrollAmount) / 32.0f);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, ((float)this.top + this.leftScrollAmount) / 32.0f);
            tessellator.draw();
        } else {
            int color = ((Color)GameSettings.GUI_BACKGROUND_COLOR.value).getARGB();
            this.drawGradientRect(0, 0, this.width, this.height, color, color);
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
            this.drawRect(this.leftWidth, this.top, this.leftWidth + 8, this.bottom, 0x5F000000);
        }
    }

    @Override
    public void removed() {
        super.removed();
        ServerManager.saveServerManager(this.serverManager);
    }

    static {
        MAP.getData().putBoolean("initialized", true);
        timeFormatter = new SimpleDateFormat();
        PAGE_FAVORITES = CREATE_WORLD_PAGES.register(new Page("gui.select_server.page.favorites.title", Items.FLAG.getDefaultStack()));
        PAGE_HISTORY = CREATE_WORLD_PAGES.register(new Page("gui.select_server.page.history.title", Items.BOOK.getDefaultStack()));
        PAGE_LAN = CREATE_WORLD_PAGES.register(new Page("gui.select_server.page.lan.title", Items.DOOR_OAK.getDefaultStack()));
        PAGE_DIRECT_CONNECT = CREATE_WORLD_PAGES.register(new Page("gui.select_server.page.direct_connect.title", Items.AMMO_ARROW_GOLD.getDefaultStack()));
        stringBuilder = new StringBuilder(512);
    }
}

