/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.models.block.mojang;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightingCache;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.LightIndexHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.mojang.BlockModelMojangData;
import org.useless.dragonfly.data.block.mojang.CompiledBlockModelMojangData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class StaticBlockModelMojang
implements StaticBlockModel {
    protected static final Minecraft MC = Minecraft.getMinecraft();
    protected static final LightingCache LIGHTING_CACHE = new LightingCache();
    @NotNull
    protected final CompiledBlockModelMojangData compiled;
    @NotNull
    private final Vector3d vertPos = new Vector3d();
    @NotNull
    private final Vector3f faceVec = new Vector3f();
    @NotNull
    private final Vector2f vertUV = new Vector2f();

    public StaticBlockModelMojang(@NotNull BlockModelMojangData data) {
        this.compiled = new CompiledBlockModelMojangData(data);
    }

    @Override
    public boolean renderStandalone(@NotNull BlockModelGeneric<? extends BlockLogic> sourceModel, @NotNull TessellatorGeneral tessellator, double x, double y, double z, int metadata, byte lightIndex, @NotNull BlockColor color) {
        if (this.compiled.elements.length == 0) {
            return false;
        }
        tessellator.startDrawingQuads();
        for (int i = 0; i < this.compiled.elements.length; ++i) {
            CompiledBlockModelMojangData.C_Element element = this.compiled.elements[i];
            tessellator.setLightmapCoord1i(lightIndex);
            for (int face = 0; face < element.faces; ++face) {
                IconCoordinate coordinate = element.textures[face];
                if (element.tintIndices[face] >= 0) {
                    tessellator.setColor1i(color.getFallbackColor(metadata, element.tintIndices[face]));
                } else {
                    tessellator.setColor1i(-1);
                }
                int offset = face * 4;
                for (int v = 0; v < 4; ++v) {
                    if (element.shade) {
                        Vector3fc normal = element.faceNormals[face];
                        tessellator.setNormal(normal.x(), normal.y(), normal.z());
                    } else {
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    }
                    Vector3dc pos = element.vertexPoses[offset + v];
                    Vector2fc uvs = element.vertexUvs[offset + v];
                    tessellator.addVertexWithUV(pos.x() - 0.5, pos.y() - 0.5, pos.z() - 0.5, coordinate.getSubIconU(uvs.x()), coordinate.getSubIconV(uvs.y()));
                }
            }
        }
        tessellator.draw();
        return true;
    }

    @Override
    public boolean renderAttached(@NotNull BlockModelGeneric<? extends BlockLogic> sourceModel, @NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc blockPos, int rotX, int rotY, int rotZ, double xOff, double yOff, double zOff, boolean uvlock, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        boolean didRender = false;
        int cullCache = 0;
        BlockColor color = null;
        for (int i = 0; i < this.compiled.elements.length; ++i) {
            CompiledBlockModelMojangData.C_Element element = this.compiled.elements[i];
            for (int face = 0; face < element.faces; ++face) {
                float colorBlueBottomLeft;
                float colorGreenBottomLeft;
                float colorRedBottomLeft;
                float lightBL;
                float lightBR;
                float lightTR;
                float lightTL;
                byte lightIndexBottomRight;
                byte lightIndexBottomLeft;
                byte lightIndexTopRight;
                byte lightIndexTopLeft;
                boolean lefT;
                float b;
                float g;
                float r;
                boolean isFullCube;
                float rigP;
                float lefP;
                float botP;
                float topP;
                float depth;
                Direction cullDir = element.cullfaces[face];
                if (cullFaces && cullDir != null) {
                    if ((cullCache & 1 << (cullDir = Direction.rotateZ(Direction.rotateY(Direction.rotateX(cullDir, rotX), rotY), rotZ)).getId()) != 0) continue;
                    if (sourceModel.cullSide(worldSource, blockPos, cullDir)) {
                        cullCache = (byte)(cullCache | (byte)(1 << cullDir.getId()));
                        continue;
                    }
                }
                IconCoordinate coordinate = overrideTexture == null ? element.textures[face] : overrideTexture;
                Direction direction = Direction.rotateZ(Direction.rotateY(Direction.rotateX(element.directions[face], rotX), rotY), rotZ);
                float minBrightness = (float)element.lightEmission / 15.0f;
                Vector3f top = this.faceVec.set(element.faceUps[face]);
                if (rotX != 0) {
                    top.rotateX((float)rotX * 1.5707964f);
                }
                if (rotY != 0) {
                    top.rotateY((float)rotY * 1.5707964f);
                }
                if (rotZ != 0) {
                    top.rotateZ((float)rotZ * 1.5707964f);
                }
                int topX = Math.round(top.x());
                int topY = Math.round(top.y());
                int topZ = Math.round(top.z());
                Vector3f left = this.faceVec.set(element.faceLefts[face]);
                if (rotX != 0) {
                    left.rotateX((float)rotX * 1.5707964f);
                }
                if (rotY != 0) {
                    left.rotateY((float)rotY * 1.5707964f);
                }
                if (rotZ != 0) {
                    left.rotateZ((float)rotZ * 1.5707964f);
                }
                int lefX = Math.round(left.x());
                int lefY = Math.round(left.y());
                int lefZ = Math.round(left.z());
                if (element.flip) {
                    switch (element.directions[face]) {
                        case DOWN: {
                            depth = 1.0f - element.minY;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = 1.0f - element.minX;
                            rigP = 1.0f - element.maxX;
                            break;
                        }
                        case UP: {
                            depth = 0.0f + element.maxY;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = element.maxX;
                            rigP = element.minX;
                            break;
                        }
                        case NORTH: {
                            depth = 1.0f - element.minZ;
                            topP = 1.0f - element.minX;
                            botP = 1.0f - element.maxX;
                            lefP = element.maxY;
                            rigP = element.minY;
                            break;
                        }
                        case SOUTH: {
                            depth = 0.0f + element.maxZ;
                            topP = element.maxY;
                            botP = element.minY;
                            lefP = 1.0f - element.minX;
                            rigP = 1.0f - element.maxX;
                            break;
                        }
                        case WEST: {
                            depth = 1.0f - element.maxX;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = element.maxY;
                            rigP = element.minY;
                            break;
                        }
                        default: {
                            depth = 0.0f + element.minX;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = 1.0f - element.minY;
                            rigP = 1.0f - element.maxY;
                            break;
                        }
                    }
                } else {
                    switch (element.directions[face]) {
                        case DOWN: {
                            depth = 0.0f + element.minY;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = 1.0f - element.minX;
                            rigP = 1.0f - element.maxX;
                            break;
                        }
                        case UP: {
                            depth = 1.0f - element.maxY;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = element.maxX;
                            rigP = element.minX;
                            break;
                        }
                        case NORTH: {
                            depth = 0.0f + element.minZ;
                            topP = 1.0f - element.minX;
                            botP = 1.0f - element.maxX;
                            lefP = element.maxY;
                            rigP = element.minY;
                            break;
                        }
                        case SOUTH: {
                            depth = 1.0f - element.maxZ;
                            topP = element.maxY;
                            botP = element.minY;
                            lefP = 1.0f - element.minX;
                            rigP = 1.0f - element.maxX;
                            break;
                        }
                        case WEST: {
                            depth = 0.0f + element.minX;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = element.maxY;
                            rigP = element.minY;
                            break;
                        }
                        default: {
                            depth = 1.0f - element.maxX;
                            topP = element.maxZ;
                            botP = element.minZ;
                            lefP = 1.0f - element.minY;
                            rigP = 1.0f - element.maxY;
                        }
                    }
                }
                boolean useAO = this.compiled.data.ambientOcclusion && MC.isAmbientOcclusionEnabled() && element.shade;
                boolean bl = isFullCube = depth <= 0.0625f && element.shade;
                if (element.tintIndices[face] >= 0) {
                    if (color == null) {
                        color = (BlockColor)BlockColorDispatcher.getInstance().getDispatch(sourceModel.block);
                    }
                    int c = color.getWorldColor(worldSource, blockPos, element.tintIndices[face]);
                    r = (float)Color.redFromInt(c) / 255.0f;
                    g = (float)Color.greenFromInt(c) / 255.0f;
                    b = (float)Color.blueFromInt(c) / 255.0f;
                } else {
                    r = 1.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                int dirX = element.flip ? -direction.getOffsetX() : direction.getOffsetX();
                int dirY = element.flip ? -direction.getOffsetY() : direction.getOffsetY();
                int dirZ = element.flip ? -direction.getOffsetZ() : direction.getOffsetZ();
                LIGHTING_CACHE.setupCache(sourceModel.block, worldSource, blockPos);
                if (useAO) {
                    byte lmcTopRig;
                    byte lmcBotLef;
                    byte lmcTopLef;
                    byte lmcRig;
                    int dirZ2;
                    int dirY2;
                    int dirX2;
                    if (!isFullCube) {
                        dirX2 = 0;
                        dirY2 = 0;
                        dirZ2 = 0;
                    } else {
                        dirX2 = dirX;
                        dirY2 = dirY;
                        dirZ2 = dirZ;
                    }
                    boolean topT = LIGHTING_CACHE.getOpacity(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                    boolean botT = LIGHTING_CACHE.getOpacity(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                    lefT = LIGHTING_CACHE.getOpacity(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                    boolean rigT = LIGHTING_CACHE.getOpacity(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                    boolean topLefT = LIGHTING_CACHE.getOpacity(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ);
                    boolean topRigT = LIGHTING_CACHE.getOpacity(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ);
                    boolean botLefT = LIGHTING_CACHE.getOpacity(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ);
                    boolean botRigT = LIGHTING_CACHE.getOpacity(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ);
                    byte lmcCen = this.getLightIndex(dirX2, dirY2, dirZ2, element.lightEmission);
                    byte lmcTop = topT ? lmcCen : this.getLightIndex(dirX2 + topX, dirY2 + topY, dirZ2 + topZ, element.lightEmission);
                    byte lmcBot = botT ? lmcCen : this.getLightIndex(dirX2 - topX, dirY2 - topY, dirZ2 - topZ, element.lightEmission);
                    byte lmcLef = lefT ? lmcCen : this.getLightIndex(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ, element.lightEmission);
                    byte by = lmcRig = rigT ? lmcCen : this.getLightIndex(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ, element.lightEmission);
                    byte by2 = topT && lefT ? lmcLef : (lmcTopLef = topLefT ? lmcCen : this.getLightIndex(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ, element.lightEmission));
                    byte by3 = botT && lefT ? lmcLef : (lmcBotLef = botLefT ? lmcCen : this.getLightIndex(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ, element.lightEmission));
                    byte by4 = topT && rigT ? lmcRig : (lmcTopRig = topRigT ? lmcCen : this.getLightIndex(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ, element.lightEmission));
                    byte lmcBotRig = botT && rigT ? lmcRig : (botRigT ? lmcCen : this.getLightIndex(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ, element.lightEmission));
                    lightIndexTopLeft = LightIndexHelper.avg(lmcCen, lmcLef, lmcTop, lmcTopLef);
                    lightIndexTopRight = LightIndexHelper.avg(lmcCen, lmcRig, lmcTop, lmcTopRig);
                    lightIndexBottomLeft = LightIndexHelper.avg(lmcCen, lmcLef, lmcBot, lmcBotLef);
                    lightIndexBottomRight = LightIndexHelper.avg(lmcCen, lmcRig, lmcBot, lmcBotRig);
                } else {
                    byte lmc = !isFullCube ? this.getLightIndex(0, 0, 0, element.lightEmission) : this.getLightIndex(dirX, dirY, dirZ, element.lightEmission);
                    lightIndexBottomRight = lightIndexTopRight = lmc;
                    lightIndexBottomLeft = lightIndexTopRight;
                    lightIndexTopLeft = lightIndexTopRight;
                }
                if (useAO) {
                    float dirB = this.getBrightness(dirX, dirY, dirZ, minBrightness);
                    lefT = LIGHTING_CACHE.getOpacity(dirX + lefX, dirY + lefY, dirZ + lefZ);
                    boolean botT = LIGHTING_CACHE.getOpacity(dirX - topX, dirY - topY, dirZ - topZ);
                    boolean topT = LIGHTING_CACHE.getOpacity(dirX + topX, dirY + topY, dirZ + topZ);
                    boolean rigT = LIGHTING_CACHE.getOpacity(dirX - lefX, dirY - lefY, dirZ - lefZ);
                    float lB = this.getBrightness(dirX + lefX, dirY + lefY, dirZ + lefZ, minBrightness);
                    float bB = this.getBrightness(dirX - topX, dirY - topY, dirZ - topZ, minBrightness);
                    float tB = this.getBrightness(dirX + topX, dirY + topY, dirZ + topZ, minBrightness);
                    float rB = this.getBrightness(dirX - lefX, dirY - lefY, dirZ - lefZ, minBrightness);
                    float blB = botT && lefT ? lB : this.getBrightness(dirX + lefX - topX, dirY + lefY - topY, dirZ + lefZ - topZ, minBrightness);
                    float tlB = topT && lefT ? lB : this.getBrightness(dirX + lefX + topX, dirY + lefY + topY, dirZ + lefZ + topZ, minBrightness);
                    float brB = botT && rigT ? rB : this.getBrightness(dirX - lefX - topX, dirY - lefY - topY, dirZ - lefZ - topZ, minBrightness);
                    float trB = topT && rigT ? rB : this.getBrightness(dirX - lefX + topX, dirY - lefY + topY, dirZ - lefZ + topZ, minBrightness);
                    lightTL = (tlB + lB + tB + dirB) / 4.0f;
                    lightTR = (tB + dirB + trB + rB) / 4.0f;
                    lightBR = (dirB + bB + rB + brB) / 4.0f;
                    lightBL = (lB + blB + dirB + bB) / 4.0f;
                    if (!isFullCube) {
                        dirB = this.getBrightness(0, 0, 0, minBrightness);
                        lefT = LIGHTING_CACHE.getOpacity(lefX, lefY, lefZ);
                        botT = LIGHTING_CACHE.getOpacity(-topX, -topY, -topZ);
                        topT = LIGHTING_CACHE.getOpacity(topX, topY, topZ);
                        rigT = LIGHTING_CACHE.getOpacity(-lefX, -lefY, -lefZ);
                        lB = this.getBrightness(lefX, lefY, lefZ, minBrightness);
                        bB = this.getBrightness(-topX, -topY, -topZ, minBrightness);
                        tB = this.getBrightness(topX, topY, topZ, minBrightness);
                        rB = this.getBrightness(-lefX, -lefY, -lefZ, minBrightness);
                        blB = botT && lefT ? lB : this.getBrightness(lefX - topX, lefY - topY, lefZ - topZ, minBrightness);
                        tlB = topT && lefT ? lB : this.getBrightness(lefX + topX, lefY + topY, lefZ + topZ, minBrightness);
                        brB = botT && rigT ? rB : this.getBrightness(-lefX - topX, -lefY - topY, -lefZ - topZ, minBrightness);
                        trB = topT && rigT ? rB : this.getBrightness(-lefX + topX, -lefY + topY, -lefZ + topZ, minBrightness);
                        lightTL = (tlB + lB + tB + dirB) / 4.0f * depth + lightTL * (1.0f - depth);
                        lightTR = (tB + dirB + trB + rB) / 4.0f * depth + lightTR * (1.0f - depth);
                        lightBR = (dirB + bB + rB + brB) / 4.0f * depth + lightBR * (1.0f - depth);
                        lightBL = (lB + blB + dirB + bB) / 4.0f * depth + lightBL * (1.0f - depth);
                    }
                } else {
                    int dirZ2;
                    int dirY2;
                    int dirX2;
                    if (!isFullCube) {
                        dirX2 = 0;
                        dirY2 = 0;
                        dirZ2 = 0;
                    } else {
                        dirX2 = dirX;
                        dirY2 = dirY;
                        dirZ2 = dirZ;
                    }
                    lightBR = lightTR = this.getBrightness(dirX2, dirY2, dirZ2, minBrightness);
                    lightBL = lightTR;
                    lightTL = lightTR;
                }
                float colorRedBottomRight = colorRedBottomLeft = r;
                float colorRedTopRight = colorRedBottomLeft;
                float colorRedTopLeft = colorRedBottomLeft;
                float colorGreenBottomRight = colorGreenBottomLeft = g;
                float colorGreenTopRight = colorGreenBottomLeft;
                float colorGreenTopLeft = colorGreenBottomLeft;
                float colorBlueBottomRight = colorBlueBottomLeft = b;
                float colorBlueTopRight = colorBlueBottomLeft;
                float colorBlueTopLeft = colorBlueBottomLeft;
                float tl = topP * lightTL + (1.0f - topP) * lightBL;
                float tr = topP * lightTR + (1.0f - topP) * lightBR;
                float bl2 = botP * lightTL + (1.0f - botP) * lightBL;
                float br = botP * lightTR + (1.0f - botP) * lightBR;
                float ltl = lefP * tl + (1.0f - lefP) * tr;
                float lbl = lefP * bl2 + (1.0f - lefP) * br;
                float lbr = rigP * bl2 + (1.0f - rigP) * br;
                float ltr = rigP * tl + (1.0f - rigP) * tr;
                int offset = face * 4;
                Vector3f norm = this.faceVec.set(element.faceNormals[face]);
                if (rotX != 0) {
                    norm.rotateX((float)rotX * 1.5707964f);
                }
                if (rotY != 0) {
                    norm.rotateY((float)rotY * 1.5707964f);
                }
                if (rotZ != 0) {
                    norm.rotateZ((float)rotZ * 1.5707964f);
                }
                if (element.shade) {
                    tessellator.setNormal(norm.x(), norm.y(), norm.z());
                } else {
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                }
                Vector3d posTL = this.vertPos.set(element.vertexPoses[offset + 0]);
                if (rotX != 0 || rotY != 0 || rotZ != 0) {
                    posTL.sub(0.5, 0.5, 0.5).rotateX((double)rotX * 1.5707963267948966).rotateY((double)rotY * 1.5707963267948966).rotateZ((double)rotZ * 1.5707963267948966).add(0.5, 0.5, 0.5);
                }
                Vector2fc uvsTL = element.vertexUvs[offset + 0];
                if (uvlock) {
                    uvsTL = this.rotateUV(uvsTL, rotX, rotY, rotZ, element.directions[face], this.vertUV);
                }
                tessellator.setColorOpaque3f(colorRedTopLeft, colorGreenTopLeft, colorBlueTopLeft);
                tessellator.setLightmapCoord1i(lightIndexTopLeft);
                tessellator.setShade1i((int)(ltl * 255.0f));
                tessellator.addVertexWithUV(posTL.x() + (double)blockPos.x() + xOff, posTL.y() + (double)blockPos.y() + yOff, posTL.z() + (double)blockPos.z() + zOff, coordinate.getSubIconU(uvsTL.x()), coordinate.getSubIconV(uvsTL.y()));
                Vector3d posBL = this.vertPos.set(element.vertexPoses[offset + 1]);
                if (rotX != 0 || rotY != 0 || rotZ != 0) {
                    posBL.sub(0.5, 0.5, 0.5).rotateX((double)rotX * 1.5707963267948966).rotateY((double)rotY * 1.5707963267948966).rotateZ((double)rotZ * 1.5707963267948966).add(0.5, 0.5, 0.5);
                }
                Vector2fc uvsBL = element.vertexUvs[offset + 1];
                if (uvlock) {
                    uvsBL = this.rotateUV(uvsBL, rotX, rotY, rotZ, element.directions[face], this.vertUV);
                }
                tessellator.setColorOpaque3f(colorRedBottomLeft, colorGreenBottomLeft, colorBlueBottomLeft);
                tessellator.setLightmapCoord1i(lightIndexBottomLeft);
                tessellator.setShade1i((int)(lbl * 255.0f));
                tessellator.addVertexWithUV(posBL.x() + (double)blockPos.x() + xOff, posBL.y() + (double)blockPos.y() + yOff, posBL.z() + (double)blockPos.z() + zOff, coordinate.getSubIconU(uvsBL.x()), coordinate.getSubIconV(uvsBL.y()));
                Vector3d posBR = this.vertPos.set(element.vertexPoses[offset + 2]);
                if (rotX != 0 || rotY != 0 || rotZ != 0) {
                    posBR.sub(0.5, 0.5, 0.5).rotateX((double)rotX * 1.5707963267948966).rotateY((double)rotY * 1.5707963267948966).rotateZ((double)rotZ * 1.5707963267948966).add(0.5, 0.5, 0.5);
                }
                Vector2fc uvsBR = element.vertexUvs[offset + 2];
                if (uvlock) {
                    uvsBR = this.rotateUV(uvsBR, rotX, rotY, rotZ, element.directions[face], this.vertUV);
                }
                tessellator.setColorOpaque3f(colorRedBottomRight, colorGreenBottomRight, colorBlueBottomRight);
                tessellator.setLightmapCoord1i(lightIndexBottomRight);
                tessellator.setShade1i((int)(lbr * 255.0f));
                tessellator.addVertexWithUV(posBR.x() + (double)blockPos.x() + xOff, posBR.y() + (double)blockPos.y() + yOff, posBR.z() + (double)blockPos.z() + zOff, coordinate.getSubIconU(uvsBR.x()), coordinate.getSubIconV(uvsBR.y()));
                Vector3d posTR = this.vertPos.set(element.vertexPoses[offset + 3]);
                if (rotX != 0 || rotY != 0 || rotZ != 0) {
                    posTR.sub(0.5, 0.5, 0.5).rotateX((double)rotX * 1.5707963267948966).rotateY((double)rotY * 1.5707963267948966).rotateZ((double)rotZ * 1.5707963267948966).add(0.5, 0.5, 0.5);
                }
                Vector2fc uvsTR = element.vertexUvs[offset + 3];
                if (uvlock) {
                    uvsTR = this.rotateUV(uvsTR, rotX, rotY, rotZ, element.directions[face], this.vertUV);
                }
                tessellator.setColorOpaque3f(colorRedTopRight, colorGreenTopRight, colorBlueTopRight);
                tessellator.setLightmapCoord1i(lightIndexTopRight);
                tessellator.setShade1i((int)(ltr * 255.0f));
                tessellator.addVertexWithUV(posTR.x() + (double)blockPos.x() + xOff, posTR.y() + (double)blockPos.y() + yOff, posTR.z() + (double)blockPos.z() + zOff, coordinate.getSubIconU(uvsTR.x()), coordinate.getSubIconV(uvsTR.y()));
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                didRender = true;
            }
        }
        return didRender;
    }

    @NotNull
    public Vector2f rotateUV(@NotNull Vector2fc uvs, int rotX, int rotY, int rotZ, @NotNull Direction srcDirection, @NotNull Vector2f dest) {
        float _v;
        float _u;
        Direction dir = srcDirection;
        float u = uvs.x() - 0.5f;
        float v = uvs.y() - 0.5f;
        rotX &= 3;
        while (rotX > 0) {
            if (dir.getAxis() == Axis.X) {
                if (dir == Direction.WEST) {
                    _u = u;
                    u = -v;
                    v = _u;
                } else {
                    _u = u;
                    u = v;
                    v = -_u;
                }
            } else if (dir == Direction.NORTH || dir == Direction.DOWN) {
                v = -v;
                u = -u;
            }
            dir = Direction.rotateX(dir, 1);
            --rotX;
        }
        rotY &= 3;
        while (rotY > 0) {
            if (dir.getAxis() == Axis.Y) {
                if (dir == Direction.DOWN) {
                    _v = v;
                    v = u;
                    u = -_v;
                } else {
                    _u = u;
                    u = v;
                    v = -_u;
                }
            }
            dir = Direction.rotateY(dir, 1);
            --rotY;
        }
        rotZ &= 3;
        while (rotZ > 0) {
            if (dir.getAxis() == Axis.Z) {
                if (dir == Direction.NORTH) {
                    _u = u;
                    u = -v;
                    v = _u;
                } else {
                    _u = u;
                    u = v;
                    v = -_u;
                }
            } else if (dir == Direction.DOWN || dir == Direction.UP || dir == Direction.WEST || dir == Direction.EAST) {
                _v = v;
                v = -u;
                u = _v;
            }
            dir = Direction.rotateZ(dir, 1);
            --rotZ;
        }
        return dest.set(u + 0.5f, v + 0.5f);
    }

    @Override
    @Nullable
    public IconCoordinate getOverlay() {
        return this.compiled.textures.get("#overlay");
    }

    @Override
    @Nullable
    public IconCoordinate getParticle(@NotNull Side side) {
        return this.compiled.textures.get("#particle_" + side.getDirection().name().toLowerCase(Locale.ROOT));
    }

    @Override
    public int particleColorIndex(@NotNull Side side) {
        return this.compiled.particleIndices[side.getId()];
    }

    @Override
    public int renderLayer() {
        return this.compiled.renderLayer;
    }

    @Override
    @NotNull
    public DisplayPos getItemDisplayPos(@NotNull String id) {
        return this.compiled.displayPosMap.getOrDefault(id, DisplayPos.DEFAULT_DISPLAY_POS);
    }

    protected float getBrightness(int relX, int relY, int relZ, float min) {
        return java.lang.Math.max(LIGHTING_CACHE.getBrightness(relX, relY, relZ), min);
    }

    protected byte getLightIndex(int relX, int relY, int relZ, int min) {
        byte coord = LIGHTING_CACHE.getLightIndex(relX, relY, relZ);
        int block = LightIndexHelper.blockLightFromIndex(coord);
        if (block < min) {
            coord = LightIndexHelper.setBlockLight(coord, min);
        }
        return coord;
    }
}

