/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.models.entity.mojang;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.client.render.uniform.UniformBlockManager;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.LightIndexHelper;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;
import org.useless.dragonfly.data.entity.mojang.Bone;
import org.useless.dragonfly.data.entity.mojang.Cube;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;
import org.useless.dragonfly.data.entity.mojang.Face;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class StaticEntityModelMojang
implements StaticEntityModel {
    public static final int MAX_BONES = 128;
    private static final BoneTransform DUMMY_TRANSFORM = new BoneTransform();
    private static final TessellatorEntity entityTessellator = new TessellatorEntity(16384);
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull BoneTransform> transformMap = new Object2ObjectOpenHashMap<String, BoneTransform>();
    @NotNull
    public final @NotNull BoneTransform @NotNull [] transforms;
    @NotNull
    public final @NotNull BoneEntry @NotNull [] bones;
    public final EntityGeometryMojangData data;
    public final double inflation;
    @NotNull
    protected final AABBd visBounds;
    @NotNull
    private final RenderBuffer renderBuffer;
    private static final Matrix4f hiddenMat = new Matrix4f().set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    @NotNull
    private static final Matrix4f mat = new Matrix4f();
    private final double[] uvsBuffer = new double[8];
    @NotNull
    private static final Vector3d q = new Vector3d();

    public StaticEntityModelMojang(@NotNull EntityGeometryMojangData data, double inflation) {
        this.data = data;
        this.transforms = new BoneTransform[this.data.bones.size()];
        this.bones = new BoneEntry[this.data.bones.size()];
        this.inflation = inflation;
        int i = 0;
        for (Map.Entry<String, Bone> entry : this.data.bones.entrySet()) {
            BoneTransform transform = new BoneTransform();
            this.transformMap.put(entry.getKey(), transform);
            this.transforms[i] = transform;
            this.bones[i] = new BoneEntry(entry.getValue(), i);
            ++i;
        }
        this.visBounds = new AABBd(this.data.vBoundsOffset[0] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] - this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[0] + this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] + this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] + this.data.vBoundsWidth / 2.0);
        entityTessellator.startDrawingQuads();
        for (BoneEntry bone : this.bones) {
            this.renderBone(entityTessellator, bone);
        }
        this.renderBuffer = entityTessellator.record(GL41.glGenVertexArrays(), GL41.glGenBuffers());
    }

    @Override
    public void resetBones() {
        for (int i = 0; i < this.transforms.length; ++i) {
            this.transforms[i].reset();
        }
    }

    @Override
    @NotNull
    public BoneTransform getTransform(@NotNull String boneId) {
        return this.transformMap.getOrDefault(boneId, DUMMY_TRANSFORM);
    }

    @Override
    @NotNull
    public AABBdc visibleBounds() {
        return this.visBounds;
    }

    @Override
    public void translateToBone(@NotNull String boneId) {
        Bone bone = this.data.bones.get(boneId);
        if (bone == null) {
            return;
        }
        this.boneTransform(bone, mat.identity());
        GLRenderer.modelM4f().mul(mat);
        GLRenderer.modelM4f().translate((float)bone.pivot[0], (float)bone.pivot[1], (float)bone.pivot[2]);
    }

    @Override
    public void render() {
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.ENTITY);
        GLRenderer.globalSetUniforms(Shaders.ENTITY);
        Shaders.ENTITY.uniformVec2f("uLightmap", ((float)LightIndexHelper.blockLightFromIndex(GLRenderer.getLightIndex()) + 0.5f) / 16.0f, ((float)LightIndexHelper.skyLightFromIndex(GLRenderer.getLightIndex()) + 0.5f) / 16.0f);
        GL41.glBindBuffer(35345, UniformBlockManager.BLOCK_ENTITY_BONES.ubo);
        UniformBlockManager.BLOCK_ENTITY_BONES.buffer.clear();
        int i = 0;
        for (BoneEntry entry : this.bones) {
            if (this.boneTransform(entry.bone(), mat.identity())) {
                UniformBlockManager.BLOCK_ENTITY_BONES.adapter.bufferData(hiddenMat, entry.index() * 16 * 4, UniformBlockManager.BLOCK_ENTITY_BONES.buffer);
            } else {
                UniformBlockManager.BLOCK_ENTITY_BONES.adapter.bufferData(mat, entry.index() * 16 * 4, UniformBlockManager.BLOCK_ENTITY_BONES.buffer);
            }
            ++i;
        }
        GL41.glBufferSubData(35345, 0L, UniformBlockManager.BLOCK_ENTITY_BONES.buffer.limit(i * 16 * 4));
        GL41.glBindBuffer(35345, 0);
        GL41.glBindVertexArray(this.renderBuffer.vao());
        GL41.glBindBuffer(34962, this.renderBuffer.vbo());
        GL41.glDrawArrays(this.renderBuffer.drawMode().cap, this.renderBuffer.offset(), this.renderBuffer.count());
        GL41.glBindVertexArray(0);
        GLRenderer.popFrame();
    }

    @Override
    public void delete() {
        this.renderBuffer.delete();
    }

    protected boolean boneTransform(@NotNull Bone bone, @NotNull Matrix4f dest) {
        Bone parent;
        boolean hidden = false;
        Bone bone2 = parent = bone.parent != null ? this.data.bones.get(bone.parent) : null;
        if (parent != null) {
            hidden |= this.boneTransform(parent, dest);
        }
        BoneTransform transform = this.transformMap.get(bone.name);
        hidden |= !transform.visible;
        dest.translate((float)bone.pivot[0], (float)bone.pivot[1], (float)bone.pivot[2]);
        dest.translate((float)transform.posX, (float)transform.posY, (float)transform.posZ);
        dest.rotateZ((float)(-transform.rotZ - Math.toRadians(bone.rotation[2])));
        dest.rotateY((float)(transform.rotY + Math.toRadians(bone.rotation[1])));
        dest.rotateX((float)(-transform.rotX - Math.toRadians(bone.rotation[0])));
        dest.translate((float)(-bone.pivot[0]), (float)(-bone.pivot[1]), (float)(-bone.pivot[2]));
        dest.scale((float)transform.scaleX, (float)transform.scaleY, (float)transform.scaleZ);
        return hidden;
    }

    protected void renderBone(@NotNull TessellatorEntity tessellator, @NotNull BoneEntry entry) {
        tessellator.setBone(entry.index());
        Bone bone = entry.bone();
        for (Cube cube : bone.cubes) {
            double vMax;
            double vMin;
            double uMax;
            double uMin;
            double minX = cube.origin[0] - (cube.inflate + bone.inflate + this.inflation);
            double minY = cube.origin[1] - (cube.inflate + bone.inflate + this.inflation);
            double minZ = cube.origin[2] - (cube.inflate + bone.inflate + this.inflation);
            double maxX = minX + cube.size[0] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxY = minY + cube.size[1] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxZ = minZ + cube.size[2] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            Face face = cube.faces[Direction.UP.getId()];
            if (face != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMin;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMax;
                this.uvsBuffer[1] = vMin;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMax;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, 1.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.DOWN.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, -1.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.NORTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, 0.0, -1.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.SOUTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(0.0, 0.0, 1.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.WEST.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(1.0, 0.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.EAST.getId()]) == null) continue;
            uMin = face.uv[0] / (double)this.data.textureWidth;
            uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
            vMin = face.uv[1] / (double)this.data.textureHeight;
            vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
            this.uvsBuffer[0] = uMin;
            this.uvsBuffer[2] = uMax;
            this.uvsBuffer[4] = uMax;
            this.uvsBuffer[6] = uMin;
            this.uvsBuffer[1] = vMax;
            this.uvsBuffer[3] = vMax;
            this.uvsBuffer[5] = vMin;
            this.uvsBuffer[7] = vMin;
            tessellator.setNormal(-1.0, 0.0, 0.0);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
        }
    }

    protected static void addRotatedVertex(@NotNull TessellatorEntity tessellator, double x, double y, double z, double u, double v, @NotNull Vector3dc pivot, @Nullable Vector3dc rotation) {
        if (rotation == null) {
            tessellator.addVertexWithUV(x, y, z, u, v);
        } else {
            q.set(x, y, z).sub(pivot).rotateX(-rotation.x() * (double)MathHelper.DEG_TO_RAD).rotateY(-rotation.y() * (double)MathHelper.DEG_TO_RAD).rotateZ(-rotation.z() * (double)MathHelper.DEG_TO_RAD).add(pivot);
            tessellator.addVertexWithUV(q, u, v);
        }
    }

    public record BoneEntry(@NotNull Bone bone, int index) {
    }

    public static class TessellatorEntity {
        private static final Logger LOGGER = LogUtils.getLogger();
        private static final int VERT_SIZE = 27;
        public ByteBuffer data;
        public boolean drawing;
        public int boneIndex = 0;
        public byte normalX = 0;
        public byte normalY = (byte)-128;
        public byte normalZ = 0;
        public final int vao;
        public final int vbo;
        public int vertexCount = 0;
        private int quadVertCount = 0;

        public TessellatorEntity(int capacity) {
            this.data = BufferUtils.createByteBuffer(capacity);
            this.vao = GL41.glGenVertexArrays();
            this.vbo = GL41.glGenBuffers();
            this.enable(this.vao, this.vbo);
        }

        public void startDrawingQuads() {
            if (this.drawing) {
                this.drawing = false;
                throw new IllegalStateException("Entity Tessellator already drawing!");
            }
            this.normalX = 0;
            this.normalY = (byte)-128;
            this.normalZ = 0;
            this.vertexCount = 0;
            this.quadVertCount = 0;
            this.drawing = true;
            this.data.clear();
        }

        public void addVertexWithUV(@NotNull Vector3dc pos, double u, double v) {
            this.addVertexWithUV(pos.x(), pos.y(), pos.z(), u, v);
        }

        public void addVertexWithUV(double x, double y, double z, double u, double v) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator not drawing!");
            }
            this.checkCanFit(64);
            this.data.putFloat((float)x).putFloat((float)y).putFloat((float)z);
            this.data.putFloat((float)u).putFloat((float)v);
            this.data.put(this.normalX).put(this.normalY).put(this.normalZ);
            this.data.putFloat((float)this.boneIndex + 0.05f);
            ++this.vertexCount;
            if (this.quadVertCount % 4 == 2) {
                this.checkCanFit(128);
                this.data.put(this.data.position(), this.data, this.data.position() - 81, 27);
                this.data.put(this.data.position() + 27, this.data, this.data.position() - 27, 27);
                this.data.position(this.data.position() + 54);
                this.vertexCount += 2;
            }
            ++this.quadVertCount;
        }

        public void checkCanFit(int size) {
            if (this.data.capacity() < this.data.position() + size) {
                int newSize = this.data.capacity() * 2;
                LOGGER.info("Expanding {} Buffer ({} -> {})", "Entity Tessellator", this.data.capacity(), newSize);
                ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
                this.data.flip();
                newBuffer.put(this.data);
                this.data = newBuffer;
            }
        }

        public void setBone(int boneIndex) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator not drawing!");
            }
            this.boneIndex = (byte)boneIndex;
        }

        public void setNormal(double x, double y, double z) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator not drawing!");
            }
            this.normalX = (byte)(x * 127.0);
            this.normalY = (byte)(y * 127.0);
            this.normalZ = (byte)(z * 127.0);
        }

        @NotNull
        public RenderBuffer record(int vao, int vbo) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator not drawing!");
            }
            this.drawing = false;
            this.enable(vao, vbo);
            GL41.glBufferData(34962, this.data.flip(), 35044);
            GL41.glBindVertexArray(0);
            return new RenderBuffer(vao, vbo, 0, this.vertexCount, DrawMode.TRIANGLES);
        }

        public void enable(int vao, int vbo) {
            GL41.glBindVertexArray(vao);
            GL41.glBindBuffer(34962, vbo);
            GL41.glVertexAttribPointer(0, 3, 5126, false, 27, 0L);
            GL41.glVertexAttribPointer(1, 2, 5126, false, 27, 12L);
            GL41.glVertexAttribPointer(2, 3, 5120, true, 27, 20L);
            GL41.glVertexAttribPointer(3, 1, 5126, false, 27, 23L);
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glEnableVertexAttribArray(2);
            GL41.glEnableVertexAttribArray(3);
        }
    }
}

