/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.worldsettings.ScreenWorldSettings;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;

public class ScreenCreateWorld
extends Screen {
    @NotNull
    public static final @NotNull List<@NotNull Gamemode> GAMEMODES = new ArrayList<Gamemode>();
    private TextFieldElement textboxWorldName;
    private TextFieldElement textboxSeed;
    private ButtonElement createWorldButton;
    private ButtonElement gamemodeButton;
    private ButtonElement cheatsButton;
    private ButtonElement worldSettingsButton;
    private ButtonElement buttonRandomWorldName;
    private ButtonElement buttonRandomSeed;
    private boolean createClicked;
    private final WorldConfiguration worldConfiguration = new WorldConfiguration();

    public ScreenCreateWorld(Screen parent) {
        super(parent);
    }

    @Override
    public void tick() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        Keyboard.enableRepeatEvents(true);
        this.buttons.clear();
        this.createWorldButton = new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 104 + 12, i18n.translateKey("gui.create_world.button.create_new_world"));
        this.buttons.add(this.createWorldButton);
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, this.height / 4 + 128 + 12, i18n.translateKey("gui.create_world.button.cancel")));
        this.textboxWorldName = new TextFieldElement(this, this.fontRenderer, this.width / 2 - 100, 60, 176, 20, "", i18n.translateKey("gui.create_world.label.new_world"));
        this.textboxWorldName.setMaxStringLength(32);
        this.textboxSeed = new TextFieldElement(this, this.fontRenderer, this.width / 2 - 100, 100, 176, 20, "", Long.toString(this.worldConfiguration.getNumericSeed()));
        this.gamemodeButton = new ButtonElement(2, this.width / 2 - 100, 124, 98, 20, "");
        this.buttons.add(this.gamemodeButton);
        this.cheatsButton = new ButtonElement(3, this.width / 2 - 100 + 102, 124, 98, 20, "");
        this.buttons.add(this.cheatsButton);
        this.worldSettingsButton = new ButtonElement(4, this.width / 2 - 100, 148, i18n.translateKey("gui.create_world.button.world_settings"));
        this.buttons.add(this.worldSettingsButton);
        this.buttonRandomWorldName = new ButtonElement(5, this.width / 2 + 100 - 20, 60, 20, 20, "").setTextures("minecraft:gui/misc/button_random", "minecraft:gui/misc/button_random_highlighted", "minecraft:gui/misc/button_random");
        this.buttons.add(this.buttonRandomWorldName);
        this.buttonRandomSeed = new ButtonElement(6, this.width / 2 + 100 - 20, 100, 20, 20, "").setTextures("minecraft:gui/misc/button_random", "minecraft:gui/misc/button_random_highlighted", "minecraft:gui/misc/button_random");
        this.buttons.add(this.buttonRandomSeed);
        this.syncButtons();
    }

    @Override
    public void removed() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayScreen(this.parentScreen);
        } else if (button.id == 0) {
            this.mc.displayScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            this.mc.createAndStartWorld(this.worldConfiguration);
            this.mc.displayScreen(null);
        } else if (button == this.gamemodeButton) {
            this.worldConfiguration.setGamemode(GAMEMODES.get((GAMEMODES.indexOf(this.worldConfiguration.getGamemode()) + 1) % GAMEMODES.size()));
            this.worldConfiguration.setCheatsEnabled(this.worldConfiguration.getGamemode() == Gamemodes.CREATIVE);
            this.syncButtons();
        } else if (button == this.cheatsButton) {
            this.worldConfiguration.setCheatsEnabled(!this.worldConfiguration.getCheatsEnabled());
            this.syncButtons();
        } else if (button == this.worldSettingsButton) {
            this.mc.displayScreen(new ScreenWorldSettings(this, this.worldConfiguration));
        } else if (button == this.buttonRandomWorldName) {
            this.textboxWorldName.setText(I18n.getInstance().getCurrentLanguage().getRandomWorldName());
            this.syncConfig();
        } else if (button == this.buttonRandomSeed) {
            this.worldConfiguration.regenNumericSeed();
            this.textboxSeed.setPlaceholder(Long.toString(this.worldConfiguration.getNumericSeed()));
            this.textboxSeed.setText("");
            this.syncConfig();
        }
    }

    private void syncButtons() {
        I18n i18n = I18n.getInstance();
        this.textboxWorldName.setText(this.worldConfiguration.getWorldName());
        this.textboxSeed.setText(this.worldConfiguration.getStringSeed());
        this.gamemodeButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.gamemode", i18n.translateKey(this.worldConfiguration.getGamemode().getLanguageKey() + ".name"));
        this.cheatsButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.cheats", i18n.translateKey(this.worldConfiguration.getCheatsEnabled() ? "gui.create_world.button.cheats.on" : "gui.create_world.button.cheats.off"));
    }

    private void syncConfig() {
        this.worldConfiguration.setWorldName(this.textboxWorldName.getText());
        this.worldConfiguration.setStringSeed(this.textboxSeed.getText());
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey != Keyboard.KEY_BACK) {
            super.keyPressed(eventCharacter, eventKey, mx, my);
        }
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.textboxKeyTyped(eventCharacter, eventKey);
            this.syncConfig();
        } else if (this.textboxSeed.isFocused) {
            this.textboxSeed.textboxKeyTyped(eventCharacter, eventKey);
            this.syncConfig();
        }
        if (eventCharacter == '\r') {
            this.buttonClicked((ButtonElement)this.buttons.get(0));
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        this.textboxWorldName.mouseClicked(mx, my, buttonNum);
        this.textboxSeed.mouseClicked(mx, my, buttonNum);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKey("gui.create_world.label.title"), this.width / 2, 20, 0xFFFFFF);
        this.drawStringShadow(this.fontRenderer, i18n.translateKey("gui.create_world.label.world_name"), this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawStringShadow(this.fontRenderer, i18n.translateKey("gui.create_world.label.seed"), this.width / 2 - 100, 88, 0xA0A0A0);
        this.textboxWorldName.drawTextBox();
        this.textboxWorldName.updateCursor(this.mc, mx, my);
        this.textboxSeed.drawTextBox();
        this.textboxSeed.updateCursor(this.mc, mx, my);
        super.render(mx, my, partialTick);
    }

    @Override
    public void selectNextField() {
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.setFocused(false);
            this.textboxSeed.setFocused(true);
        } else {
            this.textboxWorldName.setFocused(true);
            this.textboxSeed.setFocused(false);
        }
    }

    static {
        GAMEMODES.add(Gamemodes.SURVIVAL);
        GAMEMODES.add(Gamemodes.CREATIVE);
        GAMEMODES.add(Gamemodes.HARDCORE);
        GAMEMODES.add(Gamemodes.ADVENTURE);
    }
}

