/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGeneric;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.data.block.BlockModelData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericPlanksPainted<T extends BlockLogic>
extends BlockModelGeneric<T> {
    public static final IconCoordinate[] texCoords = new IconCoordinate[16];
    public final StaticBlockModel[] models = new StaticBlockModel[16];

    public BlockModelGenericPlanksPainted(@NotNull Block<T> block, @NotNull StaticBlockModel staticModel) {
        super(block, staticModel);
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.models[c.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/planks/" + c.colorID).asModel();
        }
    }

    public BlockModelGenericPlanksPainted(@NotNull Block<T> block, @NotNull BlockModelData staticModel) {
        super(block, staticModel);
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.models[c.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/planks/" + c.colorID).asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        return this.models[data & 0xF];
    }

    static {
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            BlockModelGenericPlanksPainted.texCoords[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/planks/" + c.colorID);
        }
    }
}

