/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.font;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.font.FontFile;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

public class FontDefault
extends FontFile {
    public FontDefault(@NotNull String key) {
        super(key, "/assets/minecraft/textures/gui/font/default/font_%02X.png", "/assets/minecraft/textures/gui/font/default/glyph_sizes.bin");
    }

    @Override
    public boolean canRenderChar(char c) {
        return c == ' ' || !DEFAULT_BLACKLIST.contains(Character.valueOf(c)) && ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0 && this.textureForChar(c) != 0;
    }

    @Override
    public int textureForChar(char c) {
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0;
        }
        int index = fontIndex / 256;
        if (this.texHandleCache[index] != -1) {
            return this.texHandleCache[index];
        }
        Texture texture = Minecraft.getMinecraft().textureManager.loadTextureNoDefault(String.format(this.textureFormat, index));
        if (texture == null) {
            this.texHandleCache[index] = 0;
            return 0;
        }
        this.texHandleCache[index] = texture.id();
        return texture.id();
    }

    @Override
    public double charWidthDouble(char c) {
        if (c == ' ') {
            return 4.0;
        }
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0.0;
        }
        int upper = this.charWidth[fontIndex] >> 4;
        int lower = this.charWidth[fontIndex] & 0xF;
        double fUpper = upper;
        double fLower = lower + 1;
        return (fLower - fUpper) / 2.0 + 1.0;
    }

    @Override
    public double renderChar(TessellatorFont tessellator, char c, double x, double y, double z, boolean italics) {
        if (c == ' ') {
            return 4.0;
        }
        int fontIndex = ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c);
        if (fontIndex < 0) {
            return 0.0;
        }
        boolean shift = italics;
        int lower = this.charWidth[fontIndex] & 0xF;
        int fLower = lower + 1;
        int upper = this.charWidth[fontIndex] >> 4;
        int fUpper = upper;
        if (fLower - fUpper == 0) {
            return 0.0;
        }
        int u = fontIndex % 16 * 16 + fUpper;
        int v = (fontIndex & 0xFF) / 16 * 16;
        int uWidth = fLower - fUpper;
        int vHeight = 16;
        double width = (double)uWidth / 2.0;
        double height = 8.0;
        tessellator.addChar(x, y, width, 8.0, (double)shift, u, v, uWidth, 16.0);
        return (double)(fLower - fUpper) / 2.0 + 1.0;
    }
}

