/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySensor;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMotionSensor
extends BlockLogicVeryRotatable {
    public final boolean isActive;

    public BlockLogicMotionSensor(@NotNull Block<?> block, boolean isActive) {
        super(block, Materials.GLASS);
        this.isActive = isActive;
        block.withEntity(TileEntitySensor::new);
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isActive) {
            return;
        }
        TilePos queryPos = new TilePos();
        int brightness = 10;
        double d = 0.0625;
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            double px = (double)tilePos.x() + (double)rand.nextFloat();
            double py = (double)tilePos.y() + (double)rand.nextFloat();
            double pz = (double)tilePos.z() + (double)rand.nextFloat();
            if (!world.isBlockOpaqueCube(tilePos.add(dir, queryPos))) {
                switch (dir) {
                    case UP: {
                        py = (double)(tilePos.y() + 1) + d;
                        break;
                    }
                    case DOWN: {
                        py = (double)tilePos.y() - d;
                        break;
                    }
                    case SOUTH: {
                        pz = (double)(tilePos.z() + 1) + d;
                        break;
                    }
                    case NORTH: {
                        pz = (double)tilePos.z() - d;
                        break;
                    }
                    case EAST: {
                        px = (double)(tilePos.x() + 1) + d;
                        break;
                    }
                    case WEST: {
                        px = (double)tilePos.x() - d;
                    }
                }
            }
            if (!(px < (double)tilePos.x() || px > (double)(tilePos.x() + 1) || py < 0.0 || py > (double)(tilePos.y() + 1) || pz < (double)tilePos.z()) && !(pz > (double)(tilePos.z() + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isEmittingSignal(world, tilePos, side);
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isActive;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.IMPROPER_TOOL) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Blocks.MOTION_SENSOR_IDLE)};
    }
}

