#version 410 core
layout (location = 0) in vec2 aPos;
layout (location = 1) in vec2 aSize;
layout (location = 2) in float aShift;
layout (location = 3) in vec4 aColor;
layout (location = 4) in vec2 aUv;
layout (location = 5) in vec2 aUvSizes;
layout (location = 6) in float aLightmap;

out VS_OUT {
    vec2 size;
    float shift;
    vec4 color;
    vec2 uv;
    vec2 uvSizes;
    vec2 lightmap;
} vs_out;

uniform float uZ;

vec2 unpackLightCoord() {
    int asInt = int(aLightmap);
    return vec2(((asInt & 0xF) + 0.5)/16.0, (((asInt & 0xF0) >> 4) + 0.5)/16.0);
}

void main() {
    gl_Position = vec4(aPos, uZ, 1);

    vs_out.size = aSize;
    vs_out.shift = aShift;
    vs_out.color = aColor;
    vs_out.uv = aUv/256.0;
    vs_out.uvSizes = aUvSizes/256.0;
    vs_out.lightmap = unpackLightCoord();
}
