#version 410
out vec4 FragColor;
in vec2 TexCoords;

uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float intensity;
uniform float width;
uniform float height;


vec3 getBlur(){
	vec3 blur = vec3(0.0);
	int q = 12;
	float qh = q / 2.0 - 0.5;
	float allStrengths = 0.0;
	
	vec2 pixel = vec2(1.0 / width, 1.0 / height);
	for(int i=0; i < q; i++){
		for(int j=0; j < q; j++){
			float strength = 1 - sin(length(vec2(i - qh, j - qh)) / qh);
			
			blur += texture(colortex0, TexCoords + vec2(i - qh, j - qh) * pixel).rgb * strength;
			
			allStrengths += strength;
		}
	}
	blur /= allStrengths;
	return blur;
}

void main()
{
	vec3 color = texture(colortex0, TexCoords).rgb;
	float depth = texture(depthtex0, TexCoords).r;

	depth = (depth - (0.45 + 0.1 * (1.0 - intensity))) * 20;

	vec3 blur = getBlur();
	color = mix(color, blur, clamp(depth, 0.0, 1.0));
	
	//color = vec3(depth);
	//color = blur;
	
	FragColor = vec4(color, 1.0);
}