/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.data;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.NbtIo;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import net.betterthanadventure.utils.DataDumper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.enums.MusicFrequency;
import net.minecraft.client.gui.ScreenControllerSetup;
import net.minecraft.client.gui.ScreenFontTest;
import net.minecraft.client.gui.ScreenHudDesigner;
import net.minecraft.client.gui.ScreenSoundTest;
import net.minecraft.client.gui.ScreenTextureViewer;
import net.minecraft.client.gui.achievements.ScreenAchievements;
import net.minecraft.client.gui.modelviewer.ScreenModelViewer;
import net.minecraft.client.gui.nbteditor.ScreenNBTEditor;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.components.AvailableTexturePackListComponent;
import net.minecraft.client.gui.options.components.BooleanOptionComponent;
import net.minecraft.client.gui.options.components.DifficultyOptionComponent;
import net.minecraft.client.gui.options.components.FloatOptionComponent;
import net.minecraft.client.gui.options.components.FramerateOptionComponent;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.LanguagePackListComponent;
import net.minecraft.client.gui.options.components.OptionsCategory;
import net.minecraft.client.gui.options.components.SearchFieldComponent;
import net.minecraft.client.gui.options.components.SelectedTexturePackListComponent;
import net.minecraft.client.gui.options.components.ShortcutComponent;
import net.minecraft.client.gui.options.components.ToggleableOptionComponent;
import net.minecraft.client.gui.options.components.TooltipPickerComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageDebug;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.CloudQuality;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.option.enums.LeavesQuality;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.option.enums.MipmapType;
import net.minecraft.client.option.enums.ParticlesQuality;
import net.minecraft.client.option.enums.RenderScale;
import net.minecraft.client.option.enums.TextOutlineQuality;
import net.minecraft.client.option.enums.TextureAnimation;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.sound.SoundEngine;
import net.minecraft.client.util.helper.FileOpener;
import net.minecraft.client.util.helper.JavaProcess;
import net.minecraft.client.world.WorldClient;
import net.minecraft.client.world.chunk.provider.SelectedProvider;
import net.minecraft.core.Global;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.ChatVisibility;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.useless.seedviewer.SeedViewerMain;
import paulscode.sound.SoundSystem;

public abstract class OptionsPages {
    private static final Minecraft mc = Minecraft.getMinecraft();
    private static boolean hasInit = false;
    public static OptionsPage GENERAL;
    public static OptionsPage PLAYER;
    public static OptionsPage AUDIO;
    public static OptionsPage VIDEO;
    public static OptionsPage CONTROLS;
    public static OptionsPage ACCESSIBILITY;
    public static OptionsPage ASSET_PACKS;
    public static OptionsPage LANGUAGE;
    public static OptionsPage SEARCH;
    public static OptionsPage DEBUG;

    public static OptionsPage register(OptionsPage page) {
        OptionsPageRegistry.getInstance().register(page);
        return page;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        GENERAL = OptionsPages.register(new OptionsPage("gui.options.page.general.title", new ItemStack(Blocks.GRASS_RETRO)).withComponent(new OptionsCategory("gui.options.page.general.category.gameplay").withComponent(new FloatOptionComponent(GameSettings.FOV)).withComponent(new DifficultyOptionComponent(GameSettings.DIFFICULTY)).withComponent(new ToggleableOptionComponent<PlacementMode>(GameSettings.PLACEMENT_MODE)).withComponent(new BooleanOptionComponent(GameSettings.AUTO_HIT)).withComponent(new BooleanOptionComponent(GameSettings.EASY_BRIDGE)).withComponent(new BooleanOptionComponent(GameSettings.VIEW_BOBBING))).withComponent(new OptionsCategory("gui.options.page.general.category.user_interface").withComponent(new ShortcutComponent("gui.options.page.general.button.edit_hud", () -> mc.displayScreen(new ScreenHudDesigner(OptionsPages.mc.currentScreen)))).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.GUI_SCALE).applyOnRelease()).withComponent(new FloatOptionComponent(GameSettings.SCREEN_PADDING)).withComponent(new TooltipPickerComponent(GameSettings.TOOLTIP_STYLE)).withComponent(new ToggleableOptionComponent<Font>(GameSettings.FONT)).withComponent(new ToggleableOptionComponent<ChatVisibility>(GameSettings.chatVisibility)).withComponent(new BooleanOptionComponent(GameSettings.FPS_IN_OVERLAY)).withComponent(new BooleanOptionComponent(GameSettings.VERSION_IN_OVERLAY)).withComponent(new BooleanOptionComponent(GameSettings.FOOD_HEALTH_REGEN_OVERLAY)).withComponent(new BooleanOptionComponent(GameSettings.ARMOR_DURABILITY_OVERLAY)).withComponent(new BooleanOptionComponent(GameSettings.HELD_ITEM_COUNT_OVERLAY)).withComponent(new BooleanOptionComponent(GameSettings.HELD_ITEM_TOOLTIPS)).withComponent(new ToggleableOptionComponent<DescriptionPromptEnum>(GameSettings.ITEM_DESCRIPTIONS)).withComponent(new BooleanOptionComponent(GameSettings.HIDE_UNDISCOVERED_ITEMS)).withComponent(new BooleanOptionComponent(GameSettings.DYNAMIC_CURSOR)).withComponent(new BooleanOptionComponent(GameSettings.MUSIC_TOASTS))).withComponent(new OptionsCategory("gui.options.page.general.category.miscellaneous").withComponent(new BooleanOptionComponent(GameSettings.DISCORD_RICH_PRESENCE)).withComponent(new BooleanOptionComponent(GameSettings.ENABLE_ITEM_CLUMPING)).withComponent(new FloatOptionComponent(GameSettings.AUTOSAVE_TIMER))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_worlds_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "saves")))).withComponent(new ShortcutComponent("gui.options.page.general.button.open_screenshots_folder", () -> {
            File f = new File(mc.getMinecraftDir(), "screenshots");
            f.mkdirs();
            FileOpener.open(f);
        })));
        PLAYER = OptionsPages.register(new OptionsPage("gui.options.page.player.title", new ItemStack(Items.STATUE_STONE)).withComponent(new OptionsCategory("gui.options.page.player.category.player").withComponent(new BooleanOptionComponent(GameSettings.PLAYER_LEFT_HANDED)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_CAPE)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_HAT)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_JACKET)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_SLEEVE_LEFT)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_SLEEVE_RIGHT)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_PANT_LEFT)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_PANT_RIGHT)).withComponent(new ToggleableOptionComponent<Player.PlayerConfig.HurtSound>(GameSettings.PLAYER_HURT_SOUND))));
        AUDIO = OptionsPages.register(new OptionsPage("gui.options.page.audio.title", new ItemStack(Items.RECORD_CAT)).withComponent(new OptionsCategory("gui.options.page.audio.category.audio").withComponent(new BooleanOptionComponent(GameSettings.SUBTITLES)).withComponent(new ToggleableOptionComponent<MusicFrequency>(GameSettings.MUSIC_FREQUENCY)).withComponent(new BooleanOptionComponent(GameSettings.MUTE_ON_LOST_FOCUS)).withComponent(new BooleanOptionComponent(GameSettings.PLAY_TITLE_SCREEN_MUSIC)).withComponent(new FloatOptionComponent(GameSettings.MASTER_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.MUSIC_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.WORLD_SOUNDS_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.WEATHER_SOUNDS_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.ENTITY_SOUNDS_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.CAVE_SOUNDS_VOLUME)).withComponent(new FloatOptionComponent(GameSettings.GUI_SOUNDS_VOLUME))));
        VIDEO = OptionsPages.register(new OptionsPage("gui.options.page.video.title", new ItemStack(Items.FLAG)).withComponent(new OptionsCategory("gui.options.page.video.category.display").withComponent(new BooleanOptionComponent(GameSettings.FULLSCREEN)).withComponent(new BooleanOptionComponent(GameSettings.BORDERLESS_FULLSCREEN)).withComponent(new FloatOptionComponent(GameSettings.GAMMA)).withComponent(new BooleanOptionComponent(GameSettings.ENABLE_VSYNC)).withComponent(new FramerateOptionComponent(GameSettings.CUSTOM_FPS_LIMIT)).withComponent(new ToggleableOptionComponent<RenderScale>(GameSettings.RENDER_SCALE)).withComponent(new ToggleableOptionComponent<Colorblindness>(GameSettings.COLORBLINDNESS_FIX))).withComponent(new OptionsCategory("gui.options.page.video.category.visuals").withComponent(new BooleanOptionComponent(GameSettings.AMBIENT_OCCLUSION)).withComponent(new ToggleableOptionComponent<LightmapStyle>(GameSettings.LIGHTMAP_STYLE)).withComponent(new FloatOptionComponent(GameSettings.BRIGHTNESS)).withComponent(new BooleanOptionComponent(GameSettings.CONNECTED_GLASS)).withComponent(new BooleanOptionComponent(GameSettings.FOG)).withComponent(new BooleanOptionComponent(GameSettings.BIOME_WATER)).withComponent(new BooleanOptionComponent(GameSettings.CLOUDS)).withComponent(new FloatOptionComponent(GameSettings.CLOUD_HEIGHT, -0.5f, 1.0f)).withComponent(new BooleanOptionComponent(GameSettings.TREE_SHADOWS)).withComponent(new BooleanOptionComponent(GameSettings.VIGNETTE)).withComponent(new BooleanOptionComponent(GameSettings.ITEMS_3D)).withComponent(new BooleanOptionComponent(GameSettings.AURORA)).withComponent(new BooleanOptionComponent(GameSettings.SLIME_PARTICLES)).withComponent(new FloatOptionComponent(GameSettings.BLOCK_OUTLINE_WIDTH))).withComponent(new OptionsCategory("gui.options.page.video.category.post_processing").withComponent(new FloatOptionComponent(GameSettings.COLOR_CORRECTION)).withComponent(new FloatOptionComponent(GameSettings.FXAA)).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.BLOOM)).withComponent(new BooleanOptionComponent(GameSettings.HEAT_HAZE))).withComponent(new OptionsCategory("gui.options.page.video.category.performance").withComponent(new ToggleableOptionComponent<Integer>(GameSettings.RENDER_DISTANCE)).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.MIPMAP_LEVELS).applyOnRelease()).withComponent(new ToggleableOptionComponent<MipmapType>(GameSettings.MIPMAP_TYPE).applyOnRelease()).withComponent(new BooleanOptionComponent(GameSettings.TRANSPARENCY_DEPTH_CHECK)).withComponent(new BooleanOptionComponent(GameSettings.FRUSTUM_CULLING)).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.CHUNK_REBUILDS_PER_FRAME)).withComponent(new ToggleableOptionComponent<LeavesQuality>(GameSettings.LEAVES_QUALITY).applyOnRelease()).withComponent(new ToggleableOptionComponent<ParticlesQuality>(GameSettings.PARTICLES_QUALITY)).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.PARTICLES_CAP)).withComponent(new FloatOptionComponent(GameSettings.PARTICLE_RENDER_DISTANCE, 0.1f, 3.0f)).withComponent(new FloatOptionComponent(GameSettings.ENTITY_RENDER_DISTANCE, 0.1f, 3.0f)).withComponent(new BooleanOptionComponent(GameSettings.ENTITY_SHADOWS)).withComponent(new ToggleableOptionComponent<CloudQuality>(GameSettings.CLOUD_QUALITY)).withComponent(new ToggleableOptionComponent<TextOutlineQuality>(GameSettings.TEXT_OUTLINE_QUALITY))));
        CONTROLS = OptionsPages.register(new OptionsPage("gui.options.page.controls.title", new ItemStack(Items.BOAT)).withComponent(new OptionsCategory("gui.options.page.controls.category.mouse").withComponent(new FloatOptionComponent(GameSettings.MOUSE_SENSITIVITY)).withComponent(new BooleanOptionComponent(GameSettings.INVERT_MOUSE)).withComponent(new BooleanOptionComponent(GameSettings.RAW_MOUSE_INPUT)).withComponent(new BooleanOptionComponent(GameSettings.ENABLE_ITEM_DRAGGING)).withComponent(new BooleanOptionComponent(GameSettings.SMOOTH_CAMERA)).withComponent(new FloatOptionComponent(GameSettings.FLIGHT_SMOOTHNESS)).withComponent(new BooleanOptionComponent(GameSettings.TURN_WITH_VEHICLE))).withComponent(new OptionsCategory("gui.options.page.controls.category.keyboard").withComponent(new BooleanOptionComponent(GameSettings.SNEAK_TOGGLE)).withComponent(new BooleanOptionComponent(GameSettings.SWAP_CRAFTING_BUTTONS))).withComponent(new OptionsCategory("gui.options.page.controls.category.controller").withComponent(new ShortcutComponent("gui.options.page.controls.button.controller_setup", () -> mc.displayScreen(new ScreenControllerSetup(OptionsPages.mc.currentScreen)))).withComponent(new FloatOptionComponent(GameSettings.CONTROLLER_SENSITIVITY)).withComponent(new FloatOptionComponent(GameSettings.CONTROLLER_MENU_SENSITIVITY)).withComponent(new FloatOptionComponent(GameSettings.CONTROLLER_DEADZONE_LEFT)).withComponent(new FloatOptionComponent(GameSettings.CONTROLLER_DEADZONE_RIGHT)).withComponent(new BooleanOptionComponent(GameSettings.CONTROLLER_SWAP_SHOULDER_BUTTONS)).withComponent(new BooleanOptionComponent(GameSettings.CONTROLLER_SWAP_AB)).withComponent(new BooleanOptionComponent(GameSettings.CONTROLLER_SWAP_XY))).withComponent(new OptionsCategory("gui.options.page.controls.category.interactions").withComponent(new KeyBindingComponent(GameSettings.KEY_ATTACK)).withComponent(new KeyBindingComponent(GameSettings.KEY_INTERACT)).withComponent(new KeyBindingComponent(GameSettings.KEY_PICK_BLOCK))).withComponent(new OptionsCategory("gui.options.page.controls.category.movement").withComponent(new KeyBindingComponent(GameSettings.KEY_FORWARD)).withComponent(new KeyBindingComponent(GameSettings.KEY_BACK)).withComponent(new KeyBindingComponent(GameSettings.KEY_LEFT)).withComponent(new KeyBindingComponent(GameSettings.KEY_RIGHT)).withComponent(new KeyBindingComponent(GameSettings.KEY_JUMP)).withComponent(new KeyBindingComponent(GameSettings.KEY_SNEAK)).withComponent(new KeyBindingComponent(GameSettings.KEY_FLY)).withComponent(new KeyBindingComponent(GameSettings.KEY_AUTO_WALK)).withComponent(new KeyBindingComponent(GameSettings.KEY_EASY_BRIDGE)).withComponent(new KeyBindingComponent(GameSettings.KEY_SPRINT))).withComponent(new OptionsCategory("gui.options.page.controls.category.user_interface").withComponent(new BooleanOptionComponent(GameSettings.FORCE_ONSCREEN_KEYBOARD)).withComponent(new KeyBindingComponent(GameSettings.KEY_INVENTORY)).withComponent(new KeyBindingComponent(GameSettings.KEY_CHAT)).withComponent(new KeyBindingComponent(GameSettings.KEY_COMMAND)).withComponent(new KeyBindingComponent(GameSettings.KEY_GUIDEBOOK)).withComponent(new KeyBindingComponent(GameSettings.KEY_SHOW_RECIPE)).withComponent(new KeyBindingComponent(GameSettings.KEY_SHOW_USAGE)).withComponent(new KeyBindingComponent(GameSettings.KEY_DESCRIPTION)).withComponent(new KeyBindingComponent(GameSettings.KEY_OPEN_ACHIEVEMENTS)).withComponent(new KeyBindingComponent(GameSettings.KEY_OPEN_STATISTICS)).withComponent(new KeyBindingComponent(GameSettings.KEY_PLAYER_LIST)).withComponent(new KeyBindingComponent(GameSettings.KEY_HIDE_GUI)).withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_DEBUG)).withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_OVERLAY)).withComponent(new KeyBindingComponent(GameSettings.KEY_SORT_INVENTORY))).withComponent(new OptionsCategory("gui.options.page.controls.category.hotbar").withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_LEFT)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_RIGHT)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SWITCH)).withComponent(new KeyBindingComponent(GameSettings.KEY_DROP)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_1)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_2)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_3)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_4)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_5)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_6)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_7)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_8)).withComponent(new KeyBindingComponent(GameSettings.KEY_HOT_BAR_SLOT_9))).withComponent(new OptionsCategory("gui.options.page.controls.category.view").withComponent(new KeyBindingComponent(GameSettings.KEY_LOOK_LEFT)).withComponent(new KeyBindingComponent(GameSettings.KEY_LOOK_RIGHT)).withComponent(new KeyBindingComponent(GameSettings.KEY_LOOK_UP)).withComponent(new KeyBindingComponent(GameSettings.KEY_LOOK_DOWN)).withComponent(new KeyBindingComponent(GameSettings.KEY_CENTER_VIEW)).withComponent(new KeyBindingComponent(GameSettings.KEY_ZOOM)).withComponent(new KeyBindingComponent(GameSettings.KEY_CINEMATIC_CAMERA)).withComponent(new KeyBindingComponent(GameSettings.KEY_SWITCH_PERSPECTIVE)).withComponent(new KeyBindingComponent(GameSettings.KEY_PHOTO_MODE))).withComponent(new OptionsCategory("gui.options.page.controls.category.miscellaneous").withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_FOG)).withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_GAMMA)).withComponent(new KeyBindingComponent(GameSettings.KEY_LOCK_ROTATION)).withComponent(new KeyBindingComponent(GameSettings.KEY_SCREENSHOT)).withComponent(new KeyBindingComponent(GameSettings.KEY_SHOW_CONSOLE)).withComponent(new KeyBindingComponent(GameSettings.KEY_FULL_SCREEN))));
        ACCESSIBILITY = OptionsPages.register(new OptionsPage("gui.options.page.accessibility.title", new ItemStack(Items.WAND_MONSTER_SPAWNER)).withComponent(new OptionsCategory("gui.options.page.accessibility.category.accessibility").withComponent(new BooleanOptionComponent(GameSettings.SUBTITLES)).withComponent(new ToggleableOptionComponent<Integer>(GameSettings.GUI_SCALE).applyOnRelease()).withComponent(new FloatOptionComponent(GameSettings.SCREEN_PADDING)).withComponent(new BooleanOptionComponent(GameSettings.VIEW_BOBBING)).withComponent(new BooleanOptionComponent(GameSettings.FOV_MODIFICATION)).withComponent(new BooleanOptionComponent(GameSettings.SCREEN_MOTION_EFFECTS)).withComponent(new ToggleableOptionComponent<Colorblindness>(GameSettings.COLORBLINDNESS_FIX)).withComponent(new BooleanOptionComponent(GameSettings.TURN_WITH_VEHICLE))));
        ASSET_PACKS = OptionsPages.register(new OptionsPage("gui.options.page.asset_packs.title", new ItemStack(Items.PAINTING)).withComponent(new ShortcutComponent("gui.options.page.asset_packs.button.open_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "texturepacks")))).withComponent(new OptionsCategory("gui.options.page.asset_packs.category.textures").withComponent(new ToggleableOptionComponent<TextureAnimation>(GameSettings.TEXTURE_ANIMATIONS).applyOnRelease()).withComponent(new BooleanOptionComponent(GameSettings.CUSTOM_TEXTURE_ANIMATIONS)).withComponent(new BooleanOptionComponent(GameSettings.MOB_VARIANTS)).withComponent(new BooleanOptionComponent(GameSettings.CUSTOM_LIGHTMAP)).withComponent(new BooleanOptionComponent(GameSettings.ENABLE_HOLIDAY_TEXTURES))).withComponent(new ShortcutComponent("gui.options.page.asset_packs.button.apply", OptionsPages.mc.texturePackList::refreshIfReady)).withComponent(new OptionsCategory("gui.options.page.asset_packs.category.asset_packs.selected").withComponent(new SelectedTexturePackListComponent())).withComponent(new OptionsCategory("gui.options.page.asset_packs.category.asset_packs.available").withComponent(new AvailableTexturePackListComponent())));
        LANGUAGE = OptionsPages.register(new OptionsPage("gui.options.page.language_packs.title", new ItemStack(Items.BOOK)).withComponent(new ShortcutComponent("gui.options.page.language_packs.button.open_folder", () -> FileOpener.open(new File(mc.getMinecraftDir(), "languages")))).withComponent(new OptionsCategory("gui.options.page.language_packs.category.language_packs").withComponent(new LanguagePackListComponent())));
        SEARCH = OptionsPages.register(new OptionsPage("gui.options.page.search.title", new ItemStack(Blocks.GLASS)).withComponent(new SearchFieldComponent()));
        DEBUG = OptionsPages.register(new OptionsPageDebug("gui.options.page.debug.title", Blocks.BEDROCK.getDefaultStack()).withComponent(new OptionsCategory("gui.options.page.debug.category.controls").withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_TEXTURE_ATLAS)).withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_DEBUG)).withComponent(new KeyBindingComponent(GameSettings.KEY_SHOW_SHORTCUTS)).withComponent(new KeyBindingComponent(GameSettings.KEY_RELOAD)).withComponent(new KeyBindingComponent(GameSettings.KEY_SWITCH_GAMEMODE)).withComponent(new KeyBindingComponent(GameSettings.KEY_DUMP_TEXTURES)).withComponent(new KeyBindingComponent(GameSettings.KEY_FULLBRIGHT)).withComponent(new KeyBindingComponent(GameSettings.KEY_LIGHTMAPS)).withComponent(new KeyBindingComponent(GameSettings.KEY_COLLISION_BOXES)).withComponent(new KeyBindingComponent(GameSettings.KEY_CHUNK_BORDERS)).withComponent(new KeyBindingComponent(GameSettings.KEY_CLEAR_CHAT)).withComponent(new KeyBindingComponent(GameSettings.KEY_PAUSE_LOST_FOCUS)).withComponent(new KeyBindingComponent(GameSettings.KEY_TOGGLE_ITEM_INFO)).withComponent(new KeyBindingComponent(GameSettings.KEY_RELOAD_CHUNKS)).withComponent(new KeyBindingComponent(GameSettings.KEY_SMOOTH_LIGHTING)).withComponent(new KeyBindingComponent(GameSettings.KEY_RELEASE_CURSOR)).withComponent(new KeyBindingComponent(GameSettings.KEY_LOAD_CHUNKS_QUICKLY))).withComponent(new OptionsCategory("gui.options.page.debug.category.settings").withComponent(new BooleanOptionComponent(GameSettings.DEVELOPER_MODE)).withComponent(new BooleanOptionComponent(GameSettings.PLAYER_DEV_MODEL)).withComponent(new BooleanOptionComponent(GameSettings.VIEW_SUPPORT_MODE)).withComponent(new BooleanOptionComponent(GameSettings.ALPHA_MENU)).withComponent(new BooleanOptionComponent(GameSettings.LOCK_CAMERA)).withComponent(new BooleanOptionComponent(GameSettings.SHOW_DEBUG_SCREEN)).withComponent(new BooleanOptionComponent(GameSettings.SHOW_FRAME_TIMES)).withComponent(new BooleanOptionComponent(GameSettings.SHOW_CHUNK_BORDERS)).withComponent(new BooleanOptionComponent(GameSettings.SHOW_COLLISION_BOXES)).withComponent(new BooleanOptionComponent(GameSettings.SHOW_ITEM_DEBUG_INFO)).withComponent(new BooleanOptionComponent(GameSettings.DISABLE_CRASH_HANDLER)).withComponent(new BooleanOptionComponent(GameSettings.START_IN_FULLSCREEN)).withComponent(new BooleanOptionComponent(GameSettings.LOAD_ALL_SOUNDS)).withComponent(new BooleanOptionComponent(GameSettings.ALLOW_SOUND_OVERRIDES)).withComponent(new BooleanOptionComponent(GameSettings.DOWNLOAD_SOUNDFILES)).withComponent(new BooleanOptionComponent(GameSettings.ENABLE_DEV_RESOURCE_LOADING)).withComponent(new BooleanOptionComponent(GameSettings.DEV_MODELS)).withComponent(new ToggleableOptionComponent<SelectedProvider>(GameSettings.CHUNK_PROVIDER)).withComponent(new BooleanOptionComponent(GameSettings.DO_JCE_CHECK))).withComponent(new OptionsCategory("gui.options.page.debug.category.utility").withComponent(new ShortcutComponent("gui.options.page.debug.button.open.model_viewer", () -> {
            OptionsPages.mc.playerController = new PlayerControllerSP(mc);
            mc.changeWorld(WorldClient.EMPTY_WORLD, "Loading Model Viewer");
            mc.displayScreen(new ScreenModelViewer());
        }){

            @Override
            public void render(@NotNull ScreenOptions screenOptions, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.button.enabled = OptionsPages.mc.currentWorld == null;
                super.render(screenOptions, x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.sound_test", () -> mc.displayScreen(new ScreenSoundTest(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.texture_viewer", () -> mc.displayScreen(new ScreenTextureViewer(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.biome_finder", () -> {
            new Thread(() -> {
                try {
                    JavaProcess.exec(SeedViewerMain.class, Collections.emptyList());
                }
                catch (IOException | InterruptedException e) {
                    LogUtils.getLogger().error("", e);
                }
            }).start();
            Global.accessor = mc;
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.font_tester", () -> mc.displayScreen(new ScreenFontTest(OptionsPages.mc.currentScreen)))).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.nbt_tester", () -> {
            try {
                mc.displayScreen(new ScreenNBTEditor(OptionsPages.mc.currentScreen, "NBT Test", NbtIo.readCompressed(OptionsPages.class.getResourceAsStream("/debug/nbt/allTags_1_0_0.dat")), null));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.datadumper", () -> {
            DataDumper.main(new String[0]);
            FileOpener.open(new File(mc.getMinecraftDir(), "infodump"));
            Global.accessor = mc;
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.open.achievements", () -> mc.displayScreen(new ScreenAchievements(OptionsPages.mc.currentScreen, OptionsPages.mc.statsCounter))))).withComponent(new OptionsCategory("gui.options.page.debug.category.test").withComponent(new ShortcutComponent("gui.options.page.debug.button.music.skip", () -> {
            SoundSystem soundSystem = SoundEngine.getSoundSystem();
            if (soundSystem != null) {
                soundSystem.stop("BgMusic");
            }
            OptionsPages.mc.sndManager.ticksBeforeMusic = -1;
            OptionsPages.mc.sndManager.tick();
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.cheat", () -> OptionsPages.mc.currentWorld.getLevelData().setCheatsEnabled(true)){

            @Override
            public void render(@NotNull ScreenOptions screenOptions, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.button.enabled = OptionsPages.mc.currentWorld != null && !OptionsPages.mc.currentWorld.isClientSide;
                super.render(screenOptions, x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new ShortcutComponent("gui.options.page.debug.button.wipestats", () -> OptionsPages.mc.statsCounter.wipe("I want to delete all the saved stats"))).withComponent(new ShortcutComponent("gui.options.page.debug.button.unlockedall", () -> {
            for (Stat stat : StatList.getAllStats()) {
                OptionsPages.mc.thePlayer.addStat(stat, OptionsPages.mc.thePlayer.getStat(stat) == 0 ? 1 : 0);
            }
        }){

            @Override
            public void render(@NotNull ScreenOptions screenOptions, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
                this.button.enabled = OptionsPages.mc.thePlayer != null;
                super.render(screenOptions, x, y, width, relativeMouseX, relativeMouseY);
            }
        }).withComponent(new ShortcutComponent("gui.options.page.debug.button.crash.soft", () -> {
            throw new RuntimeException("Test Soft Exception");
        })).withComponent(new ShortcutComponent("gui.options.page.debug.button.garbage_collect", System::gc)).withComponent(new ShortcutComponent("gui.options.page.debug.button.reload_commands", () -> {
            if (Minecraft.getMinecraft().currentWorld != null) {
                Minecraft.getMinecraft().currentWorld.getCommandManager().reload();
            }
        }))));
    }
}

