/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.Minecraft;
import net.minecraft.client.option.Option;
import net.minecraft.core.lang.I18n;
import org.jetbrains.annotations.NotNull;

public class OptionFloat
extends Option<Float> {
    public OptionFloat(@NotNull String name, float value) {
        super(name, Float.valueOf(value));
    }

    public float get() {
        return ((Float)this.value).floatValue();
    }

    public boolean isFloat() {
        return true;
    }

    @Override
    public void fromOptionsString(@NotNull String string) {
        if (string.equalsIgnoreCase("true")) {
            this.value = Float.valueOf(1.0f);
            return;
        }
        if (string.equalsIgnoreCase("false")) {
            this.value = Float.valueOf(0.0f);
            return;
        }
        this.value = Float.valueOf(Float.parseFloat(string));
    }

    @Override
    @NotNull
    public String getDisplayString() {
        I18n i18n = I18n.getInstance();
        if (this.displayStringProvider != null) {
            return this.displayStringProvider.getDisplayString(Minecraft.getMinecraft(), I18n.getInstance(), this);
        }
        if (((Float)this.value).floatValue() == 0.0f) {
            return i18n.translateKey("options.off");
        }
        return (int)(((Float)this.value).floatValue() * 100.0f) + "%";
    }
}

