/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model.generic;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.generic.BlockModelGenericPressurePlate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class BlockModelGenericPressurePlatePainted<T extends BlockLogic>
extends BlockModelGenericPressurePlate<T> {
    @NotNull
    public final StaticBlockModel[] inventory = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] idle = new StaticBlockModel[16];
    @NotNull
    public final StaticBlockModel[] active = new StaticBlockModel[16];

    public BlockModelGenericPressurePlatePainted(@NotNull Block<T> block) {
        super(block, "minecraft:block/pressure_plate/planks/white");
        for (DyeColor color : DyeColor.blockOrderedColors()) {
            this.inventory[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/pressure_plate/planks/" + color.colorID + "/inventory").asModel();
            this.idle[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/pressure_plate/planks/" + color.colorID + "/idle").asModel();
            this.active[color.blockMeta] = BlockModelDispatcher.loadDataModel("minecraft:block/pressure_plate/planks/" + color.colorID + "/active").asModel();
        }
    }

    @Override
    @NotNull
    public StaticBlockModel getModel(@NotNull WorldSource source, @NotNull TilePosc tilePosc) {
        int data = source.getBlockData(tilePosc);
        int color = data >> 4 & 0xF;
        boolean pressed = (data & 1) != 0;
        return pressed ? this.active[color] : this.idle[color];
    }

    @Override
    @NotNull
    public StaticBlockModel getModelFromData(int data) {
        int color = data >> 4 & 0xF;
        return this.inventory[color];
    }
}

