/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.option.GameSettings;
import net.minecraft.client.option.enums.TextOutlineQuality;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.font.Font;
import net.minecraft.client.render.font.FontRendererDefault;
import net.minecraft.client.render.font.SF;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorFont;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSign;
import net.minecraft.core.block.BlockLogicSignPainted;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.primitives.AABBd;
import org.lwjgl.opengl.GL41;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class TileEntityRendererSign
extends TileEntityRenderer<TileEntitySign> {
    private FontRendererDefault fontRenderer = null;
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    private final String[] signColorTextures = new String[16];
    private final BufferedTextMeshRenderer textMeshRenderer = new BufferedTextMeshRenderer();

    public TileEntityRendererSign() {
        for (int i = 0; i < this.signColorTextures.length; ++i) {
            this.signColorTextures[i] = "/assets/minecraft/textures/entity/sign/" + DyeColor.colorFromBlockMeta((int)i).colorID + ".png";
        }
    }

    @Override
    public void doRender(@NotNull TessellatorGeneral t, @NotNull TileEntitySign tileEntity, double x, double y, double z, float partialTick) {
        int colorSign;
        float height;
        StaticEntityModel model;
        Object obj;
        Block<?> block = tileEntity.getBlock();
        if (block == null || !((obj = block.getLogic()) instanceof BlockLogicSign)) {
            return;
        }
        BlockLogicSign sign = (BlockLogicSign)obj;
        if (this.fontRenderer == null) {
            this.fontRenderer = new FontRendererDefault();
            this.fontRenderer.init();
        }
        GLRenderer.pushFrame();
        float scale = 0.041666668f;
        GLRenderer.modelM4f().translate((float)x + 0.5f, (float)y, (float)z + 0.5f);
        int meta = tileEntity.getBlockMeta();
        if (sign.isFreeStanding) {
            angle = (float)((meta & 0xF) * 360) / 16.0f;
            GLRenderer.modelM4f().rotateY(Math.toRadians(-angle));
            model = this.getModel("post");
            height = 20.0f;
        } else {
            angle = switch (meta & 0xF) {
                case 2 -> 180.0f;
                case 3 -> 0.0f;
                case 4 -> 90.0f;
                default -> -90.0f;
            };
            GLRenderer.modelM4f().rotateY(Math.toRadians(-angle));
            GLRenderer.modelM4f().translate(0.0f, 0.0f, -0.45833334f);
            model = this.getModel("wall");
            height = 13.0f;
        }
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().scale(0.041666668f, 0.041666668f, -0.041666668f);
        if (Block.hasLogicClass(block, BlockLogicSignPainted.class)) {
            DyeColor c = ((IPainted)block.getLogic()).fromMetadata(meta);
            this.bindTexture(this.signColorTextures[c.blockMeta]);
            colorSign = c.color.getARGB();
        } else {
            this.bindTexture("/assets/minecraft/textures/entity/sign.png");
            colorSign = 6905411;
        }
        GLRenderer.disableState(State.BLEND);
        model.render();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.popFrame();
        GLRenderer.pushFrame();
        GLRenderer.enableState(State.BLEND);
        GLRenderer.modelM4f().translate(0.0f, height * 0.041666668f, 0.04375f);
        GLRenderer.setDepthMask(false);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        EnumSignPicture picture = tileEntity.getPicture();
        if (picture != EnumSignPicture.NONE) {
            TileEntityRendererSign.drawTexturedModalRect(1.0, 0.5, colorSign, TextureRegistry.getTexture(picture.getTextureKey()));
        }
        GLRenderer.disableState(State.BLEND);
        GLRenderer.popFrame();
        float lightOffset = 0.0f;
        if (tileEntity.isGlowing()) {
            lightOffset = 96.0f;
            GLRenderer.setLightmapCoord2i(15, 15);
        }
        GLRenderer.pushFrame();
        float scale2 = 0.011111113f;
        GLRenderer.modelM4f().translate(0.0f, height * 0.041666668f, 0.045833334f);
        GLRenderer.modelM4f().scale(0.011111113f, -0.011111113f, 0.011111113f);
        GLRenderer.setDepthMask(false);
        int color = Colors.allSignColors[tileEntity.getColor().id].getARGB();
        int r = (int)MathHelper.clamp((float)Color.redFromInt(color) + lightOffset, 0.0f, 255.0f);
        int g = (int)MathHelper.clamp((float)Color.greenFromInt(color) + lightOffset, 0.0f, 255.0f);
        int b = (int)MathHelper.clamp((float)Color.blueFromInt(color) + lightOffset, 0.0f, 255.0f);
        color = Color.intToIntARGB(0, r, g, b);
        CharSequence line1 = tileEntity.signText[0];
        CharSequence line2 = tileEntity.signText[1];
        CharSequence line3 = tileEntity.signText[2];
        CharSequence line4 = tileEntity.signText[3];
        switch (tileEntity.lineBeingEdited) {
            case 0: {
                this.builder.setLength(0);
                line1 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line1).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 1: {
                this.builder.setLength(0);
                line2 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line2).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 2: {
                this.builder.setLength(0);
                line3 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line3).append("\u00a7+\u00a7f <\u00a7-");
                break;
            }
            case 3: {
                this.builder.setLength(0);
                line4 = this.builder.append("\u00a7+\u00a7f> \u00a7-").append(line4).append("\u00a7+\u00a7f <\u00a7-");
            }
        }
        boolean _x = false;
        int _y = -tileEntity.signText.length * 5;
        if (tileEntity.isGlowing() && GameSettings.TEXT_OUTLINE_QUALITY.value == TextOutlineQuality.FANCY) {
            GLRenderer.setLightmapCoord2i(15, 15);
            this.textMeshRenderer.render(this.fontRenderer, line1, line2, line3, line4, 0, _y, SF.setOutlined(SF.setColor(0L, color)));
        } else {
            this.textMeshRenderer.render(this.fontRenderer, line1, line2, line3, line4, 0, _y, SF.setColor(0L, color));
        }
        GLRenderer.popFrame();
        GLRenderer.setDepthMask(true);
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLRenderer.popFrame();
    }

    private static void drawTexturedModalRect(double width, double height, int color, @NotNull IconCoordinate coordinate) {
        coordinate.parentAtlas.bind();
        TessellatorShader tessellator = GLRenderer.getTessellator();
        tessellator.startDrawingQuads();
        tessellator.setColor2i(color, 128);
        tessellator.addVertexWithUV(-width / 2.0, height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMin());
        tessellator.addVertexWithUV(-width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMin(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, -height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMax());
        tessellator.addVertexWithUV(width / 2.0, height / 2.0, 0.0, coordinate.getIconUMax(), coordinate.getIconVMin());
        tessellator.draw();
    }

    @Override
    public void tick() {
        this.textMeshRenderer.tick();
    }

    @Override
    public boolean isVisible(@NotNull TileEntitySign tileEntity, @NotNull ICamera camera, float partialTick) {
        return camera.getFrustum().isVisible(new AABBd(tileEntity.x, tileEntity.y, tileEntity.z, tileEntity.x + 1, tileEntity.y + 1, tileEntity.z + 1), partialTick);
    }

    public static class BufferedTextMeshRenderer {
        private static final long MAX_NON_RENDERED_TIME = 120000L;
        @NotNull
        private final @NotNull Map<@NotNull MeshEntry, @NotNull MeshEntry> bufferedMeshes = new Object2ObjectOpenHashMap<MeshEntry, MeshEntry>();
        @NotNull
        private final MeshEntry referenceEntry = new MeshEntry("", "", "", "", 0L);

        public void tick() {
            Iterator<MeshEntry> iterator2 = this.bufferedMeshes.values().iterator();
            while (iterator2.hasNext()) {
                MeshEntry entry = iterator2.next();
                if (System.currentTimeMillis() - entry.lastUse <= 120000L) continue;
                iterator2.remove();
                entry.buffer.delete();
            }
        }

        public void render(@NotNull FontRendererDefault sr, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, int x, int y, long config) {
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate(x, y, 0.0f);
            this.renderInternal(sr, line1, line2, line3, line4, config);
            GLRenderer.popFrame();
        }

        private void renderInternal(@NotNull FontRendererDefault sr, @NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
            TessellatorFont.FontRenderBuffer buffer;
            this.referenceEntry.line1 = line1.toString();
            this.referenceEntry.line2 = line2.toString();
            this.referenceEntry.line3 = line3.toString();
            this.referenceEntry.line4 = line4.toString();
            this.referenceEntry.config = config;
            if (this.bufferedMeshes.containsKey(this.referenceEntry)) {
                MeshEntry entry = this.bufferedMeshes.get(this.referenceEntry);
                entry.lastUse = System.currentTimeMillis();
                buffer = entry.buffer;
            } else {
                Font font = sr.getFont();
                sr.getTessellator().startDrawing();
                sr.renderStringRaw(font, line1, -sr.stringWidth(line1) / 2, 0.0, 0.0, false, config);
                sr.renderStringRaw(font, line2, -sr.stringWidth(line2) / 2, 10.0, 0.0, false, config);
                sr.renderStringRaw(font, line3, -sr.stringWidth(line3) / 2, 20.0, 0.0, false, config);
                sr.renderStringRaw(font, line4, -sr.stringWidth(line4) / 2, 30.0, 0.0, false, config);
                buffer = sr.getTessellator().record(GL41.glGenVertexArrays(), GL41.glGenBuffers());
                MeshEntry entry = new MeshEntry(line1, line2, line3, line4, config);
                entry.buffer = buffer;
                entry.lastUse = System.currentTimeMillis();
                MeshEntry last = this.bufferedMeshes.put(entry, entry);
                if (last != null) {
                    last.buffer.delete();
                }
            }
            buffer.render();
        }

        public static class MeshEntry {
            public long config;
            @NotNull
            public String line1;
            @NotNull
            public String line2;
            @NotNull
            public String line3;
            @NotNull
            public String line4;
            public long lastUse = 0L;
            @Nullable
            public TessellatorFont.FontRenderBuffer buffer = null;

            public MeshEntry(@NotNull CharSequence line1, @NotNull CharSequence line2, @NotNull CharSequence line3, @NotNull CharSequence line4, long config) {
                this.config = config;
                this.line1 = line1.toString();
                this.line2 = line2.toString();
                this.line3 = line3.toString();
                this.line4 = line4.toString();
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MeshEntry entry = (MeshEntry)o;
                return this.config == entry.config && this.line1.equals(entry.line1) && this.line2.equals(entry.line2) && this.line3.equals(entry.line3) && this.line4.equals(entry.line4);
            }

            public int hashCode() {
                int result = Long.hashCode(this.config);
                result = 31 * result + this.line1.hashCode();
                result = 31 * result + this.line2.hashCode();
                result = 31 * result + this.line3.hashCode();
                result = 31 * result + this.line4.hashCode();
                return result;
            }
        }
    }
}

