/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import net.minecraft.client.option.GameSettings;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.colorizer.Colorizers;
import net.minecraft.client.render.worldtype.WorldTypeFX;
import net.minecraft.client.render.worldtype.WorldTypeFXDispatcher;
import net.minecraft.client.world.chunk.provider.ChunkProviderViewer;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.saveddata.SavedDataStorage;
import net.minecraft.core.world.season.SeasonManager;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.core.world.weather.IPrecipitation;
import net.minecraft.core.world.weather.WeatherManager;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class WorldClient
extends World {
    public static final WorldClient EMPTY_WORLD = new WorldClient();

    public WorldClient(@NotNull LevelStorage levelStorage, @Nullable String name, long seed, @NotNull Dimension dimension, @Nullable Biome startingBiome) {
        super(levelStorage, name, seed, dimension, startingBiome);
    }

    public WorldClient(@NotNull World world, @NotNull Dimension dimension) {
        super(world, dimension);
    }

    public WorldClient(@NotNull SavedDataStorage savedDataStorage, @NotNull String name, long seed, @NotNull Dimension dimension, @NotNull WorldType worldType) {
        super(savedDataStorage, name, seed, dimension, worldType);
    }

    public WorldClient() {
        this.dimension = Dimension.OVERWORLD;
        this.worldType = WorldTypes.DEBUG;
        this.chunkProvider = new ChunkProviderViewer(this);
        this.seasonManager = SeasonManager.fromConfig(this, this.worldType.getSeasonConfig());
        this.updateSkyBrightness();
        this.weatherManager = new WeatherManager(this);
        this.biomeProvider = this.worldType.createBiomeProvider(this);
    }

    @Override
    public void spawnPlayerWithLoadedChunks(Player player, boolean respawning) {
        super.spawnPlayerWithLoadedChunks(player, respawning);
        this.getLevelData().setLastPlayerUUID(player.uuid);
    }

    @NotNull
    public Vector3fc getDimensionColor(@NotNull ICamera camera, float partialTick) {
        float f6;
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        int color = 0xFFFFFF;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float f = f6 = this.getCurrentWeather() != null && this.getCurrentWeather() instanceof IPrecipitation ? this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower() : 0.0f;
        if (f6 > 0.0f) {
            float f7 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f9 = 1.0f - f6 * 0.95f;
            r = r * f9 + f7 * (1.0f - f9);
            g = g * f9 + f7 * (1.0f - f9);
            b = b * f9 + f7 * (1.0f - f9);
        }
        return new Vector3f(r *= f2 * 0.9f + 0.1f, g *= f2 * 0.9f + 0.1f, b *= f2 * 0.85f + 0.15f);
    }

    @NotNull
    public Vector3fc getFogColor(@NotNull ICamera camera, float partialTick) {
        double x = camera.getX(partialTick);
        double y = camera.getY(partialTick);
        double z = camera.getZ(partialTick);
        float celestialAngle = this.getCelestialAngle(partialTick);
        return ((WorldTypeFX)WorldTypeFXDispatcher.getInstance().getDispatch(this.worldType)).getFogColor(this, x, y, z, celestialAngle, partialTick);
    }

    @NotNull
    public Vector3fc getSkyColor(@NotNull ICamera camera, float partialTick) {
        float fogIntensity;
        float f7;
        float f1 = this.getCelestialAngle(partialTick);
        float f2 = MathHelper.cos(f1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        TilePos blockPos = camera.getTilePos(partialTick);
        float blockTemperature = (float)this.getBlockTemperature(blockPos);
        if (this.seasonManager.getCurrentSeason() != null && (this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_WINTER || this.seasonManager.getCurrentSeason() == Seasons.OVERWORLD_FALL)) {
            blockTemperature -= 1.25f;
        }
        int skyColor = Colorizers.sky.isEnabled() ? Colorizers.sky.getColor(this, blockPos) : this.getBiomeProvider().getBiome(blockPos.x, blockPos.y, blockPos.z).getSkyColor(blockTemperature);
        float r = (float)(skyColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(skyColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(skyColor & 0xFF) / 255.0f;
        r *= f2;
        g *= f2;
        b *= f2;
        float f = f7 = this.getCurrentWeather() != null && this.getCurrentWeather() instanceof IPrecipitation ? this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower() : 0.0f;
        if (f7 > 0.0f) {
            float f8 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f10 = 1.0f - f7 * 0.75f;
            r = r * f10 + f8 * (1.0f - f10);
            g = g * f10 + f8 * (1.0f - f10);
            b = b * f10 + f8 * (1.0f - f10);
        }
        float f3 = fogIntensity = this.getCurrentWeather() != null && this.getCurrentWeather() == Weathers.OVERWORLD_FOG ? this.weatherManager.getWeatherIntensity() * this.weatherManager.getWeatherPower() : 0.0f;
        if (fogIntensity > 0.0f) {
            float f8 = (r * 0.5f + g * 0.5f + b * 0.5f) * 0.6f;
            float f10 = 1.0f - fogIntensity * 0.75f;
            r = r * f10 + f8 * (1.0f - f10);
            g = g * f10 + f8 * (1.0f - f10);
            b = b * f10 + f8 * (1.0f - f10);
        }
        if (this.lightningFlicker > 0) {
            float f12 = (float)this.lightningFlicker - partialTick;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            r = r * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            g = g * (1.0f - f12) + 0.8f * f12;
            b = b * (1.0f - f12) + f12;
        }
        return new Vector3f(r, g, b);
    }

    @Override
    public int renderDistance() {
        return (Integer)GameSettings.RENDER_DISTANCE.value;
    }
}

