/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemFireStriker;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicBrazier
extends BlockLogic {
    private final boolean burning;

    public BlockLogicBrazier(@NotNull Block<?> block, boolean burning) {
        super(block, Materials.METAL);
        this.burning = burning;
    }

    public boolean isBurning() {
        return this.burning;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side == Side.BOTTOM) {
            return FullSupport.INSTANCE;
        }
        return PartialSupport.INSTANCE;
    }

    @Override
    public @NotNull ItemStack @Nullable [] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.BRAZIER_INACTIVE, 1)};
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        @Nullable ItemStack heldItem = player.getHeldItem();
        if (heldItem != null && heldItem.getItem() instanceof ItemFireStriker && !this.burning) {
            TilePos queryPos = new TilePos();
            if (world.getBlockType(tilePos.add(Direction.EAST, queryPos)).getLogic() instanceof BlockLogicFluid || world.getBlockType(tilePos.add(Direction.WEST, queryPos)).getLogic() instanceof BlockLogicFluid || world.getBlockType(tilePos.add(Direction.SOUTH, queryPos)).getLogic() instanceof BlockLogicFluid || world.getBlockType(tilePos.add(Direction.NORTH, queryPos)).getLogic() instanceof BlockLogicFluid) {
                return false;
            }
            world.setBlockTypeNotify(tilePos, Blocks.BRAZIER_ACTIVE);
            heldItem.damageItem(1, player);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "fire.ignite", 1.0f, world.rand.nextFloat() * 0.4f + 0.8f);
            return true;
        }
        if (heldItem == null && this.burning) {
            world.setBlockTypeNotify(tilePos, Blocks.BRAZIER_INACTIVE);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        if (this.burning) {
            world.setBlockTypeNotify(tilePos, Blocks.BRAZIER_INACTIVE);
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        if (this.burning) {
            Blocks.FIRE.onRemoved(world, tilePos, data);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.burning) {
            return;
        }
        if (block.getLogic() instanceof BlockLogicFluid) {
            world.setBlockTypeNotify(tilePos, Blocks.BRAZIER_INACTIVE);
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (this.burning) {
            Blocks.FIRE.animationTick(world, tilePos, rand);
        }
    }
}

