/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Random;
import net.minecraft.core.block.BlockLogicSand;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.ChunkDecoration;
import net.minecraft.core.world.generate.chunk.ChunkDecorator;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkFeatureDecorator
implements ChunkDecorator {
    private boolean initialized = false;
    @NotNull
    private final World world;
    @NotNull
    private final Object2IntMap<ChunkDecoration> decorations = new Object2IntOpenHashMap<ChunkDecoration>();

    public ChunkFeatureDecorator(@NotNull World world) {
        this.world = world;
    }

    final void registerDecorationsSetup() {
        if (!this.initialized) {
            this.registerDecorations();
            this.initialized = true;
        }
    }

    public abstract void registerDecorations();

    @NotNull
    public final ChunkFeatureDecorator register(int seed, @NotNull ChunkDecoration decoration) {
        this.decorations.put(decoration, seed);
        return this;
    }

    @Override
    public final void decorate(@NotNull Chunk chunk) {
        this.world.scheduledUpdatesAreImmediate = true;
        BlockLogicSand.fallInstantly = true;
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        int minY = this.world.getWorldType().getMinY();
        int maxY = this.world.getWorldType().getMaxY();
        int rangeY = maxY + 1 - minY;
        @NotNull Random rand = new Random(this.world.getRandomSeed());
        long a = rand.nextLong() / 2L * 2L + 1L;
        long b = rand.nextLong() / 2L * 2L + 1L;
        for (ChunkDecoration decoration : this.decorations.keySet()) {
            int decorationSeed = this.decorations.getInt(decoration);
            rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.getRandomSeed() ^ (long)decorationSeed);
            decoration.placeDecoration(this.world, chunk, worldX, worldZ, minY, maxY, rangeY, rand);
        }
        this.postDecorate(this.world, chunk);
        BlockLogicSand.fallInstantly = false;
        this.world.scheduledUpdatesAreImmediate = false;
    }

    public abstract void postDecorate(@NotNull World var1, @NotNull Chunk var2);
}

