/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.classic;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.CavesLargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import net.minecraft.core.world.generate.chunk.perlin.SurfaceGenerator;
import net.minecraft.core.world.generate.chunk.perlin.overworld.retro.ChunkDecoratorOverworldRetro;
import net.minecraft.core.world.generate.chunk.perlin.overworld.retro.SurfaceGeneratorOverworldRetro;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.operator.Constant2D;
import net.minecraft.core.world.noise.operator.Warp2D;
import org.jetbrains.annotations.NotNull;

public class ChunkGeneratorClassic
extends ChunkGenerator {
    @NotNull
    private final Warp2D<FractalNoise2D<ImprovedPerlinNoise>, FractalNoise2D<ImprovedPerlinNoise>, Constant2D> combinedA;
    @NotNull
    private final Warp2D<FractalNoise2D<ImprovedPerlinNoise>, FractalNoise2D<ImprovedPerlinNoise>, Constant2D> combinedB;
    @NotNull
    private final Warp2D<FractalNoise2D<ImprovedPerlinNoise>, FractalNoise2D<ImprovedPerlinNoise>, Constant2D> combinedC;
    @NotNull
    private final Warp2D<FractalNoise2D<ImprovedPerlinNoise>, FractalNoise2D<ImprovedPerlinNoise>, Constant2D> combinedD;
    @NotNull
    private final FractalNoise2D<ImprovedPerlinNoise> octavesA;
    @NotNull
    private final FractalNoise2D<ImprovedPerlinNoise> octavesB;
    @NotNull
    private final SurfaceGenerator sg;
    @NotNull
    private final CavesLargeFeature cg;

    public ChunkGeneratorClassic(@NotNull World world) {
        super(world, new ChunkDecoratorOverworldRetro(world));
        long seed = world.getRandomSeed();
        this.combinedA = new Warp2D<FractalNoise2D, FractalNoise2D, Constant2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 0, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 8, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new Constant2D(0.0));
        this.combinedB = new Warp2D<FractalNoise2D, FractalNoise2D, Constant2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 16, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 24, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new Constant2D(0.0));
        this.combinedC = new Warp2D<FractalNoise2D, FractalNoise2D, Constant2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 32, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 40, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new Constant2D(0.0));
        this.combinedD = new Warp2D<FractalNoise2D, FractalNoise2D, Constant2D>(new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 48, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 56, ImprovedPerlinNoise.LegacyNoiseType.ALPHA)), new Constant2D(0.0));
        this.octavesA = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 64, ImprovedPerlinNoise.LegacyNoiseType.ALPHA));
        this.octavesB = new FractalNoise2D((Noise2D[])ImprovedPerlinNoise.genOctaves(seed, 8, 70, ImprovedPerlinNoise.LegacyNoiseType.ALPHA));
        this.sg = new SurfaceGeneratorOverworldRetro(world);
        this.cg = new CavesLargeFeature();
    }

    @Override
    @NotNull
    protected ChunkGeneratorResult doBlockGeneration(@NotNull Chunk chunk) {
        int val2;
        int x;
        ChunkGeneratorResult result = new ChunkGeneratorResult();
        int chunkX = chunk.pos.x;
        int chunkZ = chunk.pos.z;
        float mod = 1.3f;
        int[] heightMap = new int[256];
        for (int x2 = 0; x2 < 16; ++x2) {
            for (int z = 0; z < 16; ++z) {
                double d;
                double noiseA = this.combinedA.getValue((float)(chunkX * 16 + x2) * 1.3f, (float)(chunkZ * 16 + z) * 1.3f) / 6.0 + -4.0;
                double noiseB = this.combinedB.getValue((float)(chunkX * 16 + x2) * 1.3f, (float)(chunkZ * 16 + z) * 1.3f) / 5.0 + 10.0 + -4.0;
                if (this.octavesA.getValue(chunkX * 16 + x2, chunkZ * 16 + z) / 8.0 > 0.0) {
                    noiseB = noiseA;
                }
                double height = Math.max(noiseA, noiseB) / 2.0;
                if (d < 0.0) {
                    height *= 0.8;
                }
                heightMap[x2 + z * 16] = (int)height;
            }
        }
        int[] newHeightMap = heightMap;
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int newHeight;
                double val = this.combinedC.getValue(chunkX * 16 + x << 1, chunkZ * 16 + z << 1) / 8.0;
                int n = val2 = this.combinedD.getValue(chunkX * 16 + x << 1, chunkZ * 16 + z << 1) > 0.0 ? 1 : 0;
                if (!(val > 2.0)) continue;
                newHeightMap[x + z * 16] = newHeight = ((newHeightMap[x + z * 16] - val2) / 2 << 1) + val2;
            }
        }
        for (x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int val = (int)(this.octavesB.getValue(chunkX * 16 + x, chunkZ * 16 + z) / 24.0) - 4;
                int newHeight = newHeightMap[x + z * 16] + this.world.getWorldType().getOceanY();
                val2 = newHeight + val;
                newHeightMap[x + z * 16] = Math.max(newHeight, val2);
                if (newHeightMap[x + z * 16] > this.world.getWorldType().getMaxY() - 2) {
                    newHeightMap[x + z * 16] = this.world.getWorldType().getMaxY() - 2;
                }
                if (newHeightMap[x + z * 16] < 1) {
                    newHeightMap[x + z * 16] = 1;
                }
                for (int y = this.world.getWorldType().getMinY(); y < this.world.getWorldType().getMaxY(); ++y) {
                    int index = Chunk.makeBlockIndex(x, y, z);
                    int blockID = 0;
                    if (y < newHeight) {
                        blockID = this.world.getWorldType().getFillerBlockId();
                    } else if (y < this.world.getWorldType().getOceanY()) {
                        blockID = this.world.getWorldType().getOceanBlockId();
                    }
                    if (y == 0) {
                        blockID = Blocks.BEDROCK.id();
                    }
                    result.setBlock(x, y, z, blockID);
                }
            }
        }
        this.sg.generateSurface(chunk, result);
        this.cg.generate(this.world, chunkX, chunkZ, result);
        return result;
    }
}

