/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNodeVisibilityListener;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericSettingNode
implements KeyedSettingNode {
    @NotNull
    private final String key;
    @Nullable
    private SettingNodeChildrenProvider childrenProvider = null;
    @NotNull
    private SettingNodeVisibilityListener selfVisibilityListener = SettingNodeVisibilityListener::alwaysVisible;
    @NotNull
    private SettingNodeVisibilityListener childrenVisibilityListener = SettingNodeVisibilityListener::alwaysVisible;

    public GenericSettingNode(@NotNull String key) {
        this.key = key;
        KeyedSettingNode.checkKeyIsUnique(key);
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public SettingNodeChildrenProvider getChildrenProvider() {
        return this.childrenProvider;
    }

    @NotNull
    public final GenericSettingNode withChildrenProvider(@NotNull SettingNodeChildrenProvider childrenProvider) {
        this.childrenProvider = childrenProvider;
        return this;
    }

    @Override
    public boolean isVisible(@NotNull WorldConfiguration worldConfiguration) {
        return this.selfVisibilityListener.isVisible(worldConfiguration);
    }

    @NotNull
    public final GenericSettingNode withVisibilityListener(@NotNull SettingNodeVisibilityListener visibilityListener) {
        this.selfVisibilityListener = visibilityListener;
        return this;
    }

    @Override
    public boolean areChildrenVisible(@NotNull WorldConfiguration worldConfiguration) {
        return this.isVisible(worldConfiguration) && this.childrenVisibilityListener.isVisible(worldConfiguration);
    }

    @NotNull
    public final GenericSettingNode withChildrenVisibilityListener(@NotNull SettingNodeVisibilityListener visibilityListener) {
        this.childrenVisibilityListener = visibilityListener;
        return this;
    }
}

