/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.generate.LargeFeature;
import net.minecraft.core.world.generate.chunk.ChunkGeneratorResult;
import org.jetbrains.annotations.NotNull;

public class CavesLargeFeature
extends LargeFeature {
    private final int minY;
    private final int maxY;

    public CavesLargeFeature() {
        this.minY = 0;
        this.maxY = 256;
    }

    public CavesLargeFeature(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    protected void generateHubRoom(@NotNull World world, @NotNull Random random, long seed, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result, double blockX, double blockY, double blockZ) {
        this.generateCave(world, random, seed, baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, 1.0f + random.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCave(@NotNull World world, @NotNull Random random, long seed, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result, double blockX, double blockY, double blockZ, float initialRadius, float yRot, float xRot, int startPos, int endPos, double heightMod) {
        boolean sharpRotVer;
        double chunkMiddleX = baseChunkX * 16 + 8;
        double chunkMiddleZ = baseChunkZ * 16 + 8;
        float rotHorOffset = 0.0f;
        float rotVerOffset = 0.0f;
        Random r = new Random(seed);
        if (endPos <= 0) {
            int maxLength = this.getRadiusChunk() * 16 - 16;
            endPos = maxLength - r.nextInt(maxLength / 4);
        }
        boolean noBranches = false;
        if (startPos == -1) {
            startPos = endPos / 2;
            noBranches = true;
        }
        int branchPos = r.nextInt(endPos / 2) + endPos / 4;
        boolean bl = sharpRotVer = r.nextInt(6) == 0;
        while (startPos < endPos) {
            block28: {
                int maxZ;
                int maxY;
                int minY;
                int maxX;
                double height;
                double width;
                block29: {
                    width = 1.5 + (double)(MathHelper.sin((float)startPos * (float)Math.PI / (float)endPos) * initialRadius * 1.0f);
                    height = width * heightMod;
                    float xzScale = MathHelper.cos(xRot);
                    float yOffset = MathHelper.sin(xRot);
                    blockX += (double)(MathHelper.cos(yRot) * xzScale);
                    blockY += (double)yOffset;
                    blockZ += (double)(MathHelper.sin(yRot) * xzScale);
                    xRot = sharpRotVer ? (xRot *= 0.92f) : (xRot *= 0.7f);
                    xRot += rotVerOffset * 0.1f;
                    yRot += rotHorOffset * 0.1f;
                    rotVerOffset *= 0.9f;
                    rotHorOffset *= 0.75f;
                    rotVerOffset += (r.nextFloat() - r.nextFloat()) * r.nextFloat() * 2.0f;
                    rotHorOffset += (r.nextFloat() - r.nextFloat()) * r.nextFloat() * 4.0f;
                    if (!noBranches && startPos == branchPos && initialRadius > 1.0f) {
                        this.generateCave(world, random, r.nextLong(), baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, r.nextFloat() * 0.5f + 0.5f, yRot - 1.5707964f, xRot / 3.0f, startPos, endPos, 1.0);
                        this.generateCave(world, random, r.nextLong(), baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, r.nextFloat() * 0.5f + 0.5f, yRot + 1.5707964f, xRot / 3.0f, startPos, endPos, 1.0);
                        return;
                    }
                    if (!noBranches && r.nextInt(4) == 0) break block28;
                    double dxFromMiddle = blockX - chunkMiddleX;
                    double dzFromMiddle = blockZ - chunkMiddleZ;
                    double length = endPos - startPos;
                    double maxRadius = initialRadius + 2.0f + 16.0f;
                    if (dxFromMiddle * dxFromMiddle + dzFromMiddle * dzFromMiddle - length * length > maxRadius * maxRadius) {
                        return;
                    }
                    if (blockX < chunkMiddleX - 16.0 - width * 2.0 || blockZ < chunkMiddleZ - 16.0 - width * 2.0 || blockX > chunkMiddleX + 16.0 + width * 2.0 || blockZ > chunkMiddleZ + 16.0 + width * 2.0) break block28;
                    int minX = MathHelper.floor(blockX - width) - baseChunkX * 16 - 1;
                    maxX = MathHelper.floor(blockX + width) - baseChunkX * 16 + 1;
                    minY = MathHelper.floor(blockY - height) - 1;
                    maxY = MathHelper.floor(blockY + height) + 1;
                    int minZ = MathHelper.floor(blockZ - width) - baseChunkZ * 16 - 1;
                    maxZ = MathHelper.floor(blockZ + width) - baseChunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < this.minY + 1) {
                        minY = this.minY + 1;
                    }
                    if (maxY > this.maxY - 8) {
                        maxY = this.maxY - 8;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    if (world.getWorldType().getOceanBlockId() == 0) break block29;
                    boolean hasHitOcean = false;
                    for (int x = minX; !hasHitOcean && x < maxX; ++x) {
                        for (int z = minZ; !hasHitOcean && z < maxZ; ++z) {
                            for (int y = maxY + 1; !hasHitOcean && y >= minY - 1; --y) {
                                int blockId = result.getBlock(x, y, z);
                                if (y < this.minY || y >= this.maxY) continue;
                                if (blockId == world.getWorldType().getOceanBlockId()) {
                                    hasHitOcean = true;
                                }
                                if (y == minY - 1 || x == minX || x == maxX - 1 || z == minZ || z == maxZ - 1) continue;
                                y = minY;
                            }
                        }
                    }
                    if (hasHitOcean) break block28;
                }
                for (int x = minX; x < maxX; ++x) {
                    double xPercentage = ((double)(x + baseChunkX * 16) + 0.5 - blockX) / width;
                    for (int z = minZ; z < maxZ; ++z) {
                        double zPercentage = ((double)(z + baseChunkZ * 16) + 0.5 - blockZ) / width;
                        int yIndex = maxY;
                        boolean replaceTopBlock = false;
                        if (xPercentage * xPercentage + zPercentage * zPercentage >= 1.0) continue;
                        for (int y = maxY - 1; y >= minY; --y) {
                            double yPercentage = ((double)y + 0.5 - blockY) / height;
                            if (yPercentage > -0.7 && xPercentage * xPercentage + yPercentage * yPercentage + zPercentage * zPercentage < 1.0) {
                                int blockId = result.getBlock(x, yIndex, z);
                                if (Blocks.hasTag(blockId, BlockTags.CAVE_GEN_REPLACES_SURFACE)) {
                                    replaceTopBlock = true;
                                }
                                if (Blocks.hasTag(blockId, BlockTags.CAVES_CUT_THROUGH)) {
                                    if (y < 10) {
                                        result.setBlock(x, yIndex, z, Blocks.FLUID_LAVA_STILL.id());
                                    } else {
                                        result.setBlock(x, yIndex, z, 0);
                                        if (replaceTopBlock) {
                                            Biome biome = world.getBlockBiome(x, yIndex - 1, z);
                                            short topBlockId = biome.topBlock;
                                            short fillBlockId = biome.fillerBlock;
                                            int id = result.getBlock(x, yIndex - 1, z);
                                            if (id == fillBlockId) {
                                                result.setBlock(x, yIndex - 1, z, topBlockId);
                                            }
                                        }
                                    }
                                }
                            }
                            --yIndex;
                        }
                    }
                }
                if (noBranches) break;
            }
            ++startPos;
        }
    }

    @Override
    protected void doGeneration(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, int baseChunkX, int baseChunkZ, @NotNull ChunkGeneratorResult result) {
        int cavesToGenerate = random.nextInt(random.nextInt(random.nextInt(40) + 1) + 1);
        if (random.nextInt(15) != 0) {
            cavesToGenerate = 0;
        }
        int yRange = this.maxY - this.minY;
        for (int i = 0; i < cavesToGenerate; ++i) {
            double blockX = chunkX * 16 + random.nextInt(16);
            double blockY = this.minY + random.nextInt(random.nextInt(yRange - 8) + 8);
            double blockZ = chunkZ * 16 + random.nextInt(16);
            int numBranches = 1;
            if (random.nextInt(4) == 0) {
                this.generateHubRoom(world, random, random.nextLong(), baseChunkX, baseChunkZ, result, blockX, blockY, blockZ);
                numBranches += random.nextInt(4);
            }
            for (int l1 = 0; l1 < numBranches; ++l1) {
                float yRot = random.nextFloat() * (float)Math.PI * 2.0f;
                float xRot = (random.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float initialRadius = random.nextFloat() * 2.0f + random.nextFloat();
                this.generateCave(world, random, random.nextLong(), baseChunkX, baseChunkZ, result, blockX, blockY, blockZ, initialRadius, yRot, xRot, 0, 0, 1.0);
            }
        }
    }
}

