/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import java.io.File;
import java.util.List;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkLoaderRegion;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorageBase;
import net.minecraft.core.world.save.PlayerIO;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LevelStorageServer
extends LevelStorageBase
implements PlayerIO {
    private static final Logger LOGGER = LogUtils.getLogger();

    public LevelStorageServer(ISaveFormat saveFormat, File savesDir, String worldDirName, boolean isMultiplayer) {
        super(saveFormat, savesDir, worldDirName);
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        File dimDir = this.saveFormat.getDimensionRootDir(this.worldDirName, dimension);
        dimDir.mkdirs();
        return new ChunkLoaderRegion(dimDir);
    }

    @Override
    public void saveLevelDataAndPlayerData(@NotNull LevelData levelData, @NotNull List<Player> playerList) {
        levelData.setSaveVersion(this.saveFormat.getSaveVersion());
        super.saveLevelDataAndPlayerData(levelData, playerList);
    }

    @Override
    public void load(@NotNull Player player) {
        CompoundTag tag = this.getPlayerData(player.username, player.uuid);
        if (tag != null) {
            player.load(tag);
        }
    }
}

