/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import java.util.Objects;
import net.minecraft.core.lang.text.IntoText;
import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.world.settings.GenericSettingNode;
import net.minecraft.core.world.settings.ValueSettingNode;
import org.jetbrains.annotations.NotNull;

public class ValueGenericSettingNode<T>
extends GenericSettingNode
implements ValueSettingNode<T> {
    @NotNull
    private final Text name;
    @NotNull
    private final T value;

    public ValueGenericSettingNode(@NotNull String key, @NotNull Text name, @NotNull T defaultValue) {
        super(key);
        this.name = name;
        this.value = defaultValue;
    }

    @Override
    @NotNull
    public @NotNull Class<@NotNull T> getValueClass() {
        return this.value.getClass();
    }

    @Override
    @NotNull
    public final T getDefaultValue() {
        return this.value;
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull T value) {
        if (value instanceof IntoText) {
            @NotNull IntoText intoText = (IntoText)value;
            return intoText.intoText();
        }
        return new LiteralText(Objects.requireNonNull(value.toString()));
    }

    @Override
    @NotNull
    public Text getName() {
        return this.name;
    }
}

